/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.AggregateResourceBundle;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.minifier.MinifierUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.servlet.filters.dynamiccss.DynamicCSSUtil;
import com.liferay.portal.util.AggregateUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletConfigFactoryUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private static Log _log = LogFactoryUtil.getLog(ComboServlet.class);
    private static PortalCache<String, byte[][]> _bytesArrayPortalCache = SingleVMPoolUtil.getCache((String)ComboServlet.class.getName());
    private static PortalCache<String, FileContentBag> _fileContentBagPortalCache = SingleVMPoolUtil.getCache((String)FileContentBag.class.getName());
    private Set<String> _protectedParameters = SetUtil.fromArray((Object[])new String[]{"b", "browserId", "minifierType", "languageId", "t", "themeId"});

    public static void clearCache() {
        _bytesArrayPortalCache.removeAll();
        _fileContentBagPortalCache.removeAll();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.doService(request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            PortalUtil.sendError((int)500, (Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected static String getModulePortletId(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return modulePath.substring(0, index);
        }
        return "90";
    }

    protected static String getResourcePath(String modulePath) {
        int index = modulePath.indexOf(58);
        if (index > 0) {
            return modulePath.substring(index + 1);
        }
        return modulePath;
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        LinkedHashSet<String> modulePathsSet = new LinkedHashSet<String>();
        Map parameterMap = HttpUtil.getParameterMap((String)request.getQueryString());
        Enumeration enu = Collections.enumeration(parameterMap.keySet());
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (this._protectedParameters.contains(name)) continue;
            name = HttpUtil.decodePath((String)name);
            modulePathsSet.add(name);
        }
        if (modulePathsSet.isEmpty()) {
            response.sendError(400, "Modules paths set is empty");
            return;
        }
        Object[] modulePaths = modulePathsSet.toArray(new String[modulePathsSet.size()]);
        String firstModulePath = modulePaths[0];
        String extension = FileUtil.getExtension((String)firstModulePath);
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        if (Validator.isNull((String)minifierType)) {
            minifierType = "js";
            if (StringUtil.equalsIgnoreCase((String)extension, (String)_CSS_EXTENSION)) {
                minifierType = _CSS_EXTENSION;
            }
        }
        if (!minifierType.equals(_CSS_EXTENSION) && !minifierType.equals("js")) {
            minifierType = "js";
        }
        String modulePathsString = null;
        Object bytesArray = null;
        if (!PropsValues.COMBO_CHECK_TIMESTAMP) {
            modulePathsString = Arrays.toString(modulePaths);
            if (minifierType.equals(_CSS_EXTENSION) && PortalUtil.isRightToLeft((HttpServletRequest)request)) {
                modulePathsString = modulePathsString + ".rtl";
            }
            bytesArray = (byte[][])_bytesArrayPortalCache.get((Serializable)((Object)modulePathsString));
        }
        if (bytesArray == null) {
            bytesArray = new byte[modulePaths.length][];
            for (int i = 0; i < modulePaths.length; ++i) {
                Object modulePath = modulePaths[i];
                if (!this.validateModuleExtension((String)modulePath)) {
                    response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    response.setStatus(404);
                    return;
                }
                byte[] bytes = new byte[]{};
                if (Validator.isNotNull((String)modulePath)) {
                    URL url = this.getResourceURL(request, (String)modulePath);
                    if (url == null) {
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                        response.setStatus(404);
                        return;
                    }
                    bytes = this.getResourceContent(request, response, url, (String)modulePath, minifierType);
                }
                bytesArray[i] = bytes;
            }
            if (modulePathsString != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
                _bytesArrayPortalCache.put((Serializable)((Object)modulePathsString), bytesArray);
            }
        }
        String contentType = "text/javascript";
        if (StringUtil.equalsIgnoreCase((String)extension, (String)_CSS_EXTENSION)) {
            contentType = "text/css";
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected byte[] getResourceContent(HttpServletRequest request, HttpServletResponse response, URL resourceURL, String modulePath, String minifierType) throws IOException {
        String fileContentKey;
        FileContentBag fileContentBag;
        String portletId;
        Portlet portlet;
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (!resourcePath.startsWith((portlet = PortletLocalServiceUtil.getPortletById((String)(portletId = ComboServlet.getModulePortletId(modulePath)))).getContextPath())) {
            resourcePath = portlet.getContextPath() + resourcePath;
        }
        if ((fileContentBag = (FileContentBag)_fileContentBagPortalCache.get((Serializable)((Object)(fileContentKey = resourcePath.concat("?").concat(minifierType))))) != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        URLConnection urlConnection = null;
        if (resourceURL != null) {
            urlConnection = resourceURL.openConnection();
        }
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            long elapsedTime = System.currentTimeMillis() - fileContentBag._lastModified;
            if (urlConnection != null && elapsedTime <= PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL && urlConnection.getLastModified() == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            _fileContentBagPortalCache.remove((Serializable)((Object)fileContentKey));
        }
        if (resourceURL == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            String stringFileContent = StringUtil.read((InputStream)urlConnection.getInputStream());
            if (!StringUtil.endsWith((String)resourcePath, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)resourcePath, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    try {
                        stringFileContent = DynamicCSSUtil.parseSass(this.getServletContext(), request, resourcePath, stringFileContent);
                    }
                    catch (Exception e) {
                        _log.error((Object)("Unable to parse SASS on CSS " + resourceURL.getPath()), (Throwable)e);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)stringFileContent);
                        }
                        response.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
                    }
                    String baseURL = "";
                    int slashIndex = resourcePath.lastIndexOf(47);
                    if (slashIndex != -1) {
                        baseURL = resourcePath.substring(0, slashIndex + 1);
                    }
                    stringFileContent = AggregateUtil.updateRelativeURLs(stringFileContent, baseURL);
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = this.translate(request, portletId, stringFileContent);
                    stringFileContent = MinifierUtil.minifyJavaScript(resourcePath, stringFileContent);
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), urlConnection.getLastModified());
        }
        if (PropsValues.COMBO_CHECK_TIMESTAMP) {
            int timeToLive = (int)(PropsValues.COMBO_CHECK_TIMESTAMP_INTERVAL / 1000L);
            _fileContentBagPortalCache.put((Serializable)((Object)fileContentKey), (Object)fileContentBag, timeToLive);
        }
        return fileContentBag._fileContent;
    }

    protected URL getResourceURL(HttpServletRequest request, String modulePath) throws Exception {
        URL url;
        String contextPath;
        String portletId = ComboServlet.getModulePortletId(modulePath);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        if (portlet.isUndeployedPortlet()) {
            return null;
        }
        PortletApp portletApp = portlet.getPortletApp();
        ServletContext servletContext = portletApp.getServletContext();
        String resourcePath = ComboServlet.getResourcePath(modulePath);
        if (resourcePath.startsWith(contextPath = servletContext.getContextPath())) {
            resourcePath = resourcePath.substring(contextPath.length());
        }
        if ((url = servletContext.getResource(resourcePath)) != null) {
            return url;
        }
        url = new URL(request.getScheme(), request.getLocalAddr(), request.getLocalPort(), contextPath + resourcePath);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (urlConnection.getResponseCode() == 200) {
            return url;
        }
        throw new ServletException("Resource " + resourcePath + " does not exist in " + portlet.getContextPath());
    }

    protected String translate(HttpServletRequest request, String portletId, String stringFileContent) {
        PortletConfig portletConfig;
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        ResourceBundle resourceBundle = LanguageResources.getResourceBundle(locale);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletId);
        if (portlet != null && (portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)this.getServletContext())) != null) {
            resourceBundle = new AggregateResourceBundle(portletConfig.getResourceBundle(locale), resourceBundle);
        }
        return LanguageUtil.process((ResourceBundle)resourceBundle, (Locale)locale, (String)stringFileContent);
    }

    protected boolean validateModuleExtension(String moduleName) throws Exception {
        String[] fileExtensions;
        int index = moduleName.indexOf(63);
        if (index != -1) {
            moduleName = moduleName.substring(0, index);
        }
        boolean validModuleExtension = false;
        for (String fileExtension : fileExtensions = PrefsPropsUtil.getStringArray("combo.allowed.file.extensions", ",")) {
            if (!"*".equals(fileExtension) && !StringUtil.endsWith((String)moduleName, (String)fileExtension)) continue;
            validModuleExtension = true;
            break;
        }
        return validModuleExtension;
    }

    private static class FileContentBag
    implements Serializable {
        private byte[] _fileContent;
        private long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

