/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.util.ClassLoaderUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ClassLoaderRequestDispatcherWrapper
implements RequestDispatcher {
    private RequestDispatcher _requestDispatcher;
    private ServletContext _servletContext;

    public ClassLoaderRequestDispatcherWrapper(ServletContext servletContext, RequestDispatcher requestDispatcher) {
        this._servletContext = servletContext;
        this._requestDispatcher = requestDispatcher;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, false);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        this.doDispatch(servletRequest, servletResponse, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispatch(ServletRequest servletRequest, ServletResponse servletResponse, boolean include) throws IOException, ServletException {
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        ClassLoader pluginClassLoader = (ClassLoader)this._servletContext.getAttribute("PLUGIN_CLASS_LOADER");
        try {
            if (pluginClassLoader == null) {
                ClassLoaderUtil.setContextClassLoader(ClassLoaderUtil.getPortalClassLoader());
            } else {
                ClassLoaderUtil.setContextClassLoader(pluginClassLoader);
            }
            if (include) {
                this._requestDispatcher.include(servletRequest, servletResponse);
            } else {
                this._requestDispatcher.forward(servletRequest, servletResponse);
            }
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(contextClassLoader);
        }
    }
}

