/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.CustomSQLParam;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.persistence.GroupUtil;
import com.liferay.portal.service.persistence.RoleUtil;
import com.liferay.portal.service.persistence.UserFinder;
import com.liferay.portal.service.persistence.UserUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UserFinderImpl
extends BasePersistenceImpl<User>
implements UserFinder {
    public static final String COUNT_BY_SOCIAL_USERS = UserFinder.class.getName() + ".countBySocialUsers";
    public static final String COUNT_BY_USER = UserFinder.class.getName() + ".countByUser";
    public static final String FIND_BY_NO_ANNOUNCEMENTS_DELIVERIES = UserFinder.class.getName() + ".findByNoAnnouncementsDeliveries";
    public static final String FIND_BY_NO_CONTACTS = UserFinder.class.getName() + ".findByNoContacts";
    public static final String FIND_BY_NO_GROUPS = UserFinder.class.getName() + ".findByNoGroups";
    public static final String FIND_BY_SOCIAL_USERS = UserFinder.class.getName() + ".findBySocialUsers";
    public static final String FIND_BY_C_FN_MN_LN_SN_EA_S = UserFinder.class.getName() + ".findByC_FN_MN_LN_SN_EA_S";
    public static final String JOIN_BY_CONTACT_TWITTER_SN = UserFinder.class.getName() + ".joinByContactTwitterSN";
    public static final String JOIN_BY_NO_ORGANIZATIONS = UserFinder.class.getName() + ".joinByNoOrganizations";
    public static final String JOIN_BY_USER_GROUP_ROLE = UserFinder.class.getName() + ".joinByUserGroupRole";
    public static final String JOIN_BY_USERS_GROUPS = UserFinder.class.getName() + ".joinByUsersGroups";
    public static final String JOIN_BY_USERS_ORGS = UserFinder.class.getName() + ".joinByUsersOrgs";
    public static final String JOIN_BY_USERS_ORGS_TREE = UserFinder.class.getName() + ".joinByUsersOrgsTree";
    public static final String JOIN_BY_USERS_PASSWORD_POLICIES = UserFinder.class.getName() + ".joinByUsersPasswordPolicies";
    public static final String JOIN_BY_USERS_ROLES = UserFinder.class.getName() + ".joinByUsersRoles";
    public static final String JOIN_BY_USERS_TEAMS = UserFinder.class.getName() + ".joinByUsersTeams";
    public static final String JOIN_BY_USERS_USER_GROUPS = UserFinder.class.getName() + ".joinByUsersUserGroups";
    public static final String JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS = UserFinder.class.getName() + ".joinByAnnouncementsDeliveryEmailOrSms";
    public static final String JOIN_BY_SOCIAL_MUTUAL_RELATION = UserFinder.class.getName() + ".joinBySocialMutualRelation";
    public static final String JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE = UserFinder.class.getName() + ".joinBySocialMutualRelationType";
    public static final String JOIN_BY_SOCIAL_RELATION = UserFinder.class.getName() + ".joinBySocialRelation";
    public static final String JOIN_BY_SOCIAL_RELATION_TYPE = UserFinder.class.getName() + ".joinBySocialRelationType";
    private static final String _STATUS_SQL = "AND (User_.status = ?)";
    private LinkedHashMap<String, Object> _emptyLinkedHashMap = new LinkedHashMap(0);

    public int countBySocialUsers(long companyId, long userId, int socialRelationType, String socialRelationTypeComparator, int status) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_SOCIAL_USERS);
            sql = StringUtil.replace((String)sql, (String)"[$SOCIAL_RELATION_TYPE_COMPARATOR$]", (String)(socialRelationTypeComparator.equals("=") ? "=" : "!="));
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(socialRelationType);
            qPos.add(companyId);
            qPos.add(Boolean.FALSE);
            qPos.add(status);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByUser(long userId, LinkedHashMap<String, Object> params) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_USER);
            sql = this.replaceJoinAndWhere(sql, params);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params);
            qPos.add(userId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByKeywords(long companyId, String keywords, int status, LinkedHashMap<String, Object> params) {
        String[] firstNames = null;
        String[] middleNames = null;
        String[] lastNames = null;
        String[] screenNames = null;
        String[] emailAddresses = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstNames = CustomSQLUtil.keywords((String)keywords);
            middleNames = CustomSQLUtil.keywords((String)keywords);
            lastNames = CustomSQLUtil.keywords((String)keywords);
            screenNames = CustomSQLUtil.keywords((String)keywords);
            emailAddresses = CustomSQLUtil.keywords((String)keywords);
        } else {
            andOperator = true;
        }
        return this.countByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator);
    }

    public int countByC_FN_MN_LN_SN_EA_S(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andOperator) {
        String[] firstNames = CustomSQLUtil.keywords((String)firstName);
        String[] middleNames = CustomSQLUtil.keywords((String)middleName);
        String[] lastNames = CustomSQLUtil.keywords((String)lastName);
        String[] screenNames = CustomSQLUtil.keywords((String)screenName);
        String[] emailAddresses = CustomSQLUtil.keywords((String)emailAddress);
        return this.countByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator);
    }

    public int countByC_FN_MN_LN_SN_EA_S(long companyId, String[] firstNames, String[] middleNames, String[] lastNames, String[] screenNames, String[] emailAddresses, int status, LinkedHashMap<String, Object> params, boolean andOperator) {
        List<Long> userIds = this.doFindByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator, -1, -1, null);
        return userIds.size();
    }

    public List<User> findByKeywords(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<User> obc) {
        String[] firstNames = null;
        String[] middleNames = null;
        String[] lastNames = null;
        String[] screenNames = null;
        String[] emailAddresses = null;
        boolean andOperator = false;
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        if (Validator.isNotNull((String)keywords)) {
            WildcardMode wildcardMode = (WildcardMode)GetterUtil.getObject((Object)params.get("wildcardMode"), (Object)WildcardMode.SURROUND);
            firstNames = CustomSQLUtil.keywords((String)keywords, (WildcardMode)wildcardMode);
            middleNames = CustomSQLUtil.keywords((String)keywords, (WildcardMode)wildcardMode);
            lastNames = CustomSQLUtil.keywords((String)keywords, (WildcardMode)wildcardMode);
            screenNames = CustomSQLUtil.keywords((String)keywords, (WildcardMode)wildcardMode);
            emailAddresses = CustomSQLUtil.keywords((String)keywords, (WildcardMode)wildcardMode);
        } else {
            andOperator = true;
        }
        return this.findByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator, start, end, obc);
    }

    public List<User> findByNoAnnouncementsDeliveries(String type) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ANNOUNCEMENTS_DELIVERIES);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(type);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByNoContacts() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_CONTACTS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByNoGroups() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_GROUPS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findBySocialUsers(long companyId, long userId, int socialRelationType, String socialRelationTypeComparator, int status, int start, int end, OrderByComparator<User> obc) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SOCIAL_USERS);
            sql = StringUtil.replace((String)sql, (String)"[$SOCIAL_RELATION_TYPE_COMPARATOR$]", (String)(socialRelationTypeComparator.equals("=") ? "=" : "!="));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, obc);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("User_", UserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(userId);
            qPos.add(socialRelationType);
            qPos.add(companyId);
            qPos.add(Boolean.FALSE);
            qPos.add(status);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<User> findByC_FN_MN_LN_SN_EA_S(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<User> obc) {
        String[] firstNames = CustomSQLUtil.keywords((String)firstName);
        String[] middleNames = CustomSQLUtil.keywords((String)middleName);
        String[] lastNames = CustomSQLUtil.keywords((String)lastName);
        String[] screenNames = CustomSQLUtil.keywords((String)screenName);
        String[] emailAddresses = CustomSQLUtil.keywords((String)emailAddress);
        return this.findByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator, start, end, obc);
    }

    public List<User> findByC_FN_MN_LN_SN_EA_S(long companyId, String[] firstNames, String[] middleNames, String[] lastNames, String[] screenNames, String[] emailAddresses, int status, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<User> obc) {
        try {
            List<Long> userIds = this.doFindByC_FN_MN_LN_SN_EA_S(companyId, firstNames, middleNames, lastNames, screenNames, emailAddresses, status, params, andOperator, start, end, obc);
            ArrayList<User> users = new ArrayList<User>(userIds.size());
            for (Long userId : userIds) {
                User user = UserUtil.findByPrimaryKey((long)userId);
                users.add(user);
            }
            return users;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    protected List<Long> doFindByC_FN_MN_LN_SN_EA_S(long companyId, String[] firstNames, String[] middleNames, String[] lastNames, String[] screenNames, String[] emailAddresses, int status, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator<User> obc) {
        boolean hasSocialRelationTypes;
        ArrayList<Long> organizationIds;
        firstNames = CustomSQLUtil.keywords((String[])firstNames);
        middleNames = CustomSQLUtil.keywords((String[])middleNames);
        lastNames = CustomSQLUtil.keywords((String[])lastNames);
        screenNames = CustomSQLUtil.keywords((String[])screenNames);
        emailAddresses = CustomSQLUtil.keywords((String[])emailAddresses);
        if (params == null) {
            params = this._emptyLinkedHashMap;
        }
        LinkedHashMap<String, Object> params1 = params;
        LinkedHashMap<String, Object> params2 = null;
        LinkedHashMap<String, Object> params3 = null;
        LinkedHashMap<String, Object> params4 = null;
        Object[] groupIds = null;
        if (params.get("usersGroups") instanceof Long) {
            Long groupId = (Long)params.get("usersGroups");
            if (groupId > 0L) {
                groupIds = new Long[]{groupId};
            }
        } else {
            groupIds = (Long[])params.get("usersGroups");
        }
        Object[] roleIds = null;
        if (params.get("usersRoles") instanceof Long) {
            Long roleId = (Long)params.get("usersRoles");
            if (roleId > 0L) {
                roleIds = new Long[]{roleId};
            }
        } else {
            roleIds = (Long[])params.get("usersRoles");
        }
        boolean inherit = GetterUtil.getBoolean((Object)params.get("inherit"));
        boolean socialRelationTypeUnionUserGroups = GetterUtil.getBoolean((Object)params.get("socialRelationTypeUnionUserGroups"));
        if (ArrayUtil.isNotEmpty((Object[])groupIds) && inherit && !socialRelationTypeUnionUserGroups) {
            organizationIds = new ArrayList<Long>();
            ArrayList<Long> userGroupIds = new ArrayList<Long>();
            Object[] arr$ = groupIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long groupId = (Long)arr$[i$];
                Group group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                if (group == null) continue;
                if (group.isOrganization()) {
                    organizationIds.add(group.getOrganizationId());
                    continue;
                }
                if (group.isUserGroup()) {
                    userGroupIds.add(group.getClassPK());
                    continue;
                }
                organizationIds.addAll(ListUtil.toList((long[])GroupUtil.getOrganizationPrimaryKeys((long)groupId)));
                userGroupIds.addAll(ListUtil.toList((long[])GroupUtil.getUserGroupPrimaryKeys((long)groupId)));
            }
            if (!organizationIds.isEmpty()) {
                params2 = new LinkedHashMap<String, Object>(params1);
                params2.remove("usersGroups");
                params2.put("usersOrgs", organizationIds.toArray(new Long[organizationIds.size()]));
            }
            if (!userGroupIds.isEmpty()) {
                params3 = new LinkedHashMap<String, Object>(params1);
                params3.remove("usersGroups");
                params3.put("usersUserGroups", userGroupIds.toArray(new Long[userGroupIds.size()]));
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])roleIds) && inherit && !socialRelationTypeUnionUserGroups) {
            organizationIds = new ArrayList();
            ArrayList<Long> roleGroupIds = new ArrayList<Long>();
            ArrayList<Long> userGroupIds = new ArrayList<Long>();
            Object[] arr$ = roleIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long roleId = (Long)arr$[i$];
                List groups = RoleUtil.getGroups((long)roleId);
                for (Group group : groups) {
                    if (group.isOrganization()) {
                        organizationIds.add(group.getOrganizationId());
                        continue;
                    }
                    if (group.isUserGroup()) {
                        userGroupIds.add(group.getClassPK());
                        continue;
                    }
                    organizationIds.addAll(ListUtil.toList((long[])GroupUtil.getOrganizationPrimaryKeys((long)group.getGroupId())));
                    roleGroupIds.add(group.getGroupId());
                    userGroupIds.addAll(ListUtil.toList((long[])GroupUtil.getUserGroupPrimaryKeys((long)group.getGroupId())));
                }
            }
            if (!roleGroupIds.isEmpty()) {
                params2 = new LinkedHashMap<String, Object>(params1);
                params2.remove("usersRoles");
                params2.put("usersGroups", roleGroupIds.toArray(new Long[roleGroupIds.size()]));
            }
            if (!userGroupIds.isEmpty()) {
                params3 = new LinkedHashMap<String, Object>(params1);
                params3.remove("usersRoles");
                params3.put("usersUserGroups", userGroupIds.toArray(new Long[userGroupIds.size()]));
            }
            if (!organizationIds.isEmpty()) {
                params4 = new LinkedHashMap<String, Object>(params1);
                params4.remove("usersRoles");
                params4.put("usersOrgs", organizationIds.toArray(new Long[organizationIds.size()]));
            }
        }
        if (socialRelationTypeUnionUserGroups && (hasSocialRelationTypes = Validator.isNotNull((Object)params.get("socialRelationType"))) && ArrayUtil.isNotEmpty((Object[])groupIds)) {
            params2 = new LinkedHashMap<String, Object>(params1);
            params1.remove("socialRelationType");
            params2.remove("usersGroups");
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_FN_MN_LN_SN_EA_S);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.firstName)", (String)"LIKE", (boolean)false, (String[])firstNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.middleName)", (String)"LIKE", (boolean)false, (String[])middleNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.lastName)", (String)"LIKE", (boolean)false, (String[])lastNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.screenName)", (String)"LIKE", (boolean)false, (String[])screenNames);
            sql = CustomSQLUtil.replaceKeywords((String)sql, (String)"lower(User_.emailAddress)", (String)"LIKE", (boolean)true, (String[])emailAddresses);
            if (status == -1) {
                sql = StringUtil.replace((String)sql, (String)_STATUS_SQL, (String)"");
            }
            StringBundler sb = new StringBundler(14);
            sb.append("(");
            sb.append(this.replaceJoinAndWhere(sql, params1));
            sb.append(")");
            if (params2 != null) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(sql, params2));
                sb.append(")");
            }
            if (params3 != null) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(sql, params3));
                sb.append(")");
            }
            if (params4 != null) {
                sb.append(" UNION (");
                sb.append(this.replaceJoinAndWhere(sql, params4));
                sb.append(")");
            }
            if (obc != null) {
                sb.append(" ORDER BY ");
                sb.append(obc.toString());
            }
            sql = sb.toString();
            sql = CustomSQLUtil.replaceAndOperator((String)sql, (boolean)andOperator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("userId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            this.setJoin(qPos, params1);
            qPos.add(companyId);
            qPos.add(false);
            qPos.add(firstNames, 2);
            qPos.add(middleNames, 2);
            qPos.add(lastNames, 2);
            qPos.add(screenNames, 2);
            qPos.add(emailAddresses, 2);
            if (status != -1) {
                qPos.add(status);
            }
            if (params2 != null) {
                this.setJoin(qPos, params2);
                qPos.add(companyId);
                qPos.add(false);
                qPos.add(firstNames, 2);
                qPos.add(middleNames, 2);
                qPos.add(lastNames, 2);
                qPos.add(screenNames, 2);
                qPos.add(emailAddresses, 2);
                if (status != -1) {
                    qPos.add(status);
                }
            }
            if (params3 != null) {
                this.setJoin(qPos, params3);
                qPos.add(companyId);
                qPos.add(false);
                qPos.add(firstNames, 2);
                qPos.add(middleNames, 2);
                qPos.add(lastNames, 2);
                qPos.add(screenNames, 2);
                qPos.add(emailAddresses, 2);
                if (status != -1) {
                    qPos.add(status);
                }
            }
            if (params4 != null) {
                this.setJoin(qPos, params4);
                qPos.add(companyId);
                qPos.add(false);
                qPos.add(firstNames, 2);
                qPos.add(middleNames, 2);
                qPos.add(lastNames, 2);
                qPos.add(screenNames, 2);
                qPos.add(emailAddresses, 2);
                if (status != -1) {
                    qPos.add(status);
                }
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getJoin(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)(value = entry.getValue()))) continue;
            sb.append(this.getJoin(key, value));
        }
        return sb.toString();
    }

    protected String getJoin(String key, Object value) {
        int pos;
        String join = "";
        if (key.equals("contactTwitterSn")) {
            join = CustomSQLUtil.get((String)JOIN_BY_CONTACT_TWITTER_SN);
        } else if (key.equals("noOrganizations")) {
            join = CustomSQLUtil.get((String)JOIN_BY_NO_ORGANIZATIONS);
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
        } else if (key.equals("usersGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
        } else if (key.equals("usersOrgs")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
        } else if (key.equals("usersOrgsTree")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS_TREE);
        } else if (key.equals("usersPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_PASSWORD_POLICIES);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        } else if (key.equals("usersUserGroups")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
        } else if (key.equals("announcementsDeliveryEmailOrSms")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS);
        } else if (key.equals("socialMutualRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION);
        } else if (key.equals("socialMutualRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE);
        } else if (key.equals("socialRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION);
        } else if (key.equals("socialRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION_TYPE);
        } else if (value instanceof CustomSQLParam) {
            CustomSQLParam customSQLParam = (CustomSQLParam)value;
            join = customSQLParam.getSQL();
        }
        if (Validator.isNotNull((String)join) && (pos = join.indexOf("WHERE")) != -1) {
            join = join.substring(0, pos);
        }
        return join;
    }

    protected String getWhere(LinkedHashMap<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(params.size());
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (key.equals("expandoAttributes") || !Validator.isNotNull((Object)(value = entry.getValue()))) continue;
            sb.append(this.getWhere(key, value));
        }
        return sb.toString();
    }

    protected String getWhere(String key, Object value) {
        String join = "";
        if (key.equals("contactTwitterSn")) {
            join = CustomSQLUtil.get((String)JOIN_BY_CONTACT_TWITTER_SN);
        } else if (key.equals("noOrganizations")) {
            join = CustomSQLUtil.get((String)JOIN_BY_NO_ORGANIZATIONS);
        } else if (key.equals("userGroupRole")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USER_GROUP_ROLE);
            Long[] valueArray = (Long[])value;
            Long groupId = valueArray[0];
            if (Validator.isNull((Long)groupId)) {
                join = StringUtil.replace((String)join, (String)"(UserGroupRole.groupId = ?) AND", (String)"");
            }
        } else if (key.equals("usersGroups")) {
            if (value instanceof Long) {
                join = CustomSQLUtil.get((String)JOIN_BY_USERS_GROUPS);
            } else if (value instanceof Long[]) {
                Long[] groupIds = (Long[])value;
                StringBundler sb = new StringBundler(groupIds.length * 2 + 1);
                sb.append("WHERE (Users_Groups.groupId IN (");
                Long[] arr$ = groupIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long groupId = arr$[i$];
                    sb.append(groupId);
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("))");
                join = sb.toString();
            }
        } else if (key.equals("usersOrgs")) {
            if (value instanceof Long) {
                join = CustomSQLUtil.get((String)JOIN_BY_USERS_ORGS);
            } else if (value instanceof Long[]) {
                Long[] organizationIds = (Long[])value;
                StringBundler sb = new StringBundler(organizationIds.length * 2 + 1);
                sb.append("WHERE (Users_Orgs.organizationId IN (");
                Long[] arr$ = organizationIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long organizationId = arr$[i$];
                    sb.append(organizationId);
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("))");
                join = sb.toString();
            }
        } else if (key.equals("usersOrgsTree")) {
            List organizationsTree = (List)value;
            int size = organizationsTree.size();
            if (size > 0) {
                StringBundler sb = new StringBundler(size * 4 + 1);
                sb.append("WHERE (");
                for (Organization organization : organizationsTree) {
                    sb.append("(Organization_.treePath LIKE '%/");
                    sb.append(organization.getOrganizationId());
                    sb.append("/%')");
                    sb.append(" OR ");
                }
                sb.setIndex(sb.index() - 1);
                sb.append(")");
                join = sb.toString();
            } else {
                join = "WHERE (Organization_.treePath LIKE '%/ /%')";
            }
        } else if (key.equals("usersPasswordPolicies")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_PASSWORD_POLICIES);
        } else if (key.equals("usersRoles")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_ROLES);
        } else if (key.equals("usersTeams")) {
            join = CustomSQLUtil.get((String)JOIN_BY_USERS_TEAMS);
        } else if (key.equals("usersUserGroups")) {
            if (value instanceof Long) {
                join = CustomSQLUtil.get((String)JOIN_BY_USERS_USER_GROUPS);
            } else if (value instanceof Long[]) {
                Long[] userGroupIds = (Long[])value;
                StringBundler sb = new StringBundler(userGroupIds.length * 2 + 1);
                sb.append("WHERE (Users_UserGroups.userGroupId IN (");
                Long[] arr$ = userGroupIds;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    long userGroupId = arr$[i$];
                    sb.append(userGroupId);
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("))");
                join = sb.toString();
            }
        } else if (key.equals("announcementsDeliveryEmailOrSms")) {
            join = CustomSQLUtil.get((String)JOIN_BY_ANNOUNCEMENTS_DELIVERY_EMAIL_OR_SMS);
        } else if (key.equals("socialMutualRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION);
        } else if (key.equals("socialMutualRelationType")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_MUTUAL_RELATION_TYPE);
        } else if (key.equals("socialRelation")) {
            join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION);
        } else if (key.equals("socialRelationType")) {
            if (value instanceof Long[]) {
                join = CustomSQLUtil.get((String)JOIN_BY_SOCIAL_RELATION_TYPE);
            } else if (value instanceof Long[][]) {
                StringBundler sb = new StringBundler();
                sb.append("WHERE (SocialRelation.userId1 = ?) AND ");
                sb.append("(SocialRelation.type_ IN (");
                Long[][] valueDoubleArray = (Long[][])value;
                Long[] socialRelationTypes = valueDoubleArray[1];
                for (int i = 0; i < socialRelationTypes.length; ++i) {
                    sb.append("?");
                    if (i + 1 >= socialRelationTypes.length) continue;
                    sb.append(",");
                }
                sb.append("))");
                join = sb.toString();
            }
        } else if (value instanceof CustomSQLParam) {
            CustomSQLParam customSQLParam = (CustomSQLParam)value;
            join = customSQLParam.getSQL();
        }
        if (Validator.isNotNull((String)join)) {
            int pos = join.indexOf("WHERE");
            join = pos != -1 ? join.substring(pos + 5, join.length()).concat(" AND ") : "";
        }
        return join;
    }

    protected String replaceJoinAndWhere(String sql, LinkedHashMap<String, Object> params) {
        sql = StringUtil.replace((String)sql, (String)"[$JOIN$]", (String)this.getJoin(params));
        sql = StringUtil.replace((String)sql, (String)"[$WHERE$]", (String)this.getWhere(params));
        return sql;
    }

    protected void setJoin(QueryPos qPos, LinkedHashMap<String, Object> params) {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object[] valueArray;
            String key = entry.getKey();
            if (key.equals("expandoAttributes")) continue;
            Object value = entry.getValue();
            if (value instanceof Long) {
                Long valueLong = (Long)value;
                if (!Validator.isNotNull((Long)valueLong)) continue;
                qPos.add(valueLong);
                continue;
            }
            if (value instanceof Long[]) {
                if (key.equals("usersGroups") || key.equals("usersOrgs") || key.equals("usersUserGroups")) continue;
                valueArray = (Long[])value;
                for (Long[] longArray : valueArray) {
                    if (!Validator.isNotNull((Long)longArray)) continue;
                    qPos.add((Long)longArray);
                }
                continue;
            }
            if (value instanceof Long[][]) {
                Long[][] valueDoubleArray;
                Long[][] arr$ = valueDoubleArray = (Long[][])value;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Long[] longArray;
                    for (Long valueLong : longArray = arr$[i$]) {
                        qPos.add(valueLong);
                    }
                }
                continue;
            }
            if (value instanceof String) {
                String valueString = (String)value;
                if (!Validator.isNotNull((String)valueString)) continue;
                qPos.add(valueString);
                continue;
            }
            if (value instanceof String[]) {
                valueArray = (String[])value;
                for (Long[] longArray : valueArray) {
                    if (!Validator.isNotNull((String)longArray)) continue;
                    qPos.add((String)longArray);
                }
                continue;
            }
            if (!(value instanceof CustomSQLParam)) continue;
            CustomSQLParam customSQLParam = (CustomSQLParam)value;
            customSQLParam.process(qPos);
        }
    }
}

