/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutSoap;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.persistence.LayoutFinder;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LayoutFinderImpl
extends BasePersistenceImpl<Layout>
implements LayoutFinder {
    public static final String FIND_BY_NO_PERMISSIONS = LayoutFinder.class.getName() + ".findByNoPermissions";
    public static final String FIND_BY_NULL_FRIENDLY_URL = LayoutFinder.class.getName() + ".findByNullFriendlyURL";
    public static final String FIND_BY_SCOPE_GROUP = LayoutFinder.class.getName() + ".findByScopeGroup";
    public static final String FIND_BY_C_P_P = LayoutFinder.class.getName() + ".findByC_P_P";

    public List<Layout> findByNoPermissions(long roleId) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_PERMISSIONS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Layout", LayoutImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(4);
            qPos.add(roleId);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Layout> findByNullFriendlyURL() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Layout", LayoutImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Layout> findByScopeGroup(long groupId, boolean privateLayout) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_SCOPE_GROUP);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("Layout", LayoutImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(privateLayout);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<LayoutReference> findByC_P_P(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        String preferences = "%<preference><name>" + preferencesKey + "</name><value>" + preferencesValue + "</value>%";
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P_P);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("layoutPlid", Type.LONG);
            q.addScalar("preferencesPortletId", Type.STRING);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(portletId);
            qPos.add(portletId.concat("_INSTANCE_%"));
            qPos.add(preferences);
            ArrayList<LayoutReference> layoutReferences = new ArrayList<LayoutReference>();
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                Long layoutPlid = (Long)array[0];
                String preferencesPortletId = (String)array[1];
                Layout layout = LayoutUtil.findByPrimaryKey((long)layoutPlid);
                layoutReferences.add(new LayoutReference(LayoutSoap.toSoapModel((Layout)layout), preferencesPortletId));
            }
            ArrayList<LayoutReference> arrayList = layoutReferences;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

