/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.Country;
import com.liferay.portal.model.MVCCModel;
import com.liferay.portal.model.impl.CountryImpl;
import com.liferay.portal.model.impl.CountryModelImpl;
import com.liferay.portal.service.persistence.CountryPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class CountryPersistenceImpl
extends BasePersistenceImpl<Country>
implements CountryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CountryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_NAME = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByName", new String[]{String.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_NAME = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByName", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_NAME_NAME_1 = "country.name IS NULL";
    private static final String _FINDER_COLUMN_NAME_NAME_2 = "country.name = ?";
    private static final String _FINDER_COLUMN_NAME_NAME_3 = "(country.name IS NULL OR country.name = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_A2 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByA2", new String[]{String.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_A2 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA2", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_A2_A2_1 = "country.a2 IS NULL";
    private static final String _FINDER_COLUMN_A2_A2_2 = "country.a2 = ?";
    private static final String _FINDER_COLUMN_A2_A2_3 = "(country.a2 IS NULL OR country.a2 = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_A3 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByA3", new String[]{String.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_A3 = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByA3", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_A3_A3_1 = "country.a3 IS NULL";
    private static final String _FINDER_COLUMN_A3_A3_2 = "country.a3 = ?";
    private static final String _FINDER_COLUMN_A3_A3_3 = "(country.a3 IS NULL OR country.a3 = '')";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_ACTIVE = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByActive", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, CountryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByActive", new String[]{Boolean.class.getName()}, 12L);
    public static final FinderPath FINDER_PATH_COUNT_BY_ACTIVE = new FinderPath(CountryModelImpl.ENTITY_CACHE_ENABLED, CountryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByActive", new String[]{Boolean.class.getName()});
    private static final String _FINDER_COLUMN_ACTIVE_ACTIVE_2 = "country.active = ?";
    private static final String _SQL_SELECT_COUNTRY = "SELECT country FROM Country country";
    private static final String _SQL_SELECT_COUNTRY_WHERE_PKS_IN = "SELECT country FROM Country country WHERE countryId IN (";
    private static final String _SQL_SELECT_COUNTRY_WHERE = "SELECT country FROM Country country WHERE ";
    private static final String _SQL_COUNT_COUNTRY = "SELECT COUNT(country) FROM Country country";
    private static final String _SQL_COUNT_COUNTRY_WHERE = "SELECT COUNT(country) FROM Country country WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "country.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Country exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Country exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static final Log _log = LogFactoryUtil.getLog(CountryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"number", "idd", "active"});
    private static final Country _nullCountry = new CountryImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<Country> toCacheModel() {
            return _nullCountryCacheModel;
        }
    };
    private static final CacheModel<Country> _nullCountryCacheModel = new NullCacheModel();

    public Country findByName(String name) throws NoSuchCountryException {
        Country country = this.fetchByName(name);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("name=");
            msg.append(name);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    public Country fetchByName(String name) {
        return this.fetchByName(name, true);
    }

    public Country fetchByName(String name, boolean retrieveFromCache) {
        Country country;
        Object[] finderArgs = new Object[]{name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Country && !Validator.equals((Object)name, (Object)(country = (Country)result).getName())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_NAME_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_NAME_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_NAME_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindName) {
                    qPos.add(name);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])finderArgs, (Object)list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                    if (country2.getName() == null || !country2.getName().equals(name)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])finderArgs, (Object)country2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    public Country removeByName(String name) throws NoSuchCountryException {
        Country country = this.findByName(name);
        return (Country)this.remove((BaseModel)country);
    }

    public int countByName(String name) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_NAME;
        Object[] finderArgs = new Object[]{name};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindName = false;
            if (name == null) {
                query.append(_FINDER_COLUMN_NAME_NAME_1);
            } else if (name.equals("")) {
                query.append(_FINDER_COLUMN_NAME_NAME_3);
            } else {
                bindName = true;
                query.append(_FINDER_COLUMN_NAME_NAME_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindName) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Country findByA2(String a2) throws NoSuchCountryException {
        Country country = this.fetchByA2(a2);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("a2=");
            msg.append(a2);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    public Country fetchByA2(String a2) {
        return this.fetchByA2(a2, true);
    }

    public Country fetchByA2(String a2, boolean retrieveFromCache) {
        Country country;
        Object[] finderArgs = new Object[]{a2};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Country && !Validator.equals((Object)a2, (Object)(country = (Country)result).getA2())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindA2 = false;
            if (a2 == null) {
                query.append(_FINDER_COLUMN_A2_A2_1);
            } else if (a2.equals("")) {
                query.append(_FINDER_COLUMN_A2_A2_3);
            } else {
                bindA2 = true;
                query.append(_FINDER_COLUMN_A2_A2_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindA2) {
                    qPos.add(a2);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])finderArgs, (Object)list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                    if (country2.getA2() == null || !country2.getA2().equals(a2)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])finderArgs, (Object)country2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    public Country removeByA2(String a2) throws NoSuchCountryException {
        Country country = this.findByA2(a2);
        return (Country)this.remove((BaseModel)country);
    }

    public int countByA2(String a2) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_A2;
        Object[] finderArgs = new Object[]{a2};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindA2 = false;
            if (a2 == null) {
                query.append(_FINDER_COLUMN_A2_A2_1);
            } else if (a2.equals("")) {
                query.append(_FINDER_COLUMN_A2_A2_3);
            } else {
                bindA2 = true;
                query.append(_FINDER_COLUMN_A2_A2_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindA2) {
                    qPos.add(a2);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Country findByA3(String a3) throws NoSuchCountryException {
        Country country = this.fetchByA3(a3);
        if (country == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("a3=");
            msg.append(a3);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCountryException(msg.toString());
        }
        return country;
    }

    public Country fetchByA3(String a3) {
        return this.fetchByA3(a3, true);
    }

    public Country fetchByA3(String a3, boolean retrieveFromCache) {
        Country country;
        Object[] finderArgs = new Object[]{a3};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Country && !Validator.equals((Object)a3, (Object)(country = (Country)result).getA3())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            boolean bindA3 = false;
            if (a3 == null) {
                query.append(_FINDER_COLUMN_A3_A3_1);
            } else if (a3.equals("")) {
                query.append(_FINDER_COLUMN_A3_A3_3);
            } else {
                bindA3 = true;
                query.append(_FINDER_COLUMN_A3_A3_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindA3) {
                    qPos.add(a3);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])finderArgs, (Object)list);
                } else {
                    Country country2 = (Country)list.get(0);
                    result = country2;
                    this.cacheResult(country2);
                    if (country2.getA3() == null || !country2.getA3().equals(a3)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])finderArgs, (Object)country2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Country)result;
    }

    public Country removeByA3(String a3) throws NoSuchCountryException {
        Country country = this.findByA3(a3);
        return (Country)this.remove((BaseModel)country);
    }

    public int countByA3(String a3) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_A3;
        Object[] finderArgs = new Object[]{a3};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            boolean bindA3 = false;
            if (a3 == null) {
                query.append(_FINDER_COLUMN_A3_A3_1);
            } else if (a3.equals("")) {
                query.append(_FINDER_COLUMN_A3_A3_3);
            } else {
                bindA3 = true;
                query.append(_FINDER_COLUMN_A3_A3_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindA3) {
                    qPos.add(a3);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Country> findByActive(boolean active) {
        return this.findByActive(active, -1, -1, null);
    }

    public List<Country> findByActive(boolean active, int start, int end) {
        return this.findByActive(active, start, end, null);
    }

    public List<Country> findByActive(boolean active, int start, int end, OrderByComparator<Country> orderByComparator) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE;
            finderArgs = new Object[]{active};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_ACTIVE;
            finderArgs = new Object[]{active, start, end, orderByComparator};
        }
        List<Country> list = (List<Country>)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (list != null && !list.isEmpty()) {
            for (Country country : list) {
                if (active == country.getActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_COUNTRY_WHERE);
            query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY country.name ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Country findByActive_First(boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.fetchByActive_First(active, orderByComparator);
        if (country != null) {
            return country;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchCountryException(msg.toString());
    }

    public Country fetchByActive_First(boolean active, OrderByComparator<Country> orderByComparator) {
        List<Country> list = this.findByActive(active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Country findByActive_Last(boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.fetchByActive_Last(active, orderByComparator);
        if (country != null) {
            return country;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("active=");
        msg.append(active);
        msg.append("}");
        throw new NoSuchCountryException(msg.toString());
    }

    public Country fetchByActive_Last(boolean active, OrderByComparator<Country> orderByComparator) {
        int count = this.countByActive(active);
        if (count == 0) {
            return null;
        }
        List<Country> list = this.findByActive(active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Country[] findByActive_PrevAndNext(long countryId, boolean active, OrderByComparator<Country> orderByComparator) throws NoSuchCountryException {
        Country country = this.findByPrimaryKey(countryId);
        Session session = null;
        try {
            session = this.openSession();
            Country[] array = new CountryImpl[]{this.getByActive_PrevAndNext(session, country, active, orderByComparator, true), country, this.getByActive_PrevAndNext(session, country, active, orderByComparator, false)};
            Country[] countryArray = array;
            return countryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Country getByActive_PrevAndNext(Session session, Country country, boolean active, OrderByComparator<Country> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_COUNTRY_WHERE);
        query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY country.name ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(active);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)country)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Country)list.get(1);
        }
        return null;
    }

    public void removeByActive(boolean active) {
        for (Country country : this.findByActive(active, -1, -1, null)) {
            this.remove((BaseModel)country);
        }
    }

    public int countByActive(boolean active) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_ACTIVE;
        Object[] finderArgs = new Object[]{active};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COUNTRY_WHERE);
            query.append(_FINDER_COLUMN_ACTIVE_ACTIVE_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(active);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CountryPersistenceImpl() {
        this.setModelClass(Country.class);
    }

    public void cacheResult(Country country) {
        EntityCacheUtil.putResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)Long.valueOf(country.getPrimaryKey()), (Serializable)country);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])new Object[]{country.getName()}, (Object)country);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])new Object[]{country.getA2()}, (Object)country);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])new Object[]{country.getA3()}, (Object)country);
        country.resetOriginalValues();
    }

    public void cacheResult(List<Country> countries) {
        for (Country country : countries) {
            if (EntityCacheUtil.getResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)Long.valueOf(country.getPrimaryKey())) == null) {
                this.cacheResult(country);
                continue;
            }
            country.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)CountryImpl.class.getName());
        }
        EntityCacheUtil.clearCache(CountryImpl.class);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Country country) {
        EntityCacheUtil.removeResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)Long.valueOf(country.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(country);
    }

    public void clearCache(List<Country> countries) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Country country : countries) {
            EntityCacheUtil.removeResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)Long.valueOf(country.getPrimaryKey()));
            this.clearUniqueFindersCache(country);
        }
    }

    protected void cacheUniqueFindersCache(Country country) {
        if (country.isNew()) {
            Object[] args = new Object[]{country.getName()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_NAME, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])args, (Object)country);
            args = new Object[]{country.getA2()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_A2, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])args, (Object)country);
            args = new Object[]{country.getA3()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_A3, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])args, (Object)country);
        } else {
            Object[] args;
            CountryModelImpl countryModelImpl = (CountryModelImpl)country;
            if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_NAME.getColumnBitmask()) != 0L) {
                args = new Object[]{country.getName()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_NAME, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])args, (Object)country);
            }
            if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_A2.getColumnBitmask()) != 0L) {
                args = new Object[]{country.getA2()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_A2, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])args, (Object)country);
            }
            if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_A3.getColumnBitmask()) != 0L) {
                args = new Object[]{country.getA3()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_A3, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])args, (Object)country);
            }
        }
    }

    protected void clearUniqueFindersCache(Country country) {
        CountryModelImpl countryModelImpl = (CountryModelImpl)country;
        Object[] args = new Object[]{country.getName()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_NAME, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])args);
        if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_NAME.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalName()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_NAME, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_NAME, (Object[])args);
        }
        args = new Object[]{country.getA2()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_A2, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])args);
        if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_A2.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalA2()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_A2, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A2, (Object[])args);
        }
        args = new Object[]{country.getA3()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_A3, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])args);
        if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_A3.getColumnBitmask()) != 0L) {
            args = new Object[]{countryModelImpl.getOriginalA3()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_A3, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_A3, (Object[])args);
        }
    }

    public Country create(long countryId) {
        CountryImpl country = new CountryImpl();
        country.setNew(true);
        country.setPrimaryKey(countryId);
        return country;
    }

    public Country remove(long countryId) throws NoSuchCountryException {
        return this.remove(Long.valueOf(countryId));
    }

    public Country remove(Serializable primaryKey) throws NoSuchCountryException {
        Session session = null;
        try {
            session = this.openSession();
            Country country = (Country)session.get(CountryImpl.class, primaryKey);
            if (country == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Country country2 = (Country)this.remove((BaseModel)country);
            return country2;
        }
        catch (NoSuchCountryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Country removeImpl(Country country) {
        country = this.toUnwrappedModel(country);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)country)) {
                country = (Country)session.get(CountryImpl.class, country.getPrimaryKeyObj());
            }
            if (country != null) {
                session.delete((Object)country);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (country != null) {
            this.clearCache(country);
        }
        return country;
    }

    public Country updateImpl(Country country) {
        country = this.toUnwrappedModel(country);
        boolean isNew = country.isNew();
        CountryModelImpl countryModelImpl = (CountryModelImpl)country;
        Session session = null;
        try {
            session = this.openSession();
            if (country.isNew()) {
                session.save((Object)country);
                country.setNew(false);
            } else {
                session.merge((Object)country);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !CountryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((countryModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{countryModelImpl.getOriginalActive()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_ACTIVE, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE, (Object[])args);
            args = new Object[]{countryModelImpl.getActive()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_ACTIVE, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_ACTIVE, (Object[])args);
        }
        EntityCacheUtil.putResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)Long.valueOf(country.getPrimaryKey()), (Serializable)country, (boolean)false);
        this.clearUniqueFindersCache(country);
        this.cacheUniqueFindersCache(country);
        country.resetOriginalValues();
        return country;
    }

    protected Country toUnwrappedModel(Country country) {
        if (country instanceof CountryImpl) {
            return country;
        }
        CountryImpl countryImpl = new CountryImpl();
        countryImpl.setNew(country.isNew());
        countryImpl.setPrimaryKey(country.getPrimaryKey());
        countryImpl.setMvccVersion(country.getMvccVersion());
        countryImpl.setCountryId(country.getCountryId());
        countryImpl.setName(country.getName());
        countryImpl.setA2(country.getA2());
        countryImpl.setA3(country.getA3());
        countryImpl.setNumber(country.getNumber());
        countryImpl.setIdd(country.getIdd());
        countryImpl.setZipRequired(country.isZipRequired());
        countryImpl.setActive(country.isActive());
        return countryImpl;
    }

    public Country findByPrimaryKey(Serializable primaryKey) throws NoSuchCountryException {
        Country country = this.fetchByPrimaryKey(primaryKey);
        if (country == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return country;
    }

    public Country findByPrimaryKey(long countryId) throws NoSuchCountryException {
        return this.findByPrimaryKey(Long.valueOf(countryId));
    }

    public Country fetchByPrimaryKey(Serializable primaryKey) {
        Country country = (Country)EntityCacheUtil.getResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)primaryKey);
        if (country == _nullCountry) {
            return null;
        }
        if (country == null) {
            Session session = null;
            try {
                session = this.openSession();
                country = (Country)session.get(CountryImpl.class, primaryKey);
                if (country != null) {
                    this.cacheResult(country);
                } else {
                    EntityCacheUtil.putResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)primaryKey, (Serializable)_nullCountry);
                }
            }
            catch (Exception e) {
                EntityCacheUtil.removeResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return country;
    }

    public Country fetchByPrimaryKey(long countryId) {
        return this.fetchByPrimaryKey(Long.valueOf(countryId));
    }

    public Map<Serializable, Country> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Country> map = new HashMap<Serializable, Country>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Country country = this.fetchByPrimaryKey(primaryKey);
            if (country != null) {
                map.put(primaryKey, country);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            Country country = (Country)EntityCacheUtil.getResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)primaryKey);
            if (country == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, country);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COUNTRY_WHERE_PKS_IN);
        for (Serializable primaryKey : uncachedPrimaryKeys) {
            query.append(String.valueOf(primaryKey));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            for (Country country : q.list()) {
                map.put(country.getPrimaryKeyObj(), country);
                this.cacheResult(country);
                uncachedPrimaryKeys.remove(country.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                EntityCacheUtil.putResult((boolean)CountryModelImpl.ENTITY_CACHE_ENABLED, CountryImpl.class, (Serializable)primaryKey, (Serializable)_nullCountry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<Country> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Country> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Country> findAll(int start, int end, OrderByComparator<Country> orderByComparator) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_COUNTRY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COUNTRY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY country.name ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Country country : this.findAll()) {
            this.remove((BaseModel)country);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COUNTRY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)CountryImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private static class NullCacheModel
    implements CacheModel<Country>,
    MVCCModel {
        private NullCacheModel() {
        }

        public long getMvccVersion() {
            return 0L;
        }

        public void setMvccVersion(long mvccVersion) {
        }

        public Country toEntityModel() {
            return _nullCountry;
        }
    }
}

