/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.NoSuchCompanyException;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.MVCCModel;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import com.liferay.portal.service.persistence.CompanyPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByWebId", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_WEBID_WEBID_1 = "company.webId IS NULL";
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMx", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_MX_MX_1 = "company.mx IS NULL";
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLogoId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySystem", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySystem", new String[]{Boolean.class.getName()}, 4L);
    public static final FinderPath FINDER_PATH_COUNT_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySystem", new String[]{Boolean.class.getName()});
    private static final String _FINDER_COLUMN_SYSTEM_SYSTEM_2 = "company.system = ?";
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE_PKS_IN = "SELECT company FROM Company company WHERE companyId IN (";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static final boolean _HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE = PropsValues.HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE;
    private static final Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"key", "active"});
    private static final Company _nullCompany = new CompanyImpl(){

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public CacheModel<Company> toCacheModel() {
            return _nullCompanyCacheModel;
        }
    };
    private static final CacheModel<Company> _nullCompanyCacheModel = new NullCacheModel();

    public Company findByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("webId=");
            msg.append(webId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByWebId(String webId) {
        return this.fetchByWebId(webId, true);
    }

    public Company fetchByWebId(String webId, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{webId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && !Validator.equals((Object)webId, (Object)(company = (Company)result).getWebId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)list);
                } else {
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getWebId() == null || !company2.getWebId().equals(webId)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.findByWebId(webId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByWebId(String webId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_WEBID;
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByMx(String mx) throws NoSuchCompanyException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mx=");
            msg.append(mx);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByMx(String mx) {
        return this.fetchByMx(mx, true);
    }

    public Company fetchByMx(String mx, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{mx};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && !Validator.equals((Object)mx, (Object)(company = (Company)result).getMx())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindMx) {
                    qPos.add(mx);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)list);
                } else {
                    if (list.size() > 1 && _log.isWarnEnabled()) {
                        _log.warn((Object)("CompanyPersistenceImpl.fetchByMx(String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getMx() == null || !company2.getMx().equals(mx)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByMx(String mx) throws NoSuchCompanyException {
        Company company = this.findByMx(mx);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByMx(String mx) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_MX;
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindMx) {
                    qPos.add(mx);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("logoId=");
            msg.append(logoId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByLogoId(long logoId) {
        return this.fetchByLogoId(logoId, true);
    }

    public Company fetchByLogoId(long logoId, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{logoId};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && logoId != (company = (Company)result).getLogoId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)list);
                } else {
                    if (list.size() > 1 && _log.isWarnEnabled()) {
                        _log.warn((Object)("CompanyPersistenceImpl.fetchByLogoId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getLogoId() != logoId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.findByLogoId(logoId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByLogoId(long logoId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LOGOID;
        Object[] finderArgs = new Object[]{logoId};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Company> findBySystem(boolean system) {
        return this.findBySystem(system, -1, -1, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end) {
        return this.findBySystem(system, start, end, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator<Company> orderByComparator) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM;
            finderArgs = new Object[]{system};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SYSTEM;
            finderArgs = new Object[]{system, start, end, orderByComparator};
        }
        List<Company> list = (List<Company>)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (list != null && !list.isEmpty()) {
            for (Company company : list) {
                if (system == company.getSystem()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY company.companyId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Company findBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_First(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    public Company fetchBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) {
        List<Company> list = this.findBySystem(system, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Company findBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_Last(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    public Company fetchBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) {
        int count = this.countBySystem(system);
        if (count == 0) {
            return null;
        }
        List<Company> list = this.findBySystem(system, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Company[] findBySystem_PrevAndNext(long companyId, boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.findByPrimaryKey(companyId);
        Session session = null;
        try {
            session = this.openSession();
            Company[] array = new CompanyImpl[]{this.getBySystem_PrevAndNext(session, company, system, orderByComparator, true), company, this.getBySystem_PrevAndNext(session, company, system, orderByComparator, false)};
            Company[] companyArray = array;
            return companyArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company getBySystem_PrevAndNext(Session session, Company company, boolean system, OrderByComparator<Company> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 6) : new StringBundler(3);
        query.append(_SQL_SELECT_COMPANY_WHERE);
        query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY company.companyId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(system);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)company)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Company)list.get(1);
        }
        return null;
    }

    public void removeBySystem(boolean system) {
        for (Company company : this.findBySystem(system, -1, -1, null)) {
            this.remove((BaseModel)company);
        }
    }

    public int countBySystem(boolean system) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SYSTEM;
        Object[] finderArgs = new Object[]{system};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CompanyPersistenceImpl() {
        this.setModelClass(Company.class);
    }

    public void cacheResult(Company company) {
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Serializable)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])new Object[]{company.getWebId()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])new Object[]{company.getMx()}, (Object)company);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])new Object[]{company.getLogoId()}, (Object)company);
        company.resetOriginalValues();
    }

    public void cacheResult(List<Company> companies) {
        for (Company company : companies) {
            if (EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey())) == null) {
                this.cacheResult(company);
                continue;
            }
            company.resetOriginalValues();
        }
    }

    public void clearCache() {
        if (_HIBERNATE_CACHE_USE_SECOND_LEVEL_CACHE) {
            CacheRegistryUtil.clear((String)CompanyImpl.class.getName());
        }
        EntityCacheUtil.clearCache(CompanyImpl.class);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Company company) {
        EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache(company);
    }

    public void clearCache(List<Company> companies) {
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Company company : companies) {
            EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
            this.clearUniqueFindersCache(company);
        }
    }

    protected void cacheUniqueFindersCache(Company company) {
        if (company.isNew()) {
            Object[] args = new Object[]{company.getWebId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])args, (Object)company);
            args = new Object[]{company.getMx()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])args, (Object)company);
            args = new Object[]{company.getLogoId()};
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])args, (Object)1L);
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])args, (Object)company);
        } else {
            Object[] args;
            CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
            if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_WEBID.getColumnBitmask()) != 0L) {
                args = new Object[]{company.getWebId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])args, (Object)company);
            }
            if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MX.getColumnBitmask()) != 0L) {
                args = new Object[]{company.getMx()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])args, (Object)company);
            }
            if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LOGOID.getColumnBitmask()) != 0L) {
                args = new Object[]{company.getLogoId()};
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])args, (Object)1L);
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])args, (Object)company);
            }
        }
    }

    protected void clearUniqueFindersCache(Company company) {
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        Object[] args = new Object[]{company.getWebId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])args);
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_WEBID.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalWebId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_WEBID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_WEBID, (Object[])args);
        }
        args = new Object[]{company.getMx()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])args);
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MX.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalMx()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_MX, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_MX, (Object[])args);
        }
        args = new Object[]{company.getLogoId()};
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])args);
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])args);
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LOGOID.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalLogoId()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_LOGOID, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_LOGOID, (Object[])args);
        }
    }

    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    public Company remove(long companyId) throws NoSuchCompanyException {
        return this.remove(Long.valueOf(companyId));
    }

    public Company remove(Serializable primaryKey) throws NoSuchCompanyException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, primaryKey);
            if (company == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Company company2 = (Company)this.remove((BaseModel)company);
            return company2;
        }
        catch (NoSuchCompanyException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company removeImpl(Company company) {
        company = this.toUnwrappedModel(company);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)company)) {
                company = (Company)session.get(CompanyImpl.class, company.getPrimaryKeyObj());
            }
            if (company != null) {
                session.delete((Object)company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (company != null) {
            this.clearCache(company);
        }
        return company;
    }

    public Company updateImpl(Company company) {
        company = this.toUnwrappedModel(company);
        boolean isNew = company.isNew();
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        Session session = null;
        try {
            session = this.openSession();
            if (company.isNew()) {
                session.save((Object)company);
                company.setNew(false);
            } else {
                session.merge((Object)company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (isNew || !CompanyModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{companyModelImpl.getOriginalSystem()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM, (Object[])args);
            args = new Object[]{companyModelImpl.getSystem()};
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_BY_SYSTEM, (Object[])args);
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM, (Object[])args);
        }
        EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Serializable)company, (boolean)false);
        this.clearUniqueFindersCache(company);
        this.cacheUniqueFindersCache(company);
        company.resetOriginalValues();
        return company;
    }

    protected Company toUnwrappedModel(Company company) {
        if (company instanceof CompanyImpl) {
            return company;
        }
        CompanyImpl companyImpl = new CompanyImpl();
        companyImpl.setNew(company.isNew());
        companyImpl.setPrimaryKey(company.getPrimaryKey());
        companyImpl.setMvccVersion(company.getMvccVersion());
        companyImpl.setCompanyId(company.getCompanyId());
        companyImpl.setAccountId(company.getAccountId());
        companyImpl.setWebId(company.getWebId());
        companyImpl.setKey(company.getKey());
        companyImpl.setMx(company.getMx());
        companyImpl.setHomeURL(company.getHomeURL());
        companyImpl.setLogoId(company.getLogoId());
        companyImpl.setSystem(company.isSystem());
        companyImpl.setMaxUsers(company.getMaxUsers());
        companyImpl.setActive(company.isActive());
        return companyImpl;
    }

    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchCompanyException {
        Company company = this.fetchByPrimaryKey(primaryKey);
        if (company == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return company;
    }

    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException {
        return this.findByPrimaryKey(Long.valueOf(companyId));
    }

    public Company fetchByPrimaryKey(Serializable primaryKey) {
        Company company = (Company)EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)primaryKey);
        if (company == _nullCompany) {
            return null;
        }
        if (company == null) {
            Session session = null;
            try {
                session = this.openSession();
                company = (Company)session.get(CompanyImpl.class, primaryKey);
                if (company != null) {
                    this.cacheResult(company);
                } else {
                    EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)primaryKey, (Serializable)_nullCompany);
                }
            }
            catch (Exception e) {
                EntityCacheUtil.removeResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return company;
    }

    public Company fetchByPrimaryKey(long companyId) {
        return this.fetchByPrimaryKey(Long.valueOf(companyId));
    }

    public Map<Serializable, Company> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Company> map = new HashMap<Serializable, Company>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Company company = this.fetchByPrimaryKey(primaryKey);
            if (company != null) {
                map.put(primaryKey, company);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            Company company = (Company)EntityCacheUtil.getResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)primaryKey);
            if (company == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(primaryKey);
                continue;
            }
            map.put(primaryKey, company);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMPANY_WHERE_PKS_IN);
        for (Serializable primaryKey : uncachedPrimaryKeys) {
            query.append(String.valueOf(primaryKey));
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String sql = query.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(sql);
            for (Company company : q.list()) {
                map.put(company.getPrimaryKeyObj(), company);
                this.cacheResult(company);
                uncachedPrimaryKeys.remove(company.getPrimaryKeyObj());
            }
            for (Serializable primaryKey : uncachedPrimaryKeys) {
                EntityCacheUtil.putResult((boolean)CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)primaryKey, (Serializable)_nullCompany);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<Company> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Company> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = (List)FinderCacheUtil.getResult((FinderPath)finderPath, (Object[])finderArgs, (BasePersistenceImpl)this);
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 3);
                query.append(_SQL_SELECT_COMPANY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMPANY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY company.companyId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult((FinderPath)finderPath, (Object[])finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)finderPath, (Object[])finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Company company : this.findAll()) {
            this.remove((BaseModel)company);
        }
    }

    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMPANY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        EntityCacheUtil.removeCache((String)CompanyImpl.class.getName());
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache((String)FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private static class NullCacheModel
    implements CacheModel<Company>,
    MVCCModel {
        private NullCacheModel() {
        }

        public long getMvccVersion() {
            return 0L;
        }

        public void setMvccVersion(long mvccVersion) {
        }

        public Company toEntityModel() {
            return _nullCompany;
        }
    }
}

