/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermission;
import com.liferay.portal.util.PortalUtil;
import java.util.List;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.model.User"})
public class UserPermissionImpl
implements BaseModelPermissionChecker,
UserPermission {
    private static Log _log = LogFactoryUtil.getLog(UserPermissionImpl.class);

    @Deprecated
    public void check(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) throws PrincipalException {
        this.check(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public void check(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, organizationIds, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long userId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, userId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        List organizations = OrganizationLocalServiceUtil.getUserOrganizations((long)primaryKey);
        long[] organizationsIds = new long[organizations.size()];
        for (int i = 0; i < organizations.size(); ++i) {
            Organization organization = (Organization)organizations.get(i);
            organizationsIds[i] = organization.getOrganizationId();
        }
        this.check(permissionChecker, primaryKey, organizationsIds, actionId);
    }

    @Deprecated
    public boolean contains(PermissionChecker permissionChecker, long userId, long organizationId, long locationId, String actionId) {
        return this.contains(permissionChecker, userId, new long[]{organizationId, locationId}, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, long[] organizationIds, String actionId) {
        try {
            User user = null;
            if (userId != -1L) {
                user = UserLocalServiceUtil.getUserById((long)userId);
                if ((actionId.equals("DELETE") || actionId.equals("IMPERSONATE") || actionId.equals("PERMISSIONS") || actionId.equals("UPDATE")) && !permissionChecker.isOmniadmin() && (PortalUtil.isOmniadmin((User)user) || !permissionChecker.isCompanyAdmin() && PortalUtil.isCompanyAdmin((User)user))) {
                    return false;
                }
                Contact contact = user.getContact();
                if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), User.class.getName(), userId, contact.getUserId(), actionId) || permissionChecker.getUserId() == userId) {
                    return true;
                }
            }
            if (permissionChecker.hasPermission(0L, User.class.getName(), userId, actionId)) {
                return true;
            }
            if (user == null) {
                return false;
            }
            if (organizationIds == null) {
                organizationIds = user.getOrganizationIds();
            }
            for (long organizationId : organizationIds) {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (Organization)organization, (String)"MANAGE_USERS")) continue;
                if (permissionChecker.getUserId() == user.getUserId()) {
                    return true;
                }
                Group organizationGroup = organization.getGroup();
                if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Owner", (boolean)true) || UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)user.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Administrator", (boolean)true) && !UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)permissionChecker.getUserId(), (long)organizationGroup.getGroupId(), (String)"Organization Owner", (boolean)true)) continue;
                return true;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long userId, String actionId) {
        return this.contains(permissionChecker, userId, null, actionId);
    }
}

