/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.TeamLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.TeamPermission;

public class TeamPermissionImpl
implements TeamPermission {
    public void check(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, teamId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, team, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long teamId, String actionId) throws PortalException {
        Team team = TeamLocalServiceUtil.getTeam((long)teamId);
        return this.contains(permissionChecker, team, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Team team, String actionId) throws PortalException {
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)team.getGroupId(), (String)"MANAGE_TEAMS")) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(team.getCompanyId(), Team.class.getName(), team.getTeamId(), team.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(team.getGroupId(), Team.class.getName(), team.getTeamId(), actionId);
    }
}

