/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.service.permission.LayoutPermissionUtil;
import com.liferay.portal.service.permission.SubscriptionPermission;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBDiscussionLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBDiscussionPermission;

public class SubscriptionPermissionImpl
implements SubscriptionPermission {
    @Deprecated
    public void check(PermissionChecker permissionChecker, String className, long classPK) throws PortalException {
        this.check(permissionChecker, className, classPK, null, 0L);
    }

    public void check(PermissionChecker permissionChecker, String subscriptionClassName, long subscriptionClassPK, String inferredClassName, long inferredClassPK) throws PortalException {
        if (!this.contains(permissionChecker, subscriptionClassName, subscriptionClassPK, inferredClassName, inferredClassPK)) {
            throw new PrincipalException();
        }
    }

    @Deprecated
    public boolean contains(PermissionChecker permissionChecker, String className, long classPK) throws PortalException {
        return this.contains(permissionChecker, className, classPK, null, 0L);
    }

    public boolean contains(PermissionChecker permissionChecker, String subscriptionClassName, long subscriptionClassPK, String inferredClassName, long inferredClassPK) throws PortalException {
        Boolean hasPermission;
        if (subscriptionClassName == null) {
            return false;
        }
        if (Validator.isNotNull((String)inferredClassName) && ((hasPermission = this.hasPermission(permissionChecker, inferredClassName, inferredClassPK, "VIEW")) == null || !hasPermission.booleanValue())) {
            return false;
        }
        hasPermission = this.hasPermission(permissionChecker, subscriptionClassName, subscriptionClassPK, "SUBSCRIBE");
        if (hasPermission != null) {
            return hasPermission;
        }
        return true;
    }

    protected Boolean hasPermission(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        MBDiscussion mbDiscussion = MBDiscussionLocalServiceUtil.fetchDiscussion((String)className, (long)classPK);
        if (mbDiscussion != null) {
            if (className.equals(Layout.class.getName())) {
                return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)classPK, (String)"VIEW");
            }
            MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)mbDiscussion.getThreadId());
            if (className.equals(WorkflowInstance.class.getName())) {
                return permissionChecker.hasPermission(mbThread.getGroupId(), "151", mbThread.getGroupId(), "VIEW");
            }
            return MBDiscussionPermission.contains(permissionChecker, mbThread.getCompanyId(), mbThread.getGroupId(), className, classPK, mbThread.getUserId(), "VIEW");
        }
        return PermissionCheckerUtil.containsResourcePermission(permissionChecker, className, classPK, actionId);
    }
}

