/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.LayoutSetBranch;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutSetBranchLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutSetBranchPermission;

public class LayoutSetBranchPermissionImpl
implements LayoutSetBranchPermission {
    public void check(PermissionChecker permissionChecker, LayoutSetBranch layoutSetBranch, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutSetBranch, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long layoutSetBranchId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutSetBranchId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, LayoutSetBranch layoutSetBranch, String actionId) {
        return permissionChecker.hasPermission(layoutSetBranch.getGroupId(), LayoutSetBranch.class.getName(), layoutSetBranch.getLayoutSetBranchId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long layoutSetBranchId, String actionId) throws PortalException {
        LayoutSetBranch layoutSetBranch = LayoutSetBranchLocalServiceUtil.getLayoutSetBranch((long)layoutSetBranchId);
        return this.contains(permissionChecker, layoutSetBranch, actionId);
    }
}

