/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.User;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutPermission;
import com.liferay.portal.service.permission.LayoutPrototypePermissionUtil;
import com.liferay.portal.service.permission.LayoutSetPrototypePermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.List;

@OSGiBeanProperties(property={"model.class.name=com.liferay.portal.model.Layout"})
public class LayoutPermissionImpl
implements BaseModelPermissionChecker,
LayoutPermission {
    public void check(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, checkViewableGroup, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layout, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, groupId, privateLayout, layoutId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, plid, actionId)) {
            throw new PrincipalException();
        }
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, primaryKey, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (Group)layout.getGroup(), (String)Layout.class.getName(), (long)layout.getGroupId(), null, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        return this.containsWithViewableGroup(permissionChecker, layout, checkViewableGroup, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, false, actionId);
    }

    @Deprecated
    public boolean contains(PermissionChecker permissionChecker, Layout layout, String controlPanelCategory, boolean checkViewableGroup, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, checkViewableGroup, actionId);
    }

    @Deprecated
    public boolean contains(PermissionChecker permissionChecker, Layout layout, String controlPanelCategory, String actionId) throws PortalException {
        return this.contains(permissionChecker, layout, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        return this.contains(permissionChecker, layout, actionId);
    }

    @Deprecated
    public boolean contains(PermissionChecker permissionChecker, long groupId, boolean privateLayout, long layoutId, String controlPanelCategory, String actionId) throws PortalException {
        return this.contains(permissionChecker, groupId, privateLayout, layoutId, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long plid, String actionId) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        return this.contains(permissionChecker, layout, actionId);
    }

    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkLayoutUpdateable, String actionId) throws PortalException {
        int resourcePermissionsCount;
        if (layout.isTypeControlPanel()) {
            return false;
        }
        if (checkLayoutUpdateable && !actionId.equals("CUSTOMIZE") && !actionId.equals("VIEW") && layout instanceof VirtualLayout) {
            return false;
        }
        if (actionId.equals("CUSTOMIZE") && layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getWrappedModel();
        }
        if (actionId.equals("ADD_LAYOUT")) {
            if (!SitesUtil.isLayoutSortable((Layout)layout)) {
                return false;
            }
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isParentable()) {
                return false;
            }
        }
        if (actionId.equals("DELETE") && !SitesUtil.isLayoutDeleteable((Layout)layout)) {
            return false;
        }
        Group group = layout.getGroup();
        if (checkLayoutUpdateable && !group.isLayoutSetPrototype() && this.isAttemptToModifyLockedLayout(layout, actionId)) {
            return false;
        }
        User user = permissionChecker.getUser();
        if (!user.isDefaultUser() && !group.isUser()) {
            ResourcePermission resourcePermission = ResourcePermissionLocalServiceUtil.getResourcePermission((long)layout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(layout.getPlid()), (long)permissionChecker.getOwnerRoleId());
            if (permissionChecker.hasOwnerPermission(layout.getCompanyId(), Layout.class.getName(), String.valueOf(layout.getPlid()), resourcePermission.getOwnerId(), actionId)) {
                return true;
            }
        }
        if (actionId.equals("ADD_LAYOUT") && GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ADD_LAYOUT")) {
            return true;
        }
        if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS")) {
            return true;
        }
        if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE && !actionId.equals("VIEW")) {
            long parentLayoutId = layout.getParentLayoutId();
            while (parentLayoutId != 0L) {
                Layout parentLayout = LayoutLocalServiceUtil.getLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)parentLayoutId);
                if (this.contains(permissionChecker, parentLayout, actionId)) {
                    return true;
                }
                parentLayoutId = parentLayout.getParentLayoutId();
            }
        }
        if ((resourcePermissionsCount = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)layout.getCompanyId(), (String)Layout.class.getName(), (int)4, (String)String.valueOf(layout.getPlid()))) == 0) {
            boolean addGroupPermission = true;
            boolean addGuestPermission = true;
            if (layout.isPrivateLayout()) {
                addGuestPermission = false;
            }
            ResourceLocalServiceUtil.addResources((long)layout.getCompanyId(), (long)layout.getGroupId(), (long)0L, (String)Layout.class.getName(), (long)layout.getPlid(), (boolean)false, (boolean)addGroupPermission, (boolean)addGuestPermission);
        }
        return permissionChecker.hasPermission(layout.getGroupId(), Layout.class.getName(), layout.getPlid(), actionId);
    }

    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, String actionId) throws PortalException {
        return this.containsWithoutViewableGroup(permissionChecker, layout, true, actionId);
    }

    @Deprecated
    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, String controlPanelCategory, boolean checkLayoutUpdateable, String actionId) throws PortalException {
        return this.containsWithoutViewableGroup(permissionChecker, layout, checkLayoutUpdateable, actionId);
    }

    @Deprecated
    public boolean containsWithoutViewableGroup(PermissionChecker permissionChecker, Layout layout, String controlPanelCategory, String actionId) throws PortalException {
        return this.containsWithoutViewableGroup(permissionChecker, layout, actionId);
    }

    protected boolean containsWithViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkViewableGroup, String actionId) throws PortalException {
        if (actionId.equals("VIEW") && checkViewableGroup) {
            return this.isViewableGroup(permissionChecker, layout, checkViewableGroup);
        }
        return this.containsWithoutViewableGroup(permissionChecker, layout, actionId);
    }

    protected boolean isAttemptToModifyLockedLayout(Layout layout, String actionId) {
        return ("CUSTOMIZE".equals(actionId) || "UPDATE".equals(actionId)) && !SitesUtil.isLayoutUpdateable((Layout)layout);
    }

    protected boolean isViewableGroup(PermissionChecker permissionChecker, Layout layout, boolean checkResourcePermission) throws PortalException {
        Group liveGroup;
        Group group = GroupLocalServiceUtil.getGroup((long)layout.getGroupId());
        if (!group.isActive()) {
            return false;
        }
        if (group.isStagingGroup() && !(liveGroup = group.getLiveGroup()).isActive()) {
            return false;
        }
        if (group.isUser()) {
            long groupUserId = group.getClassPK();
            if (groupUserId == permissionChecker.getUserId()) {
                return true;
            }
            User groupUser = UserLocalServiceUtil.getUserById((long)groupUserId);
            if (!groupUser.isActive()) {
                return false;
            }
            if (layout.isPrivateLayout()) {
                return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS") || UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupUserId, (long[])groupUser.getOrganizationIds(), (String)"UPDATE");
            }
        }
        if (group.isStagingGroup()) {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW_STAGING");
        }
        if (group.isSite()) {
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"MANAGE_LAYOUTS") || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"UPDATE")) {
                return true;
            }
            if (layout.isPrivateLayout() && !permissionChecker.isGroupMember(group.getGroupId())) {
                return false;
            }
        }
        if (group.isCompany()) {
            return false;
        }
        if (group.isLayoutPrototype()) {
            return LayoutPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
        }
        if (group.isLayoutSetPrototype()) {
            return LayoutSetPrototypePermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"VIEW");
        }
        if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            if (OrganizationLocalServiceUtil.hasUserOrganization((long)permissionChecker.getUserId(), (long)organizationId, (boolean)false, (boolean)false)) {
                return true;
            }
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organizationId, (String)"UPDATE")) {
                return true;
            }
            if (!PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) {
                List userOrgs = OrganizationLocalServiceUtil.getUserOrganizations((long)permissionChecker.getUserId());
                for (Organization organization : userOrgs) {
                    for (Organization ancestorOrganization : organization.getAncestors()) {
                        if (organizationId != ancestorOrganization.getOrganizationId()) continue;
                        return true;
                    }
                }
            }
        } else if (group.isUserGroup() && UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getClassPK(), (String)"UPDATE")) {
            return true;
        }
        if (this.containsWithoutViewableGroup(permissionChecker, layout, "VIEW")) {
            return true;
        }
        List layouts = LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)0L);
        for (Layout curLayout : layouts) {
            if (!this.containsWithoutViewableGroup(permissionChecker, curLayout, "VIEW") || curLayout.isHidden()) continue;
            return true;
        }
        return false;
    }
}

