/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutBranchLocalServiceUtil;
import com.liferay.portal.service.permission.LayoutBranchPermission;

public class LayoutBranchPermissionImpl
implements LayoutBranchPermission {
    public void check(PermissionChecker permissionChecker, LayoutBranch layoutBranch, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutBranch, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long layoutBranchId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, layoutBranchId, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, LayoutBranch layoutBranch, String actionId) {
        return permissionChecker.hasPermission(layoutBranch.getGroupId(), LayoutBranch.class.getName(), layoutBranch.getLayoutBranchId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long layoutBranchId, String actionId) throws PortalException {
        LayoutBranch layoutBranch = LayoutBranchLocalServiceUtil.getLayoutBranch((long)layoutBranchId);
        return this.contains(permissionChecker, layoutBranch, actionId);
    }
}

