/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.CommonPermission;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PortalUtil;

public class CommonPermissionImpl
implements CommonPermission {
    private static Log _log = LogFactoryUtil.getLog(CommonPermissionImpl.class);

    public void check(PermissionChecker permissionChecker, long classNameId, long classPK, String actionId) throws PortalException {
        String className = PortalUtil.getClassName((long)classNameId);
        this.check(permissionChecker, className, classPK, actionId);
    }

    public void check(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        if (!className.equals(Account.class.getName()) && !className.equals(Company.class.getName())) {
            if (className.equals(Contact.class.getName())) {
                User user = UserLocalServiceUtil.getUserByContactId((long)classPK);
                UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)actionId);
            } else if (className.equals(Organization.class.getName())) {
                OrganizationPermissionUtil.check((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
            } else if (className.equals(User.class.getName())) {
                UserPermissionUtil.check((PermissionChecker)permissionChecker, (long)classPK, (String)actionId);
            } else {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Invalid class name " + className));
                }
                throw new PrincipalException();
            }
        }
    }
}

