/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.membershippolicy.UserGroupMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserGroupServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.TeamPermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserGroupServiceImpl
extends UserGroupServiceBaseImpl {
    public void addGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.addGroupUserGroups(groupId, userGroupIds);
    }

    public void addTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.addTeamUserGroups(teamId, userGroupIds);
    }

    @Deprecated
    public UserGroup addUserGroup(String name, String description) throws PortalException {
        return this.addUserGroup(name, description, null);
    }

    public UserGroup addUserGroup(String name, String description, ServiceContext serviceContext) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_USER_GROUP");
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.addUserGroup(user.getUserId(), user.getCompanyId(), name, description, serviceContext);
        UserGroupMembershipPolicyUtil.verifyPolicy((UserGroup)userGroup);
        return userGroup;
    }

    public void deleteUserGroup(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"DELETE");
        this.userGroupLocalService.deleteUserGroup(userGroupId);
    }

    public UserGroup getUserGroup(long userGroupId) throws PortalException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"VIEW");
        return this.userGroupLocalService.getUserGroup(userGroupId);
    }

    public UserGroup getUserGroup(String name) throws PortalException {
        User user = this.getUser();
        UserGroup userGroup = this.userGroupLocalService.getUserGroup(user.getCompanyId(), name);
        long userGroupId = userGroup.getUserGroupId();
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"VIEW");
        return userGroup;
    }

    public List<UserGroup> getUserUserGroups(long userId) throws PortalException {
        UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        List userGroups = this.userGroupLocalService.getUserUserGroups(userId);
        return this.filterUserGroups(userGroups);
    }

    public void unsetGroupUserGroups(long groupId, long[] userGroupIds) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetGroupUserGroups(groupId, userGroupIds);
    }

    public void unsetTeamUserGroups(long teamId, long[] userGroupIds) throws PortalException {
        TeamPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)teamId, (String)"ASSIGN_MEMBERS");
        this.userGroupLocalService.unsetTeamUserGroups(teamId, userGroupIds);
    }

    @Deprecated
    public UserGroup updateUserGroup(long userGroupId, String name, String description) throws PortalException {
        UserGroup oldUserGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        ExpandoBridge oldExpandoBridge = oldUserGroup.getExpandoBridge();
        Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
        UserGroup userGroup = this.updateUserGroup(userGroupId, name, description, null);
        UserGroupMembershipPolicyUtil.verifyPolicy((UserGroup)userGroup, (UserGroup)oldUserGroup, (Map)oldExpandoAttributes);
        return userGroup;
    }

    public UserGroup updateUserGroup(long userGroupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        UserGroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userGroupId, (String)"UPDATE");
        User user = this.getUser();
        return this.userGroupLocalService.updateUserGroup(user.getCompanyId(), userGroupId, name, description, serviceContext);
    }

    protected List<UserGroup> filterUserGroups(List<UserGroup> userGroups) throws PortalException {
        ArrayList<UserGroup> filteredGroups = new ArrayList<UserGroup>();
        for (UserGroup userGroup : userGroups) {
            if (!UserGroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)userGroup.getUserGroupId(), (String)"VIEW")) continue;
            filteredGroups.add(userGroup);
        }
        return filteredGroups;
    }
}

