/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.UserGroupRoleServiceBaseImpl;
import com.liferay.portal.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.util.ArrayList;

public class UserGroupRoleServiceImpl
extends UserGroupRoleServiceBaseImpl {
    public void addUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        ArrayList<UserGroupRole> organizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> siteUserGroupRoles = new ArrayList<UserGroupRole>();
        Group group = this.groupLocalService.getGroup(groupId);
        for (long roleId : roleIds) {
            Role role = this.rolePersistence.findByPrimaryKey(roleId);
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (Role)role);
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            if (role.getType() == 3) {
                organizationUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2) continue;
            siteUserGroupRoles.add(userGroupRole);
        }
        if (!siteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.checkRoles(siteUserGroupRoles, null);
        }
        if (!organizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.checkRoles(organizationUserGroupRoles, null);
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, roleIds);
        if (!siteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(siteUserGroupRoles, null);
        }
        if (!organizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(organizationUserGroupRoles, null);
        }
    }

    public void addUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException {
        UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)roleId);
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long userId : userIds) {
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            userGroupRoles.add(userGroupRole);
        }
        if (userGroupRoles.isEmpty()) {
            return;
        }
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.checkRoles(userGroupRoles, null);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.checkRoles(userGroupRoles, null);
        }
        this.userGroupRoleLocalService.addUserGroupRoles(userIds, groupId, roleId);
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.propagateRoles(userGroupRoles, null);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.propagateRoles(userGroupRoles, null);
        }
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) throws PortalException {
        ArrayList<UserGroupRole> filteredOrganizationUserGroupRoles = new ArrayList<UserGroupRole>();
        ArrayList<UserGroupRole> filteredSiteUserGroupRoles = new ArrayList<UserGroupRole>();
        Group group = this.groupLocalService.getGroup(groupId);
        for (long roleId : roleIds) {
            Role role = this.roleLocalService.getRole(roleId);
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (Role)role);
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            if (role.getType() == 3) {
                if (OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)group.getOrganizationId(), (long)roleId)) continue;
                filteredOrganizationUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2 || SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)groupId, (long)roleId)) continue;
            filteredSiteUserGroupRoles.add(userGroupRole);
        }
        if (filteredOrganizationUserGroupRoles.isEmpty() && filteredSiteUserGroupRoles.isEmpty()) {
            return;
        }
        if (!filteredOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.checkRoles(null, filteredOrganizationUserGroupRoles);
        }
        if (!filteredSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.checkRoles(null, filteredSiteUserGroupRoles);
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupId, roleIds);
        if (!filteredOrganizationUserGroupRoles.isEmpty()) {
            OrganizationMembershipPolicyUtil.propagateRoles(null, filteredOrganizationUserGroupRoles);
        }
        if (!filteredSiteUserGroupRoles.isEmpty()) {
            SiteMembershipPolicyUtil.propagateRoles(null, filteredSiteUserGroupRoles);
        }
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) throws PortalException {
        UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)roleId);
        ArrayList<UserGroupRole> filteredUserGroupRoles = new ArrayList<UserGroupRole>();
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        for (long userId : userIds) {
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            UserGroupRole userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            if (role.getType() == 3) {
                Group group = this.groupPersistence.findByPrimaryKey(groupId);
                if (OrganizationMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)group.getOrganizationId(), (long)roleId)) continue;
                filteredUserGroupRoles.add(userGroupRole);
                continue;
            }
            if (role.getType() != 2 || SiteMembershipPolicyUtil.isRoleProtected((PermissionChecker)this.getPermissionChecker(), (long)userId, (long)groupId, (long)roleId)) continue;
            filteredUserGroupRoles.add(userGroupRole);
        }
        if (filteredUserGroupRoles.isEmpty()) {
            return;
        }
        if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.checkRoles(null, filteredUserGroupRoles);
        } else if (role.getType() == 2) {
            SiteMembershipPolicyUtil.checkRoles(null, filteredUserGroupRoles);
        }
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, roleId);
        if (role.getType() == 2) {
            SiteMembershipPolicyUtil.propagateRoles(null, filteredUserGroupRoles);
        } else if (role.getType() == 3) {
            OrganizationMembershipPolicyUtil.propagateRoles(null, filteredUserGroupRoles);
        }
    }
}

