/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchUserGroupRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupRoleLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import java.util.ArrayList;
import java.util.List;

public class UserGroupRoleLocalServiceImpl
extends UserGroupRoleLocalServiceBaseImpl {
    public List<UserGroupRole> addUserGroupRoles(long userId, long groupId, long[] roleIds) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long roleId : roleIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUser(groupId, userId);
        }
        PermissionCacheUtil.clearCache();
        return userGroupRoles;
    }

    public List<UserGroupRole> addUserGroupRoles(long[] userIds, long groupId, long roleId) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        for (long userId : userIds) {
            UserGroupRole userGroupRole = this.addUserGroupRole(userId, groupId, roleId);
            userGroupRoles.add(userGroupRole);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group.isRegularSite()) {
            this.groupPersistence.addUsers(groupId, userIds);
        }
        PermissionCacheUtil.clearCache();
        return userGroupRoles;
    }

    @Override
    public UserGroupRole deleteUserGroupRole(UserGroupRole userGroupRole) {
        this.userGroupRolePersistence.remove((BaseModel)userGroupRole);
        PermissionCacheUtil.clearCache();
        return userGroupRole;
    }

    public void deleteUserGroupRoles(long userId, long groupId, long[] roleIds) {
        for (long roleId : roleIds) {
            UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(userGroupRolePK);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long userId, long[] groupIds) {
        for (long groupId : groupIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId) {
        for (long userId : userIds) {
            this.userGroupRolePersistence.removeByU_G(userId, groupId);
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, int roleType) {
        List roles = this.rolePersistence.findByT_S(roleType, "");
        for (long userId : userIds) {
            for (Role role : roles) {
                UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, role.getRoleId());
                try {
                    this.userGroupRolePersistence.remove(userGroupRolePK);
                }
                catch (NoSuchUserGroupRoleException nsugre) {}
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRoles(long[] userIds, long groupId, long roleId) {
        for (long userId : userIds) {
            UserGroupRolePK pk = new UserGroupRolePK(userId, groupId, roleId);
            try {
                this.userGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupRoleException nsugre) {
                // empty catch block
            }
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByGroupId(long groupId) {
        this.userGroupRolePersistence.removeByGroupId(groupId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByRoleId(long roleId) {
        this.userGroupRolePersistence.removeByRoleId(roleId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupRolesByUserId(long userId) {
        this.userGroupRolePersistence.removeByUserId(userId);
        PermissionCacheUtil.clearCache();
    }

    public List<UserGroupRole> getUserGroupRoles(long userId) {
        return this.userGroupRolePersistence.findByUserId(userId);
    }

    public List<UserGroupRole> getUserGroupRoles(long userId, long groupId) {
        return this.userGroupRolePersistence.findByU_G(userId, groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroup(long groupId) {
        return this.userGroupRolePersistence.findByGroupId(groupId);
    }

    public List<UserGroupRole> getUserGroupRolesByGroupAndRole(long groupId, long roleId) {
        return this.userGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public List<UserGroupRole> getUserGroupRolesByUserUserGroupAndGroup(long userId, long groupId) {
        return this.userGroupRoleFinder.findByUserUserGroupGroupRole(userId, groupId);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId) {
        return this.hasUserGroupRole(userId, groupId, roleId, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, long roleId, boolean inherit) {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole != null) {
            return true;
        }
        return inherit && this.roleFinder.countByU_G_R(userId, groupId, roleId) > 0;
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName) throws PortalException {
        return this.hasUserGroupRole(userId, groupId, roleName, false);
    }

    public boolean hasUserGroupRole(long userId, long groupId, String roleName, boolean inherit) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long companyId = user.getCompanyId();
        Role role = this.rolePersistence.fetchByC_N(companyId, roleName);
        if (role == null) {
            return false;
        }
        return this.hasUserGroupRole(userId, groupId, role.getRoleId(), inherit);
    }

    protected UserGroupRole addUserGroupRole(long userId, long groupId, long roleId) {
        UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupId, roleId);
        UserGroupRole userGroupRole = this.userGroupRolePersistence.fetchByPrimaryKey(userGroupRolePK);
        if (userGroupRole == null) {
            userGroupRole = this.userGroupRolePersistence.create(userGroupRolePK);
            this.userGroupRolePersistence.update((BaseModel)userGroupRole);
        }
        return userGroupRole;
    }
}

