/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.TicketLocalServiceBaseImpl;
import java.util.Date;

public class TicketLocalServiceImpl
extends TicketLocalServiceBaseImpl {
    public Ticket addTicket(long companyId, String className, long classPK, int type, String extraInfo, Date expirationDate, ServiceContext serviceContext) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Date now = new Date();
        long ticketId = this.counterLocalService.increment();
        Ticket ticket = this.ticketPersistence.create(ticketId);
        ticket.setCompanyId(companyId);
        ticket.setCreateDate(now);
        ticket.setClassNameId(classNameId);
        ticket.setClassPK(classPK);
        ticket.setKey(PortalUUIDUtil.generate());
        ticket.setType(type);
        ticket.setExtraInfo(extraInfo);
        ticket.setExpirationDate(expirationDate);
        this.ticketPersistence.update((BaseModel)ticket);
        return ticket;
    }

    public Ticket fetchTicket(String key) {
        return this.ticketPersistence.fetchByKey(key);
    }

    public Ticket getTicket(String key) throws PortalException {
        return this.ticketPersistence.findByKey(key);
    }
}

