/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.SubscriptionLocalServiceBaseImpl;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import java.util.Date;
import java.util.List;

public class SubscriptionLocalServiceImpl
extends SubscriptionLocalServiceBaseImpl {
    public Subscription addSubscription(long userId, long groupId, String className, long classPK) throws PortalException {
        return this.addSubscription(userId, groupId, className, classPK, "instant");
    }

    public Subscription addSubscription(long userId, long groupId, String className, long classPK, String frequency) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Date now = new Date();
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
        if (subscription == null) {
            long subscriptionId = this.counterLocalService.increment();
            subscription = this.subscriptionPersistence.create(subscriptionId);
            subscription.setCompanyId(user.getCompanyId());
            subscription.setUserId(user.getUserId());
            subscription.setUserName(user.getFullName());
            subscription.setCreateDate(now);
            subscription.setModifiedDate(now);
            subscription.setClassNameId(classNameId);
            subscription.setClassPK(classPK);
            subscription.setFrequency(frequency);
            this.subscriptionPersistence.update((BaseModel)subscription);
        }
        if (groupId > 0L) {
            AssetEntry assetEntry = null;
            try {
                assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
            }
            catch (Exception e) {
                assetEntry = this.assetEntryLocalService.updateEntry(userId, groupId, subscription.getCreateDate(), subscription.getModifiedDate(), className, classPK, null, 0L, null, null, false, null, null, null, null, String.valueOf(groupId), null, null, null, null, 0, 0, null, false);
            }
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", assetEntry.getTitle());
            if (className.equals(MBThread.class.getName())) {
                MBThread mbThread = this.mbThreadLocalService.getMBThread(classPK);
                extraDataJSONObject.put("threadId", classPK);
                this.socialActivityLocalService.addActivity(userId, groupId, MBMessage.class.getName(), mbThread.getRootMessageId(), 10002, extraDataJSONObject.toString(), 0L);
            } else if (classPK != groupId) {
                this.socialActivityLocalService.addActivity(userId, groupId, className, classPK, 10002, extraDataJSONObject.toString(), 0L);
            }
        }
        return subscription;
    }

    @Override
    public Subscription deleteSubscription(long subscriptionId) throws PortalException {
        Subscription subscription = this.subscriptionPersistence.findByPrimaryKey(subscriptionId);
        return this.deleteSubscription(subscription);
    }

    public void deleteSubscription(long userId, String className, long classPK) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
        if (subscription != null) {
            this.deleteSubscription(subscription);
        }
    }

    @Override
    public Subscription deleteSubscription(Subscription subscription) throws PortalException {
        this.subscriptionPersistence.remove((BaseModel)subscription);
        AssetEntry assetEntry = this.assetEntryPersistence.fetchByC_C(subscription.getClassNameId(), subscription.getClassPK());
        if (assetEntry != null) {
            ClassName className = this.classNameLocalService.getClassName(subscription.getClassNameId());
            String subscriptionClassName = className.getValue();
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("title", assetEntry.getTitle());
            this.socialActivityLocalService.addActivity(subscription.getUserId(), assetEntry.getGroupId(), subscriptionClassName, subscription.getClassPK(), 10003, extraDataJSONObject.toString(), 0L);
        }
        return subscription;
    }

    public void deleteSubscriptions(long userId) throws PortalException {
        List subscriptions = this.subscriptionPersistence.findByUserId(userId);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public void deleteSubscriptions(long companyId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List subscriptions = this.subscriptionPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Subscription subscription : subscriptions) {
            this.deleteSubscription(subscription);
        }
    }

    public Subscription getSubscription(long companyId, long userId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, classNameId, classPK);
    }

    public List<Subscription> getSubscriptions(long companyId, long userId, String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, classNameId, classPKs);
    }

    public List<Subscription> getSubscriptions(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.subscriptionPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public List<Subscription> getUserSubscriptions(long userId, int start, int end, OrderByComparator<Subscription> orderByComparator) {
        return this.subscriptionPersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public List<Subscription> getUserSubscriptions(long userId, String className) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.subscriptionPersistence.findByU_C(userId, classNameId);
    }

    public int getUserSubscriptionsCount(long userId) {
        return this.subscriptionPersistence.countByUserId(userId);
    }

    public boolean isSubscribed(long companyId, long userId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(companyId, userId, classNameId, classPK);
        return subscription != null;
    }

    public boolean isSubscribed(long companyId, long userId, String className, long[] classPKs) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        int count = this.subscriptionPersistence.countByC_U_C_C(companyId, userId, classNameId, classPKs);
        return count > 0;
    }
}

