/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateRoleException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchShardException;
import com.liferay.portal.RequiredRoleException;
import com.liferay.portal.RoleNameException;
import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.ThreadLocalCache;
import com.liferay.portal.kernel.cache.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourceBlockPermission;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.ResourceTypePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.Shard;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RoleLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RoleLocalServiceImpl
extends RoleLocalServiceBaseImpl {
    private Map<String, Role> _systemRolesMap = new HashMap<String, Role>();

    @Deprecated
    public Role addRole(long userId, long companyId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type) throws PortalException {
        return this.addRole(userId, null, 0L, name, titleMap, descriptionMap, type, null, null);
    }

    @Deprecated
    public Role addRole(long userId, long companyId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String className, long classPK) throws PortalException {
        return this.addRole(userId, className, classPK, name, titleMap, descriptionMap, type, null, null);
    }

    public Role addRole(long userId, String className, long classPK, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, int type, String subtype, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString((String)className);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long roleId = this.counterLocalService.increment();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            classNameId = this.classNameLocalService.getClassNameId(Role.class);
            classPK = roleId;
        }
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, name);
        Role role = this.rolePersistence.create(roleId);
        if (serviceContext != null) {
            role.setUuid(serviceContext.getUuid());
        }
        role.setCompanyId(user.getCompanyId());
        role.setUserId(user.getUserId());
        role.setUserName(user.getFullName());
        if (serviceContext != null) {
            role.setCreateDate(serviceContext.getCreateDate(now));
            role.setModifiedDate(serviceContext.getModifiedDate(now));
        } else {
            role.setCreateDate(now);
            role.setModifiedDate(now);
        }
        role.setClassNameId(classNameId);
        role.setClassPK(classPK);
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setType(type);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        this.rolePersistence.update((BaseModel)role);
        if (!user.isDefaultUser()) {
            this.resourceLocalService.addResources(user.getCompanyId(), 0L, userId, Role.class.getName(), role.getRoleId(), false, false, false);
            if (!ExportImportThreadLocal.isImportInProcess()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
                indexer.reindex((Object)userId);
            }
        }
        return role;
    }

    @Override
    public void addUserRoles(long userId, long[] roleIds) throws PortalException {
        this.userPersistence.addRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public void checkSystemRoles() throws PortalException {
        List companies = this.companyLocalService.getCompanies();
        String currentShardName = ShardUtil.getCurrentShardName();
        for (Company company : companies) {
            String shardName = null;
            try {
                shardName = company.getShardName();
            }
            catch (NoSuchShardException nsse) {
                Shard shard = this.shardLocalService.addShard(Company.class.getName(), company.getCompanyId(), PropsValues.SHARD_DEFAULT_NAME);
                shardName = shard.getName();
            }
            if (ShardUtil.isEnabled() && !shardName.equals(currentShardName)) continue;
            this.checkSystemRoles(company.getCompanyId());
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemRoles(long companyId) throws PortalException {
        String[] userViewableRoles;
        String[] systemSiteRoles;
        String[] systemOrganizationRoles;
        String[] systemRoles;
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        List roles = null;
        try {
            roles = this.roleFinder.findBySystem(companyId);
        }
        catch (Exception e) {
            this.runSQL("alter table Role_ add uuid_ VARCHAR(75) null");
            this.runSQL("alter table Role_ add userId LONG");
            this.runSQL("alter table Role_ add userName VARCHAR(75) null");
            this.runSQL("alter table Role_ add createDate DATE null");
            this.runSQL("alter table Role_ add modifiedDate DATE null");
            roles = this.roleFinder.findBySystem(companyId);
        }
        for (Role role : roles) {
            this._systemRolesMap.put(companyIdHexString.concat(role.getName()), role);
        }
        for (String name : systemRoles = PortalUtil.getSystemRoles()) {
            String key = "system.role." + StringUtil.replace((String)name, (char)' ', (char)'.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 1;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        for (String name : systemOrganizationRoles = PortalUtil.getSystemOrganizationRoles()) {
            String key = "system.organization.role." + StringUtil.replace((String)name, (char)' ', (char)'.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 3;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        for (String name : systemSiteRoles = PortalUtil.getSystemSiteRoles()) {
            String key = "system.site.role." + StringUtil.replace((String)name, (char)' ', (char)'.') + ".description";
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), PropsUtil.get(key));
            int type = 2;
            this.checkSystemRole(companyId, name, descriptionMap, type);
        }
        Role userRole = this.getRole(companyId, "User");
        for (String roleName : userViewableRoles = (String[])ArrayUtil.append((Object[][])new String[][]{systemRoles, systemOrganizationRoles, systemSiteRoles})) {
            Role role = this.getRole(companyId, roleName);
            this.resourcePermissionLocalService.setResourcePermissions(companyId, Role.class.getName(), 4, String.valueOf(role.getRoleId()), userRole.getRoleId(), new String[]{"VIEW"});
        }
    }

    @Override
    public Role deleteRole(long roleId) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        return this.roleLocalService.deleteRole(role);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Role deleteRole(Role role) throws PortalException {
        if (PortalUtil.isSystemRole((String)role.getName()) && !CompanyThreadLocal.isDeleteInProcess()) {
            throw new RequiredRoleException();
        }
        List resourceBlockPermissions = this.resourceBlockPermissionPersistence.findByRoleId(role.getRoleId());
        for (ResourceBlockPermission resourceBlockPermission : resourceBlockPermissions) {
            this.resourceBlockPermissionLocalService.deleteResourceBlockPermission(resourceBlockPermission);
        }
        List resourcePermissions = this.resourcePermissionPersistence.findByRoleId(role.getRoleId());
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        List resourceTypePermissions = this.resourceTypePermissionPersistence.findByRoleId(role.getRoleId());
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            this.resourceTypePermissionLocalService.deleteResourceTypePermission(resourceTypePermission);
        }
        String className = role.getClassName();
        long classNameId = role.getClassNameId();
        if (classNameId <= 0L || className.equals(Role.class.getName())) {
            this.resourceLocalService.deleteResource(role.getCompanyId(), Role.class.getName(), 4, role.getRoleId());
        }
        if (role.getType() == 3 || role.getType() == 2) {
            this.userGroupRoleLocalService.deleteUserGroupRolesByRoleId(role.getRoleId());
            this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByRoleId(role.getRoleId());
        }
        this.rolePersistence.remove((BaseModel)role);
        this.expandoRowLocalService.deleteRows(role.getRoleId());
        PermissionCacheUtil.clearCache();
        return role;
    }

    @Skip
    public Role fetchRole(long companyId, String name) {
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        Role role = this._systemRolesMap.get(companyIdHexString.concat(name));
        if (role != null) {
            return role;
        }
        return this.roleLocalService.loadFetchRole(companyId, name);
    }

    public Role getDefaultGroupRole(long groupId) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            group = layout.getGroup();
        }
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        Role role = null;
        role = group.isCompany() ? this.getRole(group.getCompanyId(), "User") : (group.isLayoutPrototype() || group.isLayoutSetPrototype() || group.isRegularSite() || group.isSite() ? this.getRole(group.getCompanyId(), "Site Member") : (group.isOrganization() ? this.getRole(group.getCompanyId(), "Organization User") : (group.isUser() || group.isUserGroup() ? this.getRole(group.getCompanyId(), "Power User") : this.getRole(group.getCompanyId(), "User"))));
        return role;
    }

    public List<Role> getGroupRelatedRoles(long groupId) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>();
        Group group = this.groupLocalService.getGroup(groupId);
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        int[] types = RoleConstants.TYPES_REGULAR;
        if (group.isOrganization()) {
            types = RoleConstants.TYPES_ORGANIZATION_AND_REGULAR;
        } else if (group.isLayout() || group.isLayoutSetPrototype() || group.isSite()) {
            types = RoleConstants.TYPES_REGULAR_AND_SITE;
        }
        roles.addAll(this.getRoles(group.getCompanyId(), types));
        roles.addAll(this.getTeamRoles(groupId));
        return roles;
    }

    public List<Role> getResourceBlockRoles(long resourceBlockId, String className, String actionId) {
        return this.roleFinder.findByR_N_A(resourceBlockId, className, actionId);
    }

    public Map<String, List<String>> getResourceRoles(long companyId, String name, int scope, String primKey) {
        return this.roleFinder.findByC_N_S_P(companyId, name, scope, primKey);
    }

    public List<Role> getResourceRoles(long companyId, String name, int scope, String primKey, String actionId) {
        return this.roleFinder.findByC_N_S_P_A(companyId, name, scope, primKey, actionId);
    }

    @Skip
    public Role getRole(long companyId, String name) throws PortalException {
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        Role role = this._systemRolesMap.get(companyIdHexString.concat(name));
        if (role != null) {
            return role;
        }
        return this.roleLocalService.loadGetRole(companyId, name);
    }

    public List<Role> getRoles(int type, String subtype) {
        return this.rolePersistence.findByT_S(type, subtype);
    }

    public List<Role> getRoles(long companyId) {
        return this.rolePersistence.findByCompanyId(companyId);
    }

    public List<Role> getRoles(long companyId, int[] types) {
        return this.rolePersistence.findByC_T(companyId, types);
    }

    public List<Role> getRoles(long[] roleIds) throws PortalException {
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.length);
        for (long roleId : roleIds) {
            Role role = this.getRole(roleId);
            roles.add(role);
        }
        return roles;
    }

    public List<Role> getSubtypeRoles(String subtype) {
        return this.rolePersistence.findBySubtype(subtype);
    }

    public int getSubtypeRolesCount(String subtype) {
        return this.rolePersistence.countBySubtype(subtype);
    }

    public Role getTeamRole(long companyId, long teamId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(Team.class);
        return this.rolePersistence.findByC_C_C(companyId, classNameId, teamId);
    }

    public Map<Team, Role> getTeamRoleMap(long groupId) throws PortalException {
        return this.getTeamRoleMap(groupId, null);
    }

    public List<Role> getTeamRoles(long groupId) throws PortalException {
        return this.getTeamRoles(groupId, null);
    }

    public List<Role> getTeamRoles(long groupId, long[] excludedRoleIds) throws PortalException {
        Map<Team, Role> teamRoleMap = this.getTeamRoleMap(groupId, excludedRoleIds);
        Collection<Role> roles = teamRoleMap.values();
        return ListUtil.fromCollection(roles);
    }

    public List<Role> getTypeRoles(int type) {
        return this.rolePersistence.findByType(type);
    }

    public List<Role> getTypeRoles(int type, int start, int end) {
        return this.rolePersistence.findByType(type, start, end);
    }

    public int getTypeRolesCount(int type) {
        return this.rolePersistence.countByType(type);
    }

    public List<Role> getUserGroupGroupRoles(long userId, long groupId) {
        return this.roleFinder.findByUserGroupGroupRole(userId, groupId);
    }

    public List<Role> getUserGroupRoles(long userId, long groupId) {
        return this.roleFinder.findByUserGroupRole(userId, groupId);
    }

    public List<Role> getUserRelatedRoles(long userId, List<Group> groups) {
        if (groups == null || groups.isEmpty()) {
            return Collections.emptyList();
        }
        return this.roleFinder.findByU_G(userId, groups);
    }

    public List<Role> getUserRelatedRoles(long userId, long groupId) {
        return this.roleFinder.findByU_G(userId, groupId);
    }

    public List<Role> getUserRelatedRoles(long userId, long[] groupIds) {
        return this.roleFinder.findByU_G(userId, groupIds);
    }

    @ThreadLocalCachable
    public boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws PortalException {
        Role role = this.rolePersistence.fetchByC_N(companyId, name);
        if (role == null) {
            return false;
        }
        if (role.getType() != 1) {
            throw new IllegalArgumentException(name + " is not a regular role");
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        if (userId == defaultUserId) {
            return name.equals("Guest");
        }
        if (inherited) {
            String key;
            if (this.userPersistence.containsRole(userId, role.getRoleId())) {
                return true;
            }
            ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)Lifecycle.REQUEST, (Serializable)((Object)RoleLocalServiceImpl.class.getName()));
            Integer value = (Integer)threadLocalCache.get(key = String.valueOf(role.getRoleId()).concat(String.valueOf(userId)));
            if (value == null) {
                value = this.roleFinder.countByR_U(role.getRoleId(), userId);
                threadLocalCache.put(key, (Object)value);
            }
            return value > 0;
        }
        return this.userPersistence.containsRole(userId, role.getRoleId());
    }

    public boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws PortalException {
        for (String name : names) {
            if (!this.hasUserRole(userId, companyId, name, inherited)) continue;
            return true;
        }
        return false;
    }

    public Role loadFetchRole(long companyId, String name) {
        return this.rolePersistence.fetchByC_N(companyId, name);
    }

    public Role loadGetRole(long companyId, String name) throws PortalException {
        return this.rolePersistence.findByC_N(companyId, name);
    }

    public List<Role> search(long companyId, String keywords, Integer[] types, int start, int end, OrderByComparator<Role> obc) {
        return this.search(companyId, keywords, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    public List<Role> search(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> obc) {
        return this.roleFinder.findByKeywords(companyId, keywords, types, params, start, end, obc);
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, int start, int end, OrderByComparator<Role> obc) {
        return this.search(companyId, name, description, types, new LinkedHashMap<String, Object>(), start, end, obc);
    }

    public List<Role> search(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Role> obc) {
        return this.roleFinder.findByC_N_D_T(companyId, name, description, types, params, true, start, end, obc);
    }

    public int searchCount(long companyId, String keywords, Integer[] types) {
        return this.searchCount(companyId, keywords, types, new LinkedHashMap<String, Object>());
    }

    public int searchCount(long companyId, String keywords, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByKeywords(companyId, keywords, types, params);
    }

    public int searchCount(long companyId, String name, String description, Integer[] types) {
        return this.searchCount(companyId, name, description, types, new LinkedHashMap<String, Object>());
    }

    public int searchCount(long companyId, String name, String description, Integer[] types, LinkedHashMap<String, Object> params) {
        return this.roleFinder.countByC_N_D_T(companyId, name, description, types, params, true);
    }

    @Override
    public void setUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.addRequiredRoles((long)userId, (long[])roleIds);
        this.userPersistence.setRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserRoles(long userId, long[] roleIds) throws PortalException {
        roleIds = UsersAdminUtil.removeRequiredRoles((long)userId, (long[])roleIds);
        this.userPersistence.removeRoles(userId, roleIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    public Role updateRole(long roleId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String subtype, ServiceContext serviceContext) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        this.validate(roleId, role.getCompanyId(), role.getClassNameId(), name);
        if (PortalUtil.isSystemRole((String)role.getName())) {
            name = role.getName();
            subtype = null;
        }
        role.setModifiedDate(new Date());
        role.setName(name);
        role.setTitleMap(titleMap);
        role.setDescriptionMap(descriptionMap);
        role.setSubtype(subtype);
        role.setExpandoBridgeAttributes(serviceContext);
        this.rolePersistence.update((BaseModel)role);
        return role;
    }

    protected void checkSystemRole(long companyId, String name, Map<Locale, String> descriptionMap, int type) throws PortalException {
        Role role;
        String key;
        block4: {
            String companyIdHexString = StringUtil.toHexString((long)companyId);
            key = companyIdHexString.concat(name);
            role = this._systemRolesMap.get(key);
            try {
                if (role == null) {
                    role = this.rolePersistence.findByC_N(companyId, name);
                }
                if (!descriptionMap.equals(role.getDescriptionMap())) {
                    role.setDescriptionMap(descriptionMap);
                    this.roleLocalService.updateRole(role);
                }
            }
            catch (NoSuchRoleException nsre) {
                User user = this.userLocalService.getDefaultUser(companyId);
                role = this.roleLocalService.addRole(user.getUserId(), null, 0L, name, null, descriptionMap, type, null, null);
                if (!name.equals("User")) break block4;
                this.initPersonalControlPanelPortletsPermissions(role);
            }
        }
        this._systemRolesMap.put(key, role);
    }

    protected String[] getDefaultControlPanelPortlets() {
        return new String[]{"2", "140", "158", "153"};
    }

    protected Map<Team, Role> getTeamRoleMap(long groupId, long[] excludedRoleIds) throws PortalException {
        List teams;
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if ((teams = this.teamPersistence.findByGroupId(group.getGroupId())).isEmpty()) {
            return Collections.emptyMap();
        }
        Set roleIds = SetUtil.fromArray((long[])excludedRoleIds);
        LinkedHashMap<Team, Role> teamRoleMap = new LinkedHashMap<Team, Role>();
        for (Team team : teams) {
            Role role = this.getTeamRole(team.getCompanyId(), team.getTeamId());
            if (roleIds.contains(role.getRoleId())) continue;
            teamRoleMap.put(team, role);
        }
        return teamRoleMap;
    }

    protected void initPersonalControlPanelPortletsPermissions(Role role) throws PortalException {
        for (String portletId : this.getDefaultControlPanelPortlets()) {
            ResourceAction resourceAction;
            int count = this.resourcePermissionPersistence.countByC_N_S_P_R(role.getCompanyId(), portletId, 1, String.valueOf(role.getCompanyId()), role.getRoleId());
            if (count > 0 || (resourceAction = this.resourceActionLocalService.fetchResourceAction(portletId, "ACCESS_IN_CONTROL_PANEL")) == null) continue;
            this.setRolePermissions(role, portletId, new String[]{"ACCESS_IN_CONTROL_PANEL"});
        }
    }

    protected void setRolePermissions(Role role, String name, String[] actionIds) throws PortalException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.resourceBlockLocalService.setCompanyScopePermissions(role.getCompanyId(), name, role.getRoleId(), Arrays.asList(actionIds));
        } else {
            this.resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
        }
    }

    protected void validate(long roleId, long companyId, long classNameId, String name) throws PortalException {
        if (classNameId == this.classNameLocalService.getClassNameId(Role.class)) {
            if (Validator.isNull((String)name) || name.indexOf(44) != -1 || name.indexOf(42) != -1) {
                throw new RoleNameException();
            }
            if (Validator.isNumber((String)name) && !PropsValues.ROLES_NAME_ALLOW_NUMERIC) {
                throw new RoleNameException();
            }
        }
        try {
            Role role = this.roleFinder.findByC_N(companyId, name);
            if (role.getRoleId() != roleId) {
                throw new DuplicateRoleException("{roleId=" + roleId + "}");
            }
        }
        catch (NoSuchRoleException nsre) {
            // empty catch block
        }
    }
}

