/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.Group;
import com.liferay.portal.repository.util.ExternalRepositoryFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryServiceBaseImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;

public class RepositoryServiceImpl
extends RepositoryServiceBaseImpl {
    public com.liferay.portal.model.Repository addRepository(long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        DLPermission.check(this.getPermissionChecker(), groupId, "ADD_REPOSITORY");
        return this.repositoryLocalService.addRepository(this.getUserId(), groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, false, serviceContext);
    }

    public void checkRepository(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId, 0L, 0L, 0L);
    }

    public void deleteRepository(long repositoryId) throws PortalException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "DELETE");
        this.repositoryLocalService.deleteRepository(repository.getRepositoryId());
    }

    public LocalRepository getLocalRepositoryImpl(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getLocalRepositoryImpl(repositoryId);
    }

    public LocalRepository getLocalRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        LocalRepository localRepositoryImpl = this.repositoryLocalService.getLocalRepositoryImpl(folderId, fileEntryId, fileVersionId);
        this.checkRepository(localRepositoryImpl.getRepositoryId());
        return localRepositoryImpl;
    }

    public com.liferay.portal.model.Repository getRepository(long repositoryId) throws PortalException {
        return this.repositoryPersistence.findByPrimaryKey(repositoryId);
    }

    public Repository getRepositoryImpl(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getRepositoryImpl(repositoryId);
    }

    public Repository getRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        Repository repositoryImpl = this.repositoryLocalService.getRepositoryImpl(folderId, fileEntryId, fileVersionId);
        this.checkRepository(repositoryImpl.getRepositoryId(), folderId, fileEntryId, fileVersionId);
        return repositoryImpl;
    }

    public String[] getSupportedConfigurations(long classNameId) {
        try {
            ClassName className = this.classNameLocalService.getClassName(classNameId);
            String repositoryImplClassName = className.getValue();
            BaseRepository baseRepository = ExternalRepositoryFactoryUtil.getInstance(repositoryImplClassName);
            return baseRepository.getSupportedConfigurations();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public String[] getSupportedParameters(long classNameId, String configuration) {
        try {
            ClassName className = this.classNameLocalService.getClassName(classNameId);
            String repositoryImplClassName = className.getValue();
            BaseRepository baseRepository = ExternalRepositoryFactoryUtil.getInstance(repositoryImplClassName);
            String[] supportedConfigurations = baseRepository.getSupportedConfigurations();
            String[][] supportedParameters = baseRepository.getSupportedParameters();
            for (int i = 0; i < supportedConfigurations.length; ++i) {
                if (!supportedConfigurations[i].equals(configuration)) continue;
                return supportedParameters[i];
            }
            throw new RepositoryException("Configuration not found for repository with class name id " + classNameId);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        this.checkRepository(repositoryId);
        return this.repositoryLocalService.getTypeSettingsProperties(repositoryId);
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "UPDATE");
        this.repositoryLocalService.updateRepository(repositoryId, name, description);
    }

    protected void checkModelPermissions(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        DLFileVersion dlFileVersion;
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
            if (dlFolder != null) {
                DLFolderPermission.check(this.getPermissionChecker(), dlFolder, "VIEW");
            }
        } else if (fileEntryId != 0L) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
            if (dlFileEntry != null) {
                DLFileEntryPermission.check(this.getPermissionChecker(), fileEntryId, "VIEW");
            }
        } else if (fileVersionId != 0L && (dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId)) != null) {
            DLFileEntryPermission.check(this.getPermissionChecker(), dlFileVersion.getFileEntryId(), "VIEW");
        }
    }

    protected void checkRepository(long repositoryId, long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            this.checkModelPermissions(folderId, fileEntryId, fileVersionId);
            return;
        }
        try {
            com.liferay.portal.model.Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
            if (repository != null) {
                DLFolderPermission.check(this.getPermissionChecker(), repository.getGroupId(), repository.getDlFolderId(), "VIEW");
                return;
            }
        }
        catch (NoSuchRepositoryException nsre) {
            throw new RepositoryException(nsre.getMessage());
        }
    }
}

