/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.InvalidRepositoryIdException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryFactoryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.RepositoryLocalServiceBaseImpl;
import com.liferay.portal.util.RepositoryUtil;
import com.liferay.portlet.documentlibrary.RepositoryNameException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RepositoryLocalServiceImpl
extends RepositoryLocalServiceBaseImpl
implements CacheRegistryItem {
    private static Log _log = LogFactoryUtil.getLog(RepositoryLocalServiceImpl.class);
    private Map<Long, LocalRepository> _localRepositoriesByRepositoryId = new ConcurrentHashMap<Long, LocalRepository>();
    private Map<Long, Repository> _repositoriesByRepositoryId = new ConcurrentHashMap<Long, Repository>();

    public com.liferay.portal.model.Repository addRepository(long userId, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, boolean hidden, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long repositoryId = this.counterLocalService.increment();
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.create(repositoryId);
        repository.setUuid(serviceContext.getUuid());
        repository.setGroupId(groupId);
        repository.setCompanyId(user.getCompanyId());
        repository.setUserId(user.getUserId());
        repository.setUserName(user.getFullName());
        repository.setCreateDate(now);
        repository.setModifiedDate(now);
        repository.setClassNameId(classNameId);
        repository.setName(name);
        repository.setDescription(description);
        repository.setPortletId(portletId);
        repository.setTypeSettingsProperties(typeSettingsProperties);
        repository.setDlFolderId(this.getDLFolderId(user, groupId, repositoryId, parentFolderId, name, description, hidden, serviceContext));
        this.repositoryPersistence.update((BaseModel)repository);
        try {
            RepositoryFactoryUtil.createRepository((long)repositoryId);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            throw new InvalidRepositoryException((Throwable)e);
        }
        return repository;
    }

    @Deprecated
    public com.liferay.portal.model.Repository addRepository(long userId, long groupId, long classNameId, long parentFolderId, String name, String description, String portletId, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException {
        return this.addRepository(userId, groupId, classNameId, parentFolderId, name, description, portletId, typeSettingsProperties, false, serviceContext);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        CacheRegistryUtil.register((CacheRegistryItem)this);
    }

    public void checkRepository(long repositoryId) {
        Group group = this.groupPersistence.fetchByPrimaryKey(repositoryId);
        if (group != null) {
            return;
        }
        try {
            this.repositoryPersistence.findByPrimaryKey(repositoryId);
        }
        catch (NoSuchRepositoryException nsre) {
            throw new RepositoryException(nsre.getMessage());
        }
    }

    public void deleteRepositories(long groupId) {
        List repositories = this.repositoryPersistence.findByGroupId(groupId);
        for (com.liferay.portal.model.Repository repository : repositories) {
            this.deleteRepository(repository.getRepositoryId());
        }
    }

    @Override
    public com.liferay.portal.model.Repository deleteRepository(long repositoryId) {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.fetchByPrimaryKey(repositoryId);
        if (repository != null) {
            this.repositoryLocalService.deleteRepository(repository);
        }
        this._localRepositoriesByRepositoryId.remove(repositoryId);
        this._repositoriesByRepositoryId.remove(repositoryId);
        return repository;
    }

    @Override
    @SystemEvent(action=1, type=1)
    public com.liferay.portal.model.Repository deleteRepository(com.liferay.portal.model.Repository repository) {
        this.expandoValueLocalService.deleteValues(com.liferay.portal.model.Repository.class.getName(), repository.getRepositoryId());
        DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(repository.getDlFolderId());
        if (dlFolder != null) {
            this.dlFolderLocalService.deleteDLFolder(dlFolder);
        }
        this.repositoryPersistence.remove((BaseModel)repository);
        this.repositoryEntryPersistence.removeByRepositoryId(repository.getRepositoryId());
        return repository;
    }

    public com.liferay.portal.model.Repository fetchRepository(long groupId, String portletId) {
        return this.fetchRepository(groupId, portletId, portletId);
    }

    public com.liferay.portal.model.Repository fetchRepository(long groupId, String name, String portletId) {
        return this.repositoryPersistence.fetchByG_N_P(groupId, name, portletId);
    }

    public List<LocalRepository> getGroupLocalRepositoryImpl(long groupId) throws PortalException {
        List repositories = this.repositoryPersistence.findByGroupId(groupId);
        ArrayList<LocalRepository> localRepositories = new ArrayList<LocalRepository>(repositories.size() + 1);
        for (com.liferay.portal.model.Repository repository : repositories) {
            localRepositories.add(this.getLocalRepositoryImpl(repository.getRepositoryId()));
        }
        localRepositories.add(this.getLocalRepositoryImpl(groupId));
        return localRepositories;
    }

    public LocalRepository getLocalRepositoryImpl(long repositoryId) throws PortalException {
        LocalRepository localRepositoryImpl = this._localRepositoriesByRepositoryId.get(repositoryId);
        if (localRepositoryImpl != null) {
            return localRepositoryImpl;
        }
        localRepositoryImpl = RepositoryFactoryUtil.createLocalRepository((long)repositoryId);
        this.checkRepository(repositoryId);
        this._localRepositoriesByRepositoryId.put(repositoryId, localRepositoryImpl);
        return localRepositoryImpl;
    }

    public LocalRepository getLocalRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        long repositoryId = this.getRepositoryId(folderId, fileEntryId, fileVersionId);
        return this.getLocalRepositoryImpl(repositoryId);
    }

    public String getRegistryName() {
        return RepositoryLocalServiceImpl.class.getName();
    }

    public com.liferay.portal.model.Repository getRepository(long groupId, String portletId) throws PortalException {
        return this.getRepository(groupId, portletId, portletId);
    }

    public com.liferay.portal.model.Repository getRepository(long groupId, String name, String portletId) throws PortalException {
        return this.repositoryPersistence.findByG_N_P(groupId, name, portletId);
    }

    public Repository getRepositoryImpl(long repositoryId) throws PortalException {
        Repository repositoryImpl = this._repositoriesByRepositoryId.get(repositoryId);
        if (repositoryImpl != null) {
            return repositoryImpl;
        }
        repositoryImpl = RepositoryFactoryUtil.createRepository((long)repositoryId);
        this.checkRepository(repositoryId);
        this._repositoriesByRepositoryId.put(repositoryId, repositoryImpl);
        return repositoryImpl;
    }

    public Repository getRepositoryImpl(long folderId, long fileEntryId, long fileVersionId) throws PortalException {
        long repositoryId = this.getRepositoryId(folderId, fileEntryId, fileVersionId);
        return this.getRepositoryImpl(repositoryId);
    }

    public UnicodeProperties getTypeSettingsProperties(long repositoryId) throws PortalException {
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        return repository.getTypeSettingsProperties();
    }

    public void invalidate() {
        this._localRepositoriesByRepositoryId.clear();
        this._repositoriesByRepositoryId.clear();
    }

    public void updateRepository(long repositoryId, String name, String description) throws PortalException {
        Date now = new Date();
        com.liferay.portal.model.Repository repository = this.repositoryPersistence.findByPrimaryKey(repositoryId);
        repository.setModifiedDate(now);
        repository.setName(name);
        repository.setDescription(description);
        this.repositoryPersistence.update((BaseModel)repository);
        DLFolder dlFolder = this.dlFolderPersistence.findByPrimaryKey(repository.getDlFolderId());
        dlFolder.setModifiedDate(now);
        dlFolder.setName(name);
        dlFolder.setDescription(description);
        this.dlFolderPersistence.update((BaseModel)dlFolder);
    }

    protected long getDLFolderId(User user, long groupId, long repositoryId, long parentFolderId, String name, String description, boolean hidden, ServiceContext serviceContext) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new RepositoryNameException();
        }
        DLFolder dlFolder = this.dlFolderLocalService.addFolder(user.getUserId(), groupId, repositoryId, true, parentFolderId, name, description, hidden, serviceContext);
        return dlFolder.getFolderId();
    }

    protected long getExternalRepositoryId(long folderId, long fileEntryId, long fileVersionId) {
        long repositoryEntryId = RepositoryUtil.getRepositoryEntryId(folderId, fileEntryId, fileVersionId);
        RepositoryEntry repositoryEntry = this.repositoryEntryLocalService.fetchRepositoryEntry(repositoryEntryId);
        if (repositoryEntry == null) {
            return 0L;
        }
        return repositoryEntry.getRepositoryId();
    }

    protected long getInternalRepositoryId(long folderId, long fileEntryId, long fileVersionId) {
        long repositoryId = 0L;
        if (folderId != 0L) {
            DLFolder dlFolder = this.dlFolderLocalService.fetchDLFolder(folderId);
            if (dlFolder != null) {
                repositoryId = dlFolder.isMountPoint() ? dlFolder.getGroupId() : dlFolder.getRepositoryId();
            }
        } else if (fileEntryId != 0L) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(fileEntryId);
            if (dlFileEntry != null) {
                repositoryId = dlFileEntry.getRepositoryId();
            }
        } else if (fileVersionId != 0L) {
            DLFileVersion dlFileVersion = this.dlFileVersionLocalService.fetchDLFileVersion(fileVersionId);
            if (dlFileVersion != null) {
                repositoryId = dlFileVersion.getRepositoryId();
            }
        } else {
            throw new InvalidRepositoryIdException("Missing a valid ID for folder, file entry, or file version");
        }
        return repositoryId;
    }

    protected long getRepositoryId(long folderId, long fileEntryId, long fileVersionId) {
        long repositoryId = this.getInternalRepositoryId(folderId, fileEntryId, fileVersionId);
        if (repositoryId != 0L) {
            return repositoryId;
        }
        repositoryId = this.getExternalRepositoryId(folderId, fileEntryId, fileVersionId);
        if (repositoryId == 0L) {
            throw new InvalidRepositoryIdException(String.format("No folder or repository entry found with folder ID %s", folderId));
        }
        return repositoryId;
    }
}

