/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PhoneNumberException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.format.PhoneNumberFormatUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.PhoneLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class PhoneLocalServiceImpl
extends PhoneLocalServiceBaseImpl {
    @Deprecated
    public Phone addPhone(long userId, String className, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException {
        return this.addPhone(userId, className, classPK, number, extension, typeId, primary, new ServiceContext());
    }

    public Phone addPhone(long userId, String className, long classPK, String number, String extension, int typeId, boolean primary, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, number, extension, typeId, primary);
        long phoneId = this.counterLocalService.increment();
        Phone phone = this.phonePersistence.create(phoneId);
        phone.setUuid(serviceContext.getUuid());
        phone.setCompanyId(user.getCompanyId());
        phone.setUserId(user.getUserId());
        phone.setUserName(user.getFullName());
        phone.setCreateDate(serviceContext.getCreateDate(now));
        phone.setModifiedDate(serviceContext.getModifiedDate(now));
        phone.setClassNameId(classNameId);
        phone.setClassPK(classPK);
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone);
        return phone;
    }

    @Override
    public Phone deletePhone(long phoneId) throws PortalException {
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        return this.phoneLocalService.deletePhone(phone);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public Phone deletePhone(Phone phone) {
        this.phonePersistence.remove((BaseModel)phone);
        return phone;
    }

    public void deletePhones(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List phones = this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
        for (Phone phone : phones) {
            this.phoneLocalService.deletePhone(phone);
        }
    }

    public List<Phone> getPhones() {
        return this.phonePersistence.findAll();
    }

    public List<Phone> getPhones(long companyId, String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.phonePersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Phone updatePhone(long phoneId, String number, String extension, int typeId, boolean primary) throws PortalException {
        this.validate(phoneId, 0L, 0L, 0L, number, extension, typeId, primary);
        Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
        phone.setModifiedDate(new Date());
        phone.setNumber(number);
        phone.setExtension(extension);
        phone.setTypeId(typeId);
        phone.setPrimary(primary);
        this.phonePersistence.update((BaseModel)phone);
        return phone;
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, boolean primary) {
        if (primary) {
            List phones = this.phonePersistence.findByC_C_C_P(companyId, classNameId, classPK, primary);
            for (Phone phone : phones) {
                if (phoneId > 0L && phone.getPhoneId() == phoneId) continue;
                phone.setPrimary(false);
                this.phonePersistence.update((BaseModel)phone);
            }
        }
    }

    protected void validate(long phoneId, long companyId, long classNameId, long classPK, String number, String extension, int typeId, boolean primary) throws PortalException {
        if (!PhoneNumberFormatUtil.validate((String)number)) {
            throw new PhoneNumberException();
        }
        if (Validator.isNotNull((String)extension)) {
            for (int i = 0; i < extension.length(); ++i) {
                if (Character.isDigit(extension.charAt(i))) continue;
                throw new PhoneNumberException();
            }
        }
        if (phoneId > 0L) {
            Phone phone = this.phonePersistence.findByPrimaryKey(phoneId);
            companyId = phone.getCompanyId();
            classNameId = phone.getClassNameId();
            classPK = phone.getClassPK();
        }
        if (classNameId == this.classNameLocalService.getClassNameId(Account.class) || classNameId == this.classNameLocalService.getClassNameId(Contact.class) || classNameId == this.classNameLocalService.getClassNameId(Organization.class)) {
            this.listTypeService.validate(typeId, classNameId, ".phone");
        }
        this.validate(phoneId, companyId, classNameId, classPK, primary);
    }
}

