/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.MembershipRequestCommentsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.MembershipRequest;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.MembershipRequestLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.ResourcePermissionUtil;
import com.liferay.portal.util.SubscriptionSender;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;

public class MembershipRequestLocalServiceImpl
extends MembershipRequestLocalServiceBaseImpl {
    public MembershipRequest addMembershipRequest(long userId, long groupId, String comments, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(comments);
        long membershipRequestId = this.counterLocalService.increment();
        MembershipRequest membershipRequest = this.membershipRequestPersistence.create(membershipRequestId);
        membershipRequest.setCompanyId(user.getCompanyId());
        membershipRequest.setUserId(userId);
        membershipRequest.setCreateDate(now);
        membershipRequest.setGroupId(groupId);
        membershipRequest.setComments(comments);
        membershipRequest.setStatusId(0);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest);
        this.notifyGroupAdministrators(membershipRequest, serviceContext);
        return membershipRequest;
    }

    public void deleteMembershipRequests(long groupId) {
        List membershipRequests = this.membershipRequestPersistence.findByGroupId(groupId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    public void deleteMembershipRequests(long groupId, int statusId) {
        List membershipRequests = this.membershipRequestPersistence.findByG_S(groupId, statusId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    public void deleteMembershipRequestsByUserId(long userId) {
        List membershipRequests = this.membershipRequestPersistence.findByUserId(userId);
        for (MembershipRequest membershipRequest : membershipRequests) {
            this.deleteMembershipRequest(membershipRequest);
        }
    }

    public List<MembershipRequest> getMembershipRequests(long userId, long groupId, int statusId) {
        return this.membershipRequestPersistence.findByG_U_S(groupId, userId, statusId);
    }

    public boolean hasMembershipRequest(long userId, long groupId, int statusId) {
        List<MembershipRequest> membershipRequests = this.getMembershipRequests(userId, groupId, statusId);
        return !membershipRequests.isEmpty();
    }

    public List<MembershipRequest> search(long groupId, int status, int start, int end) {
        return this.membershipRequestPersistence.findByG_S(groupId, status, start, end);
    }

    public int searchCount(long groupId, int status) {
        return this.membershipRequestPersistence.countByG_S(groupId, status);
    }

    public void updateStatus(long replierUserId, long membershipRequestId, String replyComments, int statusId, boolean addUserToGroup, ServiceContext serviceContext) throws PortalException {
        this.validate(replyComments);
        MembershipRequest membershipRequest = this.membershipRequestPersistence.findByPrimaryKey(membershipRequestId);
        membershipRequest.setReplyComments(replyComments);
        membershipRequest.setReplyDate(new Date());
        if (replierUserId != 0L) {
            membershipRequest.setReplierUserId(replierUserId);
        } else {
            long defaultUserId = this.userLocalService.getDefaultUserId(membershipRequest.getCompanyId());
            membershipRequest.setReplierUserId(defaultUserId);
        }
        membershipRequest.setStatusId(statusId);
        this.membershipRequestPersistence.update((BaseModel)membershipRequest);
        if (statusId == 1 && addUserToGroup) {
            long[] addUserIds = new long[]{membershipRequest.getUserId()};
            this.userLocalService.addGroupUsers(membershipRequest.getGroupId(), addUserIds);
        }
        if (replierUserId != 0L) {
            this.notify(membershipRequest.getUserId(), membershipRequest, "sites.email.membership.reply.subject", "sites.email.membership.reply.body", serviceContext);
        }
    }

    protected List<Long> getGroupAdministratorUserIds(long groupId) throws PortalException {
        LinkedHashSet<Long> userIds = new LinkedHashSet<Long>();
        Group group = this.groupLocalService.getGroup(groupId);
        String modelResource = Group.class.getName();
        List roles = ListUtil.copy((List)ResourceActionsUtil.getRoles((long)group.getCompanyId(), (Group)group, (String)modelResource, null));
        List teamRoles = this.roleLocalService.getTeamRoles(groupId);
        roles.addAll(teamRoles);
        Resource resource = this.resourceLocalService.getResource(group.getCompanyId(), modelResource, 4, String.valueOf(groupId));
        List actions = ResourceActionsUtil.getResourceActions((String)Group.class.getName());
        for (Role role : roles) {
            String roleName = role.getName();
            if (roleName.equals("Owner") || (roleName.equals("Organization Administrator") || roleName.equals("Organization Owner")) && !group.isOrganization()) continue;
            if (roleName.equals("Site Administrator") || roleName.equals("Site Owner") || roleName.equals("Organization Administrator") || roleName.equals("Organization Owner")) {
                Role curRole = this.roleLocalService.getRole(group.getCompanyId(), roleName);
                List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, curRole.getRoleId());
                for (UserGroupRole userGroupRole : userGroupRoles) {
                    userIds.add(userGroupRole.getUserId());
                }
            }
            ArrayList<String> currentIndividualActions = new ArrayList<String>();
            ArrayList<String> currentGroupActions = new ArrayList<String>();
            ArrayList<String> currentGroupTemplateActions = new ArrayList<String>();
            ArrayList<String> currentCompanyActions = new ArrayList<String>();
            ResourcePermissionUtil.populateResourcePermissionActionIds(groupId, role, resource, actions, currentIndividualActions, currentGroupActions, currentGroupTemplateActions, currentCompanyActions);
            if (!currentIndividualActions.contains("ASSIGN_MEMBERS") && !currentGroupActions.contains("ASSIGN_MEMBERS") && !currentGroupTemplateActions.contains("ASSIGN_MEMBERS") && !currentCompanyActions.contains("ASSIGN_MEMBERS")) continue;
            List currentUserGroupRoles = this.userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(groupId, role.getRoleId());
            for (UserGroupRole userGroupRole : currentUserGroupRoles) {
                userIds.add(userGroupRole.getUserId());
            }
        }
        return new ArrayList<Long>(userIds);
    }

    protected void notify(long userId, MembershipRequest membershipRequest, String subjectProperty, String bodyProperty, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        User requestUser = this.userPersistence.findByPrimaryKey(membershipRequest.getUserId());
        String fromName = PrefsPropsUtil.getStringFromNames(membershipRequest.getCompanyId(), "sites.email.from.name", "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getStringFromNames(membershipRequest.getCompanyId(), "sites.email.from.address", "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), subjectProperty);
        String body = PrefsPropsUtil.getContent(membershipRequest.getCompanyId(), bodyProperty);
        String statusKey = null;
        statusKey = membershipRequest.getStatusId() == 1 ? "approved" : (membershipRequest.getStatusId() == 2 ? "denied" : "pending");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(membershipRequest.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$COMMENTS$]", membershipRequest.getComments(), "[$REPLY_COMMENTS$]", membershipRequest.getReplyComments(), "[$REQUEST_USER_ADDRESS$]", requestUser.getEmailAddress(), "[$REQUEST_USER_NAME$]", requestUser.getFullName(), "[$STATUS$]", LanguageUtil.get((Locale)user.getLocale(), (String)statusKey), "[$USER_ADDRESS$]", user.getEmailAddress(), "[$USER_NAME$]", user.getFullName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("membership_request", new Object[]{membershipRequest.getMembershipRequestId()});
        subscriptionSender.setScopeGroupId(membershipRequest.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(userId);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void notifyGroupAdministrators(MembershipRequest membershipRequest, ServiceContext serviceContext) throws PortalException {
        List<Long> userIds = this.getGroupAdministratorUserIds(membershipRequest.getGroupId());
        for (Long userId : userIds) {
            this.notify(userId, membershipRequest, "sites.email.membership.request.subject", "sites.email.membership.request.body", serviceContext);
        }
    }

    protected void validate(String comments) throws PortalException {
        if (Validator.isNull((String)comments) || Validator.isNumber((String)comments)) {
            throw new MembershipRequestCommentsException();
        }
    }
}

