/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.ExpiredLockException;
import com.liferay.portal.NoSuchLockException;
import com.liferay.portal.kernel.dao.jdbc.aop.MasterDataSource;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockListener;
import com.liferay.portal.kernel.lock.LockListenerRegistryUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.LockLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class LockLocalServiceImpl
extends LockLocalServiceBaseImpl {
    public void clear() {
        this.lockPersistence.removeByLtExpirationDate(new Date());
    }

    public Lock getLock(String className, long key) throws PortalException {
        return this.getLock(className, String.valueOf(key));
    }

    public Lock getLock(String className, String key) throws PortalException {
        Lock lock = this.lockPersistence.findByC_K(className, key);
        if (lock.isExpired()) {
            this.expireLock(lock);
            throw new ExpiredLockException();
        }
        return lock;
    }

    @Override
    public Lock getLockByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        List locks = this.lockPersistence.findByUuid_C(uuid, companyId);
        if (locks.isEmpty()) {
            StringBundler sb = new StringBundler(5);
            sb.append("{uuid=");
            sb.append(uuid);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            throw new NoSuchLockException(sb.toString());
        }
        return (Lock)locks.get(0);
    }

    public boolean hasLock(long userId, String className, long key) {
        return this.hasLock(userId, className, String.valueOf(key));
    }

    public boolean hasLock(long userId, String className, String key) {
        Lock lock = this.fetchLock(className, key);
        return lock != null && lock.getUserId() == userId;
    }

    public boolean isLocked(String className, long key) {
        return this.isLocked(className, String.valueOf(key));
    }

    public boolean isLocked(String className, String key) {
        Lock lock = this.fetchLock(className, key);
        return lock != null;
    }

    public Lock lock(long userId, String className, long key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this.lock(userId, className, String.valueOf(key), owner, inheritable, expirationTime);
    }

    public Lock lock(long userId, String className, String key, String owner, boolean inheritable, long expirationTime) throws PortalException {
        Date now = new Date();
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null) {
            if (lock.isExpired()) {
                this.expireLock(lock);
                lock = null;
            } else if (lock.getUserId() != userId) {
                throw new DuplicateLockException(lock);
            }
        }
        if (lock == null) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            long lockId = this.counterLocalService.increment();
            lock = this.lockPersistence.create(lockId);
            lock.setCompanyId(user.getCompanyId());
            lock.setUserId(user.getUserId());
            lock.setUserName(user.getFullName());
            lock.setClassName(className);
            lock.setKey(key);
            lock.setOwner(owner);
            lock.setInheritable(inheritable);
        }
        lock.setCreateDate(now);
        if (expirationTime == 0L) {
            lock.setExpirationDate(null);
        } else {
            lock.setExpirationDate(new Date(now.getTime() + expirationTime));
        }
        this.lockPersistence.update((BaseModel)lock);
        return lock;
    }

    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Lock lock(String className, String key, String owner) {
        return this.lock(className, key, null, owner);
    }

    @Deprecated
    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Lock lock(String className, String key, String owner, boolean retrieveFromCache) {
        return this.lock(className, key, null, owner);
    }

    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Lock lock(String className, String key, String expectedOwner, String updatedOwner) {
        Lock lock = this.lockFinder.fetchByC_K(className, key, LockMode.UPGRADE);
        if (lock == null) {
            long lockId = this.counterLocalService.increment();
            lock = this.lockPersistence.create(lockId);
            lock.setCreateDate(new Date());
            lock.setClassName(className);
            lock.setKey(key);
            lock.setOwner(updatedOwner);
            this.lockPersistence.update((BaseModel)lock);
            lock.setNew(true);
            this.lockPersistence.flush();
        } else if (Validator.equals((Object)lock.getOwner(), (Object)expectedOwner)) {
            lock.setCreateDate(new Date());
            lock.setClassName(className);
            lock.setKey(key);
            lock.setOwner(updatedOwner);
            this.lockPersistence.update((BaseModel)lock);
            lock.setNew(true);
            this.lockPersistence.flush();
        }
        return lock;
    }

    @Deprecated
    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Lock lock(String className, String key, String expectedOwner, String updatedOwner, boolean retrieveFromCache) {
        return this.lock(className, key, expectedOwner, updatedOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock refresh(String uuid, long companyId, long expirationTime) throws PortalException {
        Date now = new Date();
        List locks = this.lockPersistence.findByUuid_C(uuid, companyId);
        if (locks.isEmpty()) {
            StringBundler sb = new StringBundler(5);
            sb.append("{uuid=");
            sb.append(uuid);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            throw new NoSuchLockException(sb.toString());
        }
        Lock lock = (Lock)locks.get(0);
        LockListener lockListener = LockListenerRegistryUtil.getLockListener((String)lock.getClassName());
        String key = lock.getKey();
        if (lockListener != null) {
            lockListener.onBeforeRefresh(key);
        }
        try {
            lock.setCreateDate(now);
            if (expirationTime == 0L) {
                lock.setExpirationDate(null);
            } else {
                lock.setExpirationDate(new Date(now.getTime() + expirationTime));
            }
            this.lockPersistence.update((BaseModel)lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            if (lockListener != null) {
                lockListener.onAfterRefresh(key);
            }
        }
    }

    public void unlock(String className, long key) {
        this.unlock(className, String.valueOf(key));
    }

    public void unlock(String className, String key) {
        try {
            this.lockPersistence.removeByC_K(className, key);
        }
        catch (NoSuchLockException noSuchLockException) {
            // empty catch block
        }
    }

    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void unlock(String className, String key, String owner) {
        Lock lock = this.lockFinder.fetchByC_K(className, key, LockMode.UPGRADE);
        if (lock == null) {
            return;
        }
        if (Validator.equals((Object)lock.getOwner(), (Object)owner)) {
            this.lockPersistence.remove((BaseModel)lock);
            this.lockPersistence.flush();
        }
    }

    @Deprecated
    @MasterDataSource
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void unlock(String className, String key, String owner, boolean retrieveFromCache) {
        this.unlock(className, key, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireLock(Lock lock) {
        LockListener lockListener = LockListenerRegistryUtil.getLockListener((String)lock.getClassName());
        String key = lock.getKey();
        if (lockListener != null) {
            lockListener.onBeforeExpire(key);
        }
        try {
            this.lockPersistence.remove((BaseModel)lock);
        }
        finally {
            if (lockListener != null) {
                lockListener.onAfterExpire(key);
            }
        }
    }

    protected Lock fetchLock(String className, String key) {
        Lock lock = this.lockPersistence.fetchByC_K(className, key);
        if (lock != null && lock.isExpired()) {
            this.expireLock(lock);
            lock = null;
        }
        return lock;
    }
}

