/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.LARFileNameException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchLayoutException;
import com.liferay.portal.RequiredLayoutException;
import com.liferay.portal.SitemapChangeFrequencyException;
import com.liferay.portal.SitemapIncludeException;
import com.liferay.portal.SitemapPagePriorityException;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.exportimportconfiguration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntry;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.lar.LayoutExporter;
import com.liferay.portal.lar.LayoutImporter;
import com.liferay.portal.lar.PortletExporter;
import com.liferay.portal.lar.PortletImporter;
import com.liferay.portal.lar.backgroundtask.BackgroundTaskContextMapFactory;
import com.liferay.portal.lar.backgroundtask.LayoutExportBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.LayoutImportBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.PortletExportBackgroundTaskExecutor;
import com.liferay.portal.lar.backgroundtask.PortletImportBackgroundTaskExecutor;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutType;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.impl.VirtualLayout;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutLocalServiceBaseImpl;
import com.liferay.portal.service.impl.LayoutLocalServiceHelper;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.LayoutComparator;
import com.liferay.portal.util.comparator.LayoutPriorityComparator;
import com.liferay.portlet.documentlibrary.util.DLValidatorUtil;
import com.liferay.portlet.dynamicdatalists.RecordSetDuplicateRecordSetKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.sites.util.SitesUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class LayoutLocalServiceImpl
extends LayoutLocalServiceBaseImpl {
    @BeanReference(type=LayoutLocalServiceHelper.class)
    protected LayoutLocalServiceHelper layoutLocalServiceHelper;

    public static String getCounterName(long groupId, boolean privateLayout) {
        StringBundler sb = new StringBundler(5);
        sb.append(Layout.class.getName());
        sb.append("#");
        sb.append(groupId);
        sb.append("#");
        sb.append(privateLayout);
        return sb.toString();
    }

    @Deprecated
    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, "", hidden, friendlyURLMap, serviceContext);
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long layoutId = this.getNextLayoutId(groupId, privateLayout);
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, null, -1);
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap);
        Date now = new Date();
        long plid = this.counterLocalService.increment();
        Layout layout = this.layoutPersistence.create(plid);
        layout.setUuid(serviceContext.getUuid());
        layout.setGroupId(groupId);
        layout.setCompanyId(user.getCompanyId());
        layout.setUserId(user.getUserId());
        layout.setUserName(user.getFullName());
        layout.setCreateDate(serviceContext.getCreateDate(now));
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setPrivateLayout(privateLayout);
        layout.setLayoutId(layoutId);
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        layout.setPriority(priority);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        if (!layoutUpdateable) {
            typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        }
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        this.validateTypeSettingsProperties(typeSettingsProperties);
        layout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled", (boolean)PropsValues.LAYOUT_PROTOTYPE_LINK_ENABLED_DEFAULT);
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        if (type.equals("portlet")) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.LAYOUT_DEFAULT_TEMPLATE_ID, false);
        }
        layout.setExpandoBridgeAttributes(serviceContext);
        this.layoutPersistence.update((BaseModel)layout);
        if (Validator.isNotNull((String)layoutPrototypeUuid) && !layoutPrototypeLinkEnabled) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototypeByUuidAndCompanyId(layoutPrototypeUuid, layout.getCompanyId());
            try {
                SitesUtil.applyLayoutPrototype((LayoutPrototype)layoutPrototype, (Layout)layout, (boolean)layoutPrototypeLinkEnabled);
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
        boolean addGroupPermissions = true;
        Group group = this.groupLocalService.getGroup(groupId);
        if (privateLayout && group.isUser()) {
            addGroupPermissions = false;
        }
        boolean addGuestPermissions = false;
        if (!privateLayout || type.equals("control_panel") || group.isLayoutSetPrototype()) {
            addGuestPermissions = true;
        }
        this.resourceLocalService.addResources(user.getCompanyId(), groupId, user.getUserId(), Layout.class.getName(), layout.getPlid(), false, addGroupPermissions, addGuestPermissions);
        this.groupLocalService.updateSite(groupId, true);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(user.getUserId(), user.getCompanyId(), groupId, plid, privateLayout, friendlyURLMap, serviceContext);
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layout.setLayoutSet(layoutSet);
        this.updateAsset(userId, layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        if (PropsValues.LAYOUT_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, user.getFullName(), groupId, Layout.class.getName(), plid, 1);
        }
        return layout;
    }

    public Layout addLayout(long userId, long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(locale, name);
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(locale, description);
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.addLayout(userId, groupId, privateLayout, parentLayoutId, nameMap, titleMap, descriptionMap, new HashMap<Locale, String>(), new HashMap<Locale, String>(), type, "", hidden, friendlyURLMap, serviceContext);
    }

    @SystemEvent(action=1, type=1)
    public void deleteLayout(Layout layout, boolean updateLayoutSet, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntry systemEventHierarchyEntry;
        Layout firstLayout;
        List rootLayouts;
        if (layout.getParentLayoutId() == 0L && (rootLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), 0L, 0, 2)).size() > 1 && (firstLayout = (Layout)rootLayouts.get(0)).getLayoutId() == layout.getLayoutId()) {
            Layout secondLayout = (Layout)rootLayouts.get(1);
            this.layoutLocalServiceHelper.validateFirstLayout(secondLayout);
        }
        List childLayouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        for (Layout childLayout : childLayouts) {
            this.layoutLocalService.deleteLayout(childLayout, updateLayoutSet, serviceContext);
        }
        this.layoutFriendlyURLLocalService.deleteLayoutFriendlyURLs(layout.getPlid());
        this.portletPreferencesLocalService.deletePortletPreferencesByPlid(layout.getPlid());
        this.subscriptionLocalService.deleteSubscriptions(layout.getCompanyId(), Layout.class.getName(), layout.getPlid());
        this.assetEntryLocalService.deleteEntry(Layout.class.getName(), layout.getPlid());
        this.ratingsStatsLocalService.deleteStats(Layout.class.getName(), layout.getPlid());
        long layoutClassNameId = this.classNameLocalService.getClassNameId(Layout.class);
        List mdrRuleGroupInstances = this.mdrRuleGroupInstancePersistence.findByC_C(layoutClassNameId, layout.getPlid());
        for (MDRRuleGroupInstance mdrRuleGroupInstance : mdrRuleGroupInstances) {
            this.mdrRuleGroupInstanceLocalService.deleteMDRRuleGroupInstance(mdrRuleGroupInstance);
        }
        this.mbMessageLocalService.deleteDiscussionMessages(Layout.class.getName(), layout.getPlid());
        this.journalArticleLocalService.deleteLayoutArticleReferences(layout.getGroupId(), layout.getUuid());
        this.journalContentSearchLocalService.deleteLayoutContentSearches(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        this.expandoRowLocalService.deleteRows(layout.getPlid());
        this.imageLocalService.deleteImage(layout.getIconImageId());
        Group scopeGroup = layout.getScopeGroup();
        if (scopeGroup != null) {
            this.groupLocalService.deleteGroup(scopeGroup.getGroupId());
        }
        String primKey = layout.getPlid() + "_LAYOUT_" + "%";
        List resourcePermissions = this.resourcePermissionPersistence.findByC_LikeP(layout.getCompanyId(), primKey);
        for (ResourcePermission resourcePermission : resourcePermissions) {
            this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
        }
        this.resourceLocalService.deleteResource(layout.getCompanyId(), Layout.class.getName(), 4, layout.getPlid());
        this.layoutPersistence.remove((BaseModel)layout);
        if (updateLayoutSet) {
            this.layoutSetLocalService.updatePageCount(layout.getGroupId(), layout.isPrivateLayout());
        }
        if ((systemEventHierarchyEntry = SystemEventHierarchyEntryThreadLocal.peek()) != null && systemEventHierarchyEntry.hasTypedModel(Layout.class.getName(), layout.getPlid())) {
            systemEventHierarchyEntry.setExtraDataValue("privateLayout", StringUtil.valueOf((Object)layout.isPrivateLayout()));
        }
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        this.layoutLocalService.deleteLayout(layout, true, serviceContext);
    }

    public void deleteLayouts(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, 0L, -1, -1, (OrderByComparator)new LayoutPriorityComparator(false));
        for (Layout layout : layouts) {
            try {
                this.layoutLocalService.deleteLayout(layout, false, serviceContext);
            }
            catch (NoSuchLayoutException nsle) {}
        }
        if (GetterUtil.getBoolean((Object)serviceContext.getAttribute("updatePageCount"), (boolean)true)) {
            this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
        }
        this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        File file = this.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        return this.exportLayouts(groupId, privateLayout, null, parameterMap, startDate, endDate);
    }

    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        try {
            LayoutExporter layoutExporter = LayoutExporter.getInstance();
            return layoutExporter.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public long exportLayoutsAsFileInBackground(long userId, ExportImportConfiguration exportImportConfiguration) throws PortalException {
        if (!DLValidatorUtil.isValidName((String)exportImportConfiguration.getName())) {
            throw new LARFileNameException(exportImportConfiguration.getName());
        }
        HashMap<String, Object> taskContextMap = new HashMap<String, Object>();
        taskContextMap.put("cmd", "export");
        taskContextMap.put("exportImportConfigurationId", exportImportConfiguration.getExportImportConfigurationId());
        BackgroundTask backgroundTask = this.backgroundTaskLocalService.addBackgroundTask(userId, exportImportConfiguration.getGroupId(), exportImportConfiguration.getName(), null, LayoutExportBackgroundTaskExecutor.class, taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportLayoutsAsFileInBackground(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        return this.exportLayoutsAsFileInBackground(userId, exportImportConfiguration);
    }

    public long exportLayoutsAsFileInBackground(long userId, String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((long)userId, (long)groupId, (boolean)privateLayout, (long[])layoutIds, parameterMap, (Date)startDate, (Date)endDate, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ServiceContext serviceContext = new ServiceContext();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, taskName, "", 0, settingsMap, 2, serviceContext);
        return this.exportLayoutsAsFileInBackground(userId, exportImportConfiguration);
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long userId, String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        return this.exportLayoutsAsFileInBackground(userId, taskName, groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        File file = this.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public byte[] exportPortletInfo(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        File file = this.exportPortletInfoAsFile(companyId, portletId, parameterMap, startDate, endDate);
        try {
            byte[] byArray = FileUtil.getBytes((File)file);
            return byArray;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            file.delete();
        }
    }

    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        try {
            PortletExporter portletExporter = PortletExporter.getInstance();
            return portletExporter.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public File exportPortletInfoAsFile(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        Group controlPanelGroup = this.groupPersistence.findByC_F(companyId, "/control_panel");
        Layout controlPanelLayout = this.layoutPersistence.findByG_P_T_First(controlPanelGroup.getGroupId(), true, "control_panel", null);
        return this.exportPortletInfoAsFile(controlPanelLayout.getPlid(), companyGroup.getGroupId(), portletId, parameterMap, startDate, endDate);
    }

    public long exportPortletInfoAsFileInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        Map<String, Serializable> taskContextMap = BackgroundTaskContextMapFactory.buildTaskContextMap(userId, plid, groupId, portletId, parameterMap, "export", startDate, endDate, fileName);
        BackgroundTask backgroundTask = this.backgroundTaskLocalService.addBackgroundTask(userId, groupId, taskName, null, PortletExportBackgroundTaskExecutor.class, taskContextMap, new ServiceContext());
        return backgroundTask.getBackgroundTaskId();
    }

    public long exportPortletInfoAsFileInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        Group controlPanelGroup = this.groupPersistence.findByC_F(user.getCompanyId(), "/control_panel");
        Layout controlPanelLayout = this.layoutPersistence.findByG_P_T_First(controlPanelGroup.getGroupId(), true, "control_panel", null);
        return this.exportPortletInfoAsFileInBackground(userId, taskName, controlPanelLayout.getPlid(), companyGroup.getGroupId(), portletId, parameterMap, startDate, endDate, fileName);
    }

    public Layout fetchFirstLayout(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.fetchByG_P_P_First(groupId, privateLayout, parentLayoutId, (OrderByComparator)new LayoutPriorityComparator());
    }

    public Layout fetchLayout(long groupId, boolean privateLayout, long layoutId) {
        return this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout fetchLayoutByFriendlyURL(long groupId, boolean privateLayout, String friendlyURL) {
        return this.layoutPersistence.fetchByG_P_F(groupId, privateLayout, friendlyURL);
    }

    public long getDefaultPlid(long groupId) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByGroupId(groupId, 0, 1)).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout) {
        List layouts;
        if (groupId > 0L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1)).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            return layout.getPlid();
        }
        return 0L;
    }

    public long getDefaultPlid(long groupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId > 0L) {
            List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
            for (Layout layout : layouts) {
                LayoutTypePortlet layoutTypePortlet;
                if (!layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
                return layout.getPlid();
            }
        }
        return 0L;
    }

    public Layout getFriendlyURLLayout(long groupId, boolean privateLayout, String friendlyURL) throws PortalException {
        if (Validator.isNull((String)friendlyURL)) {
            StringBundler sb = new StringBundler(5);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(friendlyURL);
        Layout layout = null;
        List layoutFriendlyURLs = this.layoutFriendlyURLPersistence.findByG_P_F(groupId, privateLayout, friendlyURL, 0, 1);
        if (!layoutFriendlyURLs.isEmpty()) {
            LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
            layout = this.layoutPersistence.findByPrimaryKey(layoutFriendlyURL.getPlid());
        }
        if (layout == null && friendlyURL.startsWith("/") && Validator.isNumber((String)friendlyURL.substring(1))) {
            long layoutId = GetterUtil.getLong((String)friendlyURL.substring(1));
            layout = this.layoutPersistence.fetchByG_P_L(groupId, privateLayout, layoutId);
        }
        if (layout == null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", privateLayout=");
            sb.append(privateLayout);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchLayoutException(sb.toString());
        }
        return layout;
    }

    public Layout getLayout(long groupId, boolean privateLayout, long layoutId) throws PortalException {
        return this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
    }

    public Layout getLayoutByIconImageId(long iconImageId) throws PortalException {
        return this.layoutPersistence.findByIconImageId(iconImageId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.findByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) {
        return this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId, start, end);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long[] layoutIds) throws PortalException {
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        for (long layoutId : layoutIds) {
            Layout layout = this.getLayout(groupId, privateLayout, layoutId);
            layouts.add(layout);
        }
        return layouts;
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, String type) {
        return this.layoutPersistence.findByG_P_T(groupId, privateLayout, type);
    }

    public LayoutReference[] getLayouts(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        List layoutReferences = this.layoutFinder.findByC_P_P(companyId, portletId, preferencesKey, preferencesValue);
        return layoutReferences.toArray(new LayoutReference[layoutReferences.size()]);
    }

    public List<Layout> getLayoutsByLayoutPrototypeUuid(String layoutPrototypeUuid) {
        return this.layoutPersistence.findByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsByLayoutPrototypeUuidCount(String layoutPrototypeUuid) {
        return this.layoutPersistence.countByLayoutPrototypeUuid(layoutPrototypeUuid);
    }

    public int getLayoutsCount(Group group, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(group, privateLayout, true);
    }

    public int getLayoutsCount(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        int count = layoutSet.getPageCount();
        if (!group.isUser() || !includeUserGroups) {
            return count;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                count += layoutSet.getPageCount();
            }
        }
        return count;
    }

    public int getLayoutsCount(Group group, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P(group.getGroupId(), privateLayout, parentLayoutId);
    }

    public int getLayoutsCount(User user, boolean privateLayout) throws PortalException {
        return this.getLayoutsCount(user, privateLayout, true);
    }

    public int getLayoutsCount(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.getLayoutsCount(group, privateLayout, includeUserGroups);
    }

    public long getNextLayoutId(long groupId, boolean privateLayout) {
        List layouts;
        long nextLayoutId = this.counterLocalService.increment(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout));
        if (nextLayoutId == 1L && !(layouts = this.layoutPersistence.findByG_P(groupId, privateLayout, 0, 1, (OrderByComparator)new LayoutComparator())).isEmpty()) {
            Layout layout = (Layout)layouts.get(0);
            nextLayoutId = layout.getLayoutId() + 1L;
            this.counterLocalService.reset(LayoutLocalServiceImpl.getCounterName(groupId, privateLayout), nextLayoutId);
        }
        return nextLayoutId;
    }

    public List<Layout> getNoPermissionLayouts(long roleId) {
        return this.layoutFinder.findByNoPermissions(roleId);
    }

    public List<Layout> getNullFriendlyURLLayouts() {
        return this.layoutFinder.findByNullFriendlyURL();
    }

    public Layout getParentLayout(Layout layout) throws PortalException {
        Object parentLayout = null;
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            Layout sourceLayout = virtualLayout.getSourceLayout();
            parentLayout = this.getLayout(sourceLayout.getGroupId(), sourceLayout.isPrivateLayout(), sourceLayout.getParentLayoutId());
            parentLayout = new VirtualLayout((Layout)parentLayout, layout.getGroup());
        } else {
            parentLayout = this.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        }
        return parentLayout;
    }

    public List<Layout> getScopeGroupLayouts(long groupId, boolean privateLayout) {
        return this.layoutFinder.findByScopeGroup(groupId, privateLayout);
    }

    public boolean hasLayouts(Group group, boolean privateLayout) throws PortalException {
        return this.hasLayouts(group, privateLayout, true);
    }

    public boolean hasLayouts(Group group, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(group.getGroupId(), privateLayout);
        if (layoutSet.getPageCount() > 0) {
            return true;
        }
        if (!group.isUser() || !includeUserGroups) {
            return false;
        }
        long[] userGroupIds = this.userPersistence.getUserGroupPrimaryKeys(group.getClassPK());
        if (userGroupIds.length != 0) {
            long userGroupClassNameId = this.classNameLocalService.getClassNameId(UserGroup.class);
            for (long userGroupId : userGroupIds) {
                Group userGroupGroup = this.groupPersistence.findByC_C_C(group.getCompanyId(), userGroupClassNameId, userGroupId);
                layoutSet = this.layoutSetPersistence.findByG_P(userGroupGroup.getGroupId(), privateLayout);
                if (layoutSet.getPageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLayouts(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.countByG_P_P(groupId, privateLayout, parentLayoutId) > 0;
    }

    public boolean hasLayouts(User user, boolean privateLayout) throws PortalException {
        return this.hasLayouts(user, privateLayout, true);
    }

    public boolean hasLayouts(User user, boolean privateLayout, boolean includeUserGroups) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(User.class);
        Group group = this.groupPersistence.findByC_C_C(user.getCompanyId(), classNameId, user.getUserId());
        return this.hasLayouts(group, privateLayout, includeUserGroups);
    }

    public boolean hasLayoutSetPrototypeLayout(long layoutSetPrototypeId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototype(layoutSetPrototypeId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public boolean hasLayoutSetPrototypeLayout(String layoutSetPrototypeUuid, long companyId, String layoutUuid) throws PortalException {
        LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypeLocalService.getLayoutSetPrototypeByUuidAndCompanyId(layoutSetPrototypeUuid, companyId);
        return this.layoutLocalServiceHelper.hasLayoutSetPrototypeLayout(layoutSetPrototype, layoutUuid);
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException {
        this.importLayouts(userId, groupId, privateLayout, parameterMap, (InputStream)new UnsyncByteArrayInputStream(bytes));
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        try {
            LayoutImporter layoutImporter = LayoutImporter.getInstance();
            layoutImporter.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importLayouts(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importLayouts(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importLayoutsInBackground(long userId, String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        Map<String, Serializable> taskContextMap = BackgroundTaskContextMapFactory.buildTaskContextMap(userId, groupId, privateLayout, null, parameterMap, "import", null, null, file.getName());
        BackgroundTask backgroundTask = this.backgroundTaskLocalService.addBackgroundTask(userId, groupId, taskName, null, LayoutImportBackgroundTaskExecutor.class, taskContextMap, new ServiceContext());
        this.backgroundTaskLocalService.addBackgroundTaskAttachment(userId, backgroundTask.getBackgroundTaskId(), file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importLayoutsInBackground(long userId, String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            long l = this.importLayoutsInBackground(userId, taskName, groupId, privateLayout, parameterMap, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        try {
            PortletImporter portletImporter = PortletImporter.getInstance();
            portletImporter.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (PortalException pe) {
            for (Throwable cause = pe.getCause(); cause != null; cause = cause.getCause()) {
                if (cause instanceof LocaleException || cause instanceof RecordSetDuplicateRecordSetKeyException || cause instanceof StructureDuplicateStructureKeyException) {
                    throw (PortalException)cause;
                }
                if (!(cause instanceof PortletDataException)) break;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void importPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void importPortletInfo(long userId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        Group controlPanelGroup = this.groupPersistence.findByC_F(user.getCompanyId(), "/control_panel");
        Layout controlPanelLayout = this.layoutPersistence.findByG_P_T_First(controlPanelGroup.getGroupId(), true, "control_panel", null);
        this.importPortletInfo(userId, controlPanelLayout.getPlid(), companyGroup.getGroupId(), portletId, parameterMap, file);
    }

    public void importPortletInfo(long userId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            this.importPortletInfo(userId, portletId, parameterMap, file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        Map<String, Serializable> taskContextMap = BackgroundTaskContextMapFactory.buildTaskContextMap(userId, plid, groupId, portletId, parameterMap, "import", null, null, file.getName());
        BackgroundTask backgroundTask = this.backgroundTaskLocalService.addBackgroundTask(userId, groupId, taskName, null, PortletImportBackgroundTaskExecutor.class, taskContextMap, new ServiceContext());
        this.backgroundTaskLocalService.addBackgroundTaskAttachment(userId, backgroundTask.getBackgroundTaskId(), file.getName(), file);
        return backgroundTask.getBackgroundTaskId();
    }

    public long importPortletInfoInBackground(long userId, String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            long l = this.importPortletInfoInBackground(userId, taskName, plid, groupId, portletId, parameterMap, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public long importPortletInfoInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        Group controlPanelGroup = this.groupPersistence.findByC_F(user.getCompanyId(), "/control_panel");
        Layout controlPanelLayout = this.layoutPersistence.findByG_P_T_First(controlPanelGroup.getGroupId(), true, "control_panel", null);
        return this.importPortletInfoInBackground(userId, taskName, controlPanelLayout.getPlid(), companyGroup.getGroupId(), portletId, parameterMap, file);
    }

    public long importPortletInfoInBackground(long userId, String taskName, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)is);
            long l = this.importPortletInfoInBackground(userId, taskName, portletId, parameterMap, file);
            return l;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        if (layoutIds == null) {
            return;
        }
        if (parentLayoutId == 0L) {
            if (layoutIds.length < 1) {
                throw new RequiredLayoutException(1);
            }
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutIds[0]);
            LayoutType layoutType = layout.getLayoutType();
            if (!layoutType.isFirstPageable()) {
                throw new RequiredLayoutException(3);
            }
        }
        LinkedHashSet<Long> layoutIdsSet = new LinkedHashSet<Long>();
        for (long layoutId : layoutIds) {
            layoutIdsSet.add(layoutId);
        }
        HashSet<Long> newLayoutIdsSet = new HashSet<Long>();
        List layouts = this.layoutPersistence.findByG_P_P(groupId, privateLayout, parentLayoutId);
        for (Layout layout : layouts) {
            if (!layoutIdsSet.contains(layout.getLayoutId())) {
                this.deleteLayout(layout, true, serviceContext);
                continue;
            }
            newLayoutIdsSet.add(layout.getLayoutId());
        }
        int priority = 0;
        Iterator i$ = layoutIdsSet.iterator();
        while (i$.hasNext()) {
            long layoutId = (Long)i$.next();
            Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
            layout.setPriority(priority++);
            this.layoutPersistence.update((BaseModel)layout);
        }
        this.layoutSetLocalService.updatePageCount(groupId, privateLayout);
    }

    public void updateAsset(long userId, Layout layout, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        this.assetEntryLocalService.updateEntry(userId, layout.getGroupId(), layout.getCreateDate(), layout.getModifiedDate(), Layout.class.getName(), layout.getPlid(), layout.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, "text/html", layout.getName(LocaleUtil.getDefault()), null, null, null, null, 0, 0, null, false);
    }

    public Layout updateFriendlyURL(long userId, long plid, String friendlyURL, String languageId) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        friendlyURL = this.layoutLocalServiceHelper.getFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), "", friendlyURL);
        this.layoutLocalServiceHelper.validateFriendlyURL(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), friendlyURL);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURL(userId, layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURL, languageId, new ServiceContext());
        layout.setModifiedDate(now);
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        if (languageId.equals(defaultLanguageId)) {
            layout.setFriendlyURL(friendlyURL);
        }
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    @Deprecated
    public Layout updateFriendlyURL(long plid, String friendlyURL, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateFriendlyURL(layout.getUserId(), plid, friendlyURL, languageId);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        Layout layout = this.layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        PortalUtil.updateImageId((BaseModel)layout, (boolean)true, (byte[])bytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        String name = nameMap.get(LocaleUtil.getSiteDefault());
        friendlyURLMap = this.layoutLocalServiceHelper.getFriendlyURLMap(groupId, privateLayout, layoutId, name, friendlyURLMap);
        String friendlyURL = friendlyURLMap.get(LocaleUtil.getSiteDefault());
        this.layoutLocalServiceHelper.validate(groupId, privateLayout, layoutId, parentLayoutId, name, type, hidden, friendlyURLMap);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(serviceContext.getModifiedDate(now));
        layout.setParentLayoutId(parentLayoutId);
        layout.setNameMap(nameMap);
        layout.setTitleMap(titleMap);
        layout.setDescriptionMap(descriptionMap);
        layout.setKeywordsMap(keywordsMap);
        layout.setRobotsMap(robotsMap);
        layout.setType(type);
        layout.setHidden(hidden);
        layout.setFriendlyURL(friendlyURL);
        PortalUtil.updateImageId((BaseModel)layout, (boolean)iconImage, (byte[])iconBytes, (String)"iconImageId", (long)0L, (int)0, (int)0);
        boolean layoutUpdateable = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutUpdateable", (boolean)true);
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        typeSettingsProperties.put("layoutUpdateable", String.valueOf(layoutUpdateable));
        if (privateLayout) {
            typeSettingsProperties.put("privateLayout", String.valueOf(privateLayout));
        }
        layout.setTypeSettingsProperties(typeSettingsProperties);
        String layoutPrototypeUuid = ParamUtil.getString((ServiceContext)serviceContext, (String)"layoutPrototypeUuid");
        boolean layoutPrototypeLinkEnabled = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"layoutPrototypeLinkEnabled");
        if (Validator.isNotNull((String)layoutPrototypeUuid)) {
            layout.setLayoutPrototypeUuid(layoutPrototypeUuid);
            layout.setLayoutPrototypeLinkEnabled(layoutPrototypeLinkEnabled);
        }
        layout.setExpandoBridgeAttributes(serviceContext);
        this.layoutPersistence.update((BaseModel)layout);
        this.layoutFriendlyURLLocalService.updateLayoutFriendlyURLs(serviceContext.getUserId(), layout.getCompanyId(), layout.getGroupId(), layout.getPlid(), layout.isPrivateLayout(), friendlyURLMap, serviceContext);
        this.updateAsset(serviceContext.getUserId(), layout, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return layout;
    }

    @Deprecated
    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, String friendlyURL, Boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>();
        friendlyURLMap.put(LocaleUtil.getSiteDefault(), friendlyURL);
        return this.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, (boolean)iconImage, iconBytes, serviceContext);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        Date now = new Date();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.fastLoad(typeSettings);
        this.validateTypeSettingsProperties(typeSettingsProperties);
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(now);
        layout.setTypeSettings(typeSettingsProperties.toString());
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css, boolean wapTheme) throws PortalException {
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        layout.setModifiedDate(now);
        if (wapTheme) {
            layout.setWapThemeId(themeId);
            layout.setWapColorSchemeId(colorSchemeId);
        } else {
            layout.setThemeId(themeId);
            layout.setColorSchemeId(colorSchemeId);
            layout.setCss(css);
        }
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateName(Layout layout, String name, String languageId) throws PortalException {
        Date now = new Date();
        this.layoutLocalServiceHelper.validateName(name, languageId);
        layout.setModifiedDate(now);
        layout.setName(name, LocaleUtil.fromLanguageId((String)languageId));
        this.layoutPersistence.update((BaseModel)layout);
        Group group = layout.getGroup();
        if (group.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            layoutPrototype.setModifiedDate(now);
            layoutPrototype.setName(name, LocaleUtil.fromLanguageId((String)languageId));
            this.layoutPrototypePersistence.update((BaseModel)layoutPrototype);
        }
        return layout;
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updateName(layout, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(groupId, privateLayout, parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(groupId, privateLayout, parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        Layout parentLayout;
        Date now = new Date();
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        long parentLayoutId = 0L;
        if (parentPlid > 0L && (parentLayout = this.layoutPersistence.fetchByPrimaryKey(parentPlid)) != null) {
            parentLayoutId = parentLayout.getLayoutId();
        }
        parentLayoutId = this.layoutLocalServiceHelper.getParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId);
        this.layoutLocalServiceHelper.validateParentLayoutId(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), parentLayoutId);
        if (parentLayoutId != layout.getParentLayoutId()) {
            int priority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), parentLayoutId, layout.getSourcePrototypeLayoutUuid(), -1);
            layout.setPriority(priority);
        }
        layout.setModifiedDate(now);
        layout.setParentLayoutId(parentLayoutId);
        this.layoutPersistence.update((BaseModel)layout);
        return layout;
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        Layout layout = this.updateParentLayoutId(plid, parentPlid);
        return this.updatePriority(layout, priority);
    }

    public void updatePriorities(long groupId, boolean privateLayout) throws PortalException {
        List layouts = this.layoutPersistence.findByG_P(groupId, privateLayout);
        for (Layout layout : layouts) {
            int nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), layout.getPriority());
            layout.setPriority(nextPriority);
            this.layoutPersistence.update((BaseModel)layout);
        }
    }

    public Layout updatePriority(Layout layout, int priority) throws PortalException {
        int nextPriority;
        if (layout.getPriority() == priority) {
            return layout;
        }
        int oldPriority = layout.getPriority();
        if (oldPriority == (nextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), layout.getSourcePrototypeLayoutUuid(), priority))) {
            return layout;
        }
        layout.setModifiedDate(new Date());
        layout.setPriority(nextPriority);
        this.layoutPersistence.update((BaseModel)layout);
        List layouts = this.layoutPersistence.findByG_P_P(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
        boolean lessThan = false;
        if (oldPriority < nextPriority) {
            lessThan = true;
        }
        layouts = ListUtil.sort((List)layouts, (Comparator)new LayoutPriorityComparator(layout, lessThan));
        Layout firstLayout = (Layout)layouts.get(0);
        this.layoutLocalServiceHelper.validateFirstLayout(firstLayout);
        int newPriority = 0;
        for (Layout curLayout : layouts) {
            int curNextPriority = this.layoutLocalServiceHelper.getNextPriority(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId(), curLayout.getSourcePrototypeLayoutUuid(), newPriority++);
            if (curLayout.getPriority() == curNextPriority) continue;
            curLayout.setModifiedDate(layout.getModifiedDate());
            curLayout.setPriority(curNextPriority);
            this.layoutPersistence.update((BaseModel)curLayout);
            if (!curLayout.equals(layout)) continue;
            layout = curLayout;
        }
        return layout;
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByG_P_L(groupId, privateLayout, layoutId);
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        Layout layout = this.getLayout(groupId, privateLayout, layoutId);
        int priority = layout.getPriority();
        Layout nextLayout = null;
        if (nextLayoutId > -1L) {
            nextLayout = this.getLayout(groupId, privateLayout, nextLayoutId);
        }
        Layout previousLayout = null;
        if (previousLayoutId > -1L) {
            previousLayout = this.getLayout(groupId, privateLayout, previousLayoutId);
        }
        if (nextLayout != null && priority > nextLayout.getPriority()) {
            priority = nextLayout.getPriority();
        } else if (previousLayout != null && priority < previousLayout.getPriority()) {
            priority = previousLayout.getPriority();
        }
        return this.updatePriority(layout, priority);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        Layout layout = this.layoutPersistence.findByPrimaryKey(plid);
        return this.updatePriority(layout, priority);
    }

    @Deprecated
    public void updateScopedPortletNames(long groupId, boolean privateLayout, long layoutId, Map<Locale, String> nameMap, List<Locale> nameMapModifiedLocales) throws PortalException {
    }

    @Deprecated
    public void updateScopedPortletNames(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
    }

    public MissingReferences validateImportLayoutsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        try {
            LayoutImporter layoutImporter = LayoutImporter.getInstance();
            return layoutImporter.validateFile(userId, groupId, privateLayout, parameterMap, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public MissingReferences validateImportLayoutsFile(long userId, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportLayoutsFile(userId, groupId, privateLayout, parameterMap, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    public MissingReferences validateImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        try {
            PortletImporter portletImporter = PortletImporter.getInstance();
            return portletImporter.validateFile(userId, plid, groupId, portletId, parameterMap, file);
        }
        catch (PortalException pe) {
            Throwable cause = pe.getCause();
            if (cause instanceof LocaleException) {
                throw (PortalException)cause;
            }
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public MissingReferences validateImportPortletInfo(long userId, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        File file = null;
        try {
            file = FileUtil.createTempFile((String)"lar");
            FileUtil.write((File)file, (InputStream)inputStream);
            MissingReferences missingReferences = this.validateImportPortletInfo(userId, plid, groupId, portletId, parameterMap, file);
            return missingReferences;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        finally {
            FileUtil.delete((File)file);
        }
    }

    protected void validateTypeSettingsProperties(UnicodeProperties typeSettingsProperties) throws PortalException {
        String sitemapChangeFrequency = typeSettingsProperties.getProperty("sitemap-changefreq");
        if (!(!Validator.isNotNull((String)sitemapChangeFrequency) || sitemapChangeFrequency.equals("always") || sitemapChangeFrequency.equals("hourly") || sitemapChangeFrequency.equals("daily") || sitemapChangeFrequency.equals("weekly") || sitemapChangeFrequency.equals("monthly") || sitemapChangeFrequency.equals("yearly") || sitemapChangeFrequency.equals("never"))) {
            throw new SitemapChangeFrequencyException();
        }
        String sitemapInclude = typeSettingsProperties.getProperty("sitemap-include");
        if (Validator.isNotNull((String)sitemapInclude) && !sitemapInclude.equals("0") && !sitemapInclude.equals("1")) {
            throw new SitemapIncludeException();
        }
        String sitemapPriority = typeSettingsProperties.getProperty("sitemap-priority");
        if (Validator.isNotNull((String)sitemapPriority)) {
            try {
                double priority = Double.parseDouble(sitemapPriority);
                if (priority < 0.0 || priority > 1.0) {
                    throw new SitemapPagePriorityException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new SitemapPagePriorityException();
            }
        }
    }
}

