/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.ExportImportConfigurationLocalServiceBaseImpl;
import com.liferay.portlet.trash.model.TrashEntry;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ExportImportConfigurationLocalServiceImpl
extends ExportImportConfigurationLocalServiceBaseImpl {
    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, int status, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long exportImportConfigurationId = this.counterLocalService.increment();
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.create(exportImportConfigurationId);
        exportImportConfiguration.setGroupId(groupId);
        exportImportConfiguration.setCompanyId(user.getCompanyId());
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setCreateDate(serviceContext.getCreateDate(now));
        exportImportConfiguration.setModifiedDate(serviceContext.getModifiedDate(now));
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        exportImportConfiguration.setType(type);
        if (settingsMap != null) {
            String settings = JSONFactoryUtil.serialize(settingsMap);
            exportImportConfiguration.setSettings(settings);
        }
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(now);
        return (ExportImportConfiguration)this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
    }

    public ExportImportConfiguration addExportImportConfiguration(long userId, long groupId, String name, String description, int type, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        return this.exportImportConfigurationLocalService.addExportImportConfiguration(userId, groupId, name, description, type, settingsMap, 0, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public ExportImportConfiguration deleteExportImportConfiguration(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        this.exportImportConfigurationPersistence.remove((BaseModel)exportImportConfiguration);
        this.trashEntryLocalService.deleteEntry(ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId());
        return exportImportConfiguration;
    }

    @Override
    public ExportImportConfiguration deleteExportImportConfiguration(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        return this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
    }

    public void deleteExportImportConfigurations(long groupId) throws PortalException {
        List exportImportConfigurations = this.exportImportConfigurationPersistence.findByGroupId(groupId);
        for (ExportImportConfiguration exportImportConfiguration : exportImportConfigurations) {
            this.exportImportConfigurationLocalService.deleteExportImportConfiguration(exportImportConfiguration);
        }
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0);
    }

    public List<ExportImportConfiguration> getExportImportConfigurations(long groupId, int type, int start, int end, OrderByComparator<ExportImportConfiguration> orderByComparator) {
        return this.exportImportConfigurationPersistence.findByG_T_S(groupId, type, 0, start, end, orderByComparator);
    }

    public int getExportImportConfigurationsCount(long groupId) {
        return this.exportImportConfigurationPersistence.countByG_S(groupId, 0);
    }

    public int getExportImportConfigurationsCount(long groupId, int type) {
        return this.exportImportConfigurationPersistence.countByG_T_S(groupId, type, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration moveExportImportConfigurationToTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        int oldStatus = exportImportConfiguration.getStatus();
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), 8);
        this.trashEntryLocalService.addTrashEntry(userId, exportImportConfiguration.getGroupId(), ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId(), null, null, oldStatus, null, null);
        return exportImportConfiguration;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration restoreExportImportConfigurationFromTrash(long userId, long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(ExportImportConfiguration.class.getName(), exportImportConfigurationId);
        exportImportConfiguration = this.updateStatus(userId, exportImportConfiguration.getExportImportConfigurationId(), trashEntry.getStatus());
        this.trashEntryLocalService.deleteEntry(ExportImportConfiguration.class.getName(), exportImportConfiguration.getExportImportConfigurationId());
        return exportImportConfiguration;
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateExportImportConfiguration(long userId, long exportImportConfigurationId, String name, String description, Map<String, Serializable> settingsMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setUserId(userId);
        exportImportConfiguration.setUserName(user.getFullName());
        exportImportConfiguration.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        exportImportConfiguration.setName(name);
        exportImportConfiguration.setDescription(description);
        if (settingsMap != null) {
            String settings = JSONFactoryUtil.serialize(settingsMap);
            exportImportConfiguration.setSettings(settings);
        }
        return (ExportImportConfiguration)this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ExportImportConfiguration updateStatus(long userId, long exportImportConfigurationId, int status) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationPersistence.findByPrimaryKey(exportImportConfigurationId);
        exportImportConfiguration.setStatus(status);
        exportImportConfiguration.setStatusByUserId(userId);
        exportImportConfiguration.setStatusByUserName(user.getScreenName());
        exportImportConfiguration.setStatusDate(new Date());
        this.exportImportConfigurationPersistence.update((BaseModel)exportImportConfiguration);
        return exportImportConfiguration;
    }
}

