/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatus;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskStatusRegistry;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Lock;
import com.liferay.portal.model.User;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.BackgroundTaskLocalServiceBaseImpl;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class BackgroundTaskLocalServiceImpl
extends BackgroundTaskLocalServiceBaseImpl {
    @BeanReference(type=BackgroundTaskStatusRegistry.class)
    private BackgroundTaskStatusRegistry _backgroundTaskStatusRegistry;

    public BackgroundTask addBackgroundTask(long userId, long groupId, String name, String[] servletContextNames, Class<?> taskExecutorClass, Map<String, Serializable> taskContextMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        final long backgroundTaskId = this.counterLocalService.increment();
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.create(backgroundTaskId);
        backgroundTask.setCompanyId(user.getCompanyId());
        backgroundTask.setCreateDate(serviceContext.getCreateDate(now));
        backgroundTask.setGroupId(groupId);
        backgroundTask.setModifiedDate(serviceContext.getModifiedDate(now));
        backgroundTask.setUserId(userId);
        backgroundTask.setUserName(user.getFullName());
        backgroundTask.setName(name);
        backgroundTask.setServletContextNames(StringUtil.merge((Object[])servletContextNames));
        backgroundTask.setTaskExecutorClassName(taskExecutorClass.getName());
        if (taskContextMap != null) {
            backgroundTask.setTaskContextMap(taskContextMap);
        }
        backgroundTask.setStatus(0);
        this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BackgroundTaskLocalServiceImpl.this.backgroundTaskLocalService.triggerBackgroundTask(backgroundTaskId);
                return null;
            }
        });
        return backgroundTask;
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, File file) throws PortalException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (File)file, (String)fileName, (String)"application/zip", (boolean)false);
    }

    public void addBackgroundTaskAttachment(long userId, long backgroundTaskId, String fileName, InputStream inputStream) throws PortalException {
        BackgroundTask backgroundTask = this.getBackgroundTask(backgroundTaskId);
        Folder folder = backgroundTask.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)backgroundTask.getGroupId(), (long)userId, (String)BackgroundTask.class.getName(), (long)backgroundTask.getPrimaryKey(), (String)"189", (long)folder.getFolderId(), (InputStream)inputStream, (String)fileName, (String)"application/zip", (boolean)false);
    }

    public BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, ServiceContext serviceContext) {
        return this.amendBackgroundTask(backgroundTaskId, taskContextMap, status, null, serviceContext);
    }

    public BackgroundTask amendBackgroundTask(long backgroundTaskId, Map<String, Serializable> taskContextMap, int status, String statusMessage, ServiceContext serviceContext) {
        Date now = new Date();
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
        if (backgroundTask == null) {
            return null;
        }
        backgroundTask.setModifiedDate(serviceContext.getModifiedDate(now));
        if (taskContextMap != null) {
            backgroundTask.setTaskContextMap(taskContextMap);
        }
        if (status == 2 || status == 3) {
            backgroundTask.setCompleted(true);
            backgroundTask.setCompletionDate(now);
        }
        backgroundTask.setStatus(status);
        if (Validator.isNotNull((String)statusMessage)) {
            backgroundTask.setStatusMessage(statusMessage);
        }
        this.backgroundTaskPersistence.update((BaseModel)backgroundTask);
        return backgroundTask;
    }

    @Clusterable(onMaster=true)
    public void cleanUpBackgroundTask(final BackgroundTask backgroundTask, final int status) {
        try {
            Lock lock = this.lockLocalService.getLock(BackgroundTaskExecutor.class.getName(), backgroundTask.getTaskExecutorClassName());
            String owner = backgroundTask.getName() + "#" + backgroundTask.getBackgroundTaskId();
            if (owner.equals(lock.getOwner())) {
                this.lockLocalService.unlock(BackgroundTaskExecutor.class.getName(), backgroundTask.getTaskExecutorClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("backgroundTaskId", (Object)backgroundTask.getBackgroundTaskId());
                message.put("name", (Object)backgroundTask.getName());
                message.put("status", (Object)status);
                message.put("taskExecutorClassName", (Object)backgroundTask.getTaskExecutorClassName());
                MessageBusUtil.sendMessage((String)"liferay/background_task_status", (Message)message);
                return null;
            }
        });
    }

    @Clusterable(onMaster=true)
    public void cleanUpBackgroundTasks() {
        List backgroundTasks = this.backgroundTaskPersistence.findByStatus(1);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            backgroundTask.setStatus(2);
            this.cleanUpBackgroundTask(backgroundTask, 2);
        }
    }

    @Override
    public BackgroundTask deleteBackgroundTask(BackgroundTask backgroundTask) throws PortalException {
        long folderId = backgroundTask.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        if (backgroundTask.getStatus() == 1) {
            this.cleanUpBackgroundTask(backgroundTask, 5);
        }
        return (BackgroundTask)this.backgroundTaskPersistence.remove((BaseModel)backgroundTask);
    }

    @Override
    public BackgroundTask deleteBackgroundTask(long backgroundTaskId) throws PortalException {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
        return this.deleteBackgroundTask(backgroundTask);
    }

    public void deleteCompanyBackgroundTasks(long companyId) throws PortalException {
        List backgroundTasks = this.backgroundTaskPersistence.findByCompanyId(companyId);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            this.deleteBackgroundTask(backgroundTask);
        }
    }

    public void deleteGroupBackgroundTasks(long groupId) throws PortalException {
        List backgroundTasks = this.backgroundTaskPersistence.findByGroupId(groupId);
        for (BackgroundTask backgroundTask : backgroundTasks) {
            this.deleteBackgroundTask(backgroundTask);
        }
    }

    @Override
    public BackgroundTask fetchBackgroundTask(long backgroundTaskId) {
        return this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
    }

    public BackgroundTask fetchFirstBackgroundTask(long groupId, String taskExecutorClassName, boolean completed, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.fetchByG_T_C_First(groupId, taskExecutorClassName, completed, orderByComparator);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status) {
        return this.fetchFirstBackgroundTask(taskExecutorClassName, status, null);
    }

    public BackgroundTask fetchFirstBackgroundTask(String taskExecutorClassName, int status, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.fetchByT_S_First(taskExecutorClassName, status, orderByComparator);
    }

    @Override
    public BackgroundTask getBackgroundTask(long backgroundTaskId) throws PortalException {
        return this.backgroundTaskPersistence.findByPrimaryKey(backgroundTaskId);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, int status) {
        return this.backgroundTaskPersistence.findByG_S(groupId, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassName);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int status) {
        return this.backgroundTaskPersistence.findByG_T_S(groupId, taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String taskExecutorClassName, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassName, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String name, String taskExecutorClassName, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_N_T(groupId, name, taskExecutorClassName, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassNames);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames, int status) {
        return this.backgroundTaskPersistence.findByG_T_S(groupId, taskExecutorClassNames, status);
    }

    public List<BackgroundTask> getBackgroundTasks(long groupId, String[] taskExecutorClassNames, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByG_T(groupId, taskExecutorClassNames, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String taskExecutorClassName, int status, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassName, status, start, end, orderByComparator);
    }

    public List<BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassNames, status);
    }

    public List<BackgroundTask> getBackgroundTasks(String[] taskExecutorClassNames, int status, int start, int end, OrderByComparator<BackgroundTask> orderByComparator) {
        return this.backgroundTaskPersistence.findByT_S(taskExecutorClassNames, status, start, end, orderByComparator);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_T(groupId, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String taskExecutorClassName, boolean completed) {
        return this.backgroundTaskPersistence.countByG_T_C(groupId, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName) {
        return this.backgroundTaskPersistence.countByG_N_T(groupId, name, taskExecutorClassName);
    }

    public int getBackgroundTasksCount(long groupId, String name, String taskExecutorClassName, boolean completed) {
        return this.backgroundTaskPersistence.countByG_N_T_C(groupId, name, taskExecutorClassName, completed);
    }

    public int getBackgroundTasksCount(long groupId, String[] taskExecutorClassNames) {
        return this.backgroundTaskPersistence.countByG_T(groupId, taskExecutorClassNames);
    }

    public int getBackgroundTasksCount(long groupId, String[] taskExecutorClassNames, boolean completed) {
        return this.backgroundTaskPersistence.countByG_T_C(groupId, taskExecutorClassNames, completed);
    }

    @Clusterable(onMaster=true)
    public String getBackgroundTaskStatusJSON(long backgroundTaskId) {
        BackgroundTaskStatus backgroundTaskStatus = this._backgroundTaskStatusRegistry.getBackgroundTaskStatus(backgroundTaskId);
        if (backgroundTaskStatus != null) {
            return backgroundTaskStatus.getAttributesJSON();
        }
        return "";
    }

    @Clusterable(onMaster=true)
    public void resumeBackgroundTask(long backgroundTaskId) {
        BackgroundTask backgroundTask = this.backgroundTaskPersistence.fetchByPrimaryKey(backgroundTaskId);
        if (backgroundTask == null || backgroundTask.getStatus() != 4) {
            return;
        }
        Message message = new Message();
        message.put("backgroundTaskId", (Object)backgroundTaskId);
        MessageBusUtil.sendMessage((String)"liferay/background_task", (Message)message);
    }

    @Clusterable(onMaster=true)
    public void triggerBackgroundTask(long backgroundTaskId) {
        Message message = new Message();
        message.put("backgroundTaskId", (Object)backgroundTaskId);
        MessageBusUtil.sendMessage((String)"liferay/background_task", (Message)message);
    }
}

