/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.model.Team;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.TeamServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import java.util.List;

@ProviderType
public class TeamServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceHttp.class);
    private static final Class<?>[] _addTeamParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _deleteTeamParameterTypes1 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupTeamsParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserTeamsParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserTeamsParameterTypes6 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _hasUserTeamParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _updateTeamParameterTypes8 = new Class[]{Long.TYPE, String.class, String.class};

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "addTeam", (Class[])_addTeamParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "deleteTeam", (Class[])_deleteTeamParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getGroupTeams(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getGroupTeams", (Class[])_getGroupTeamsParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserTeam(HttpPrincipal httpPrincipal, long userId, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "hasUserTeam", (Class[])_hasUserTeamParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team updateTeam(HttpPrincipal httpPrincipal, long teamId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "updateTeam", (Class[])_updateTeamParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

