/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.configuration.configurator.impl;

import com.liferay.portal.cache.configurator.PortalCacheConfigurator;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.service.ServiceComponentLocalService;
import com.liferay.portal.service.configuration.ServiceComponentConfiguration;
import com.liferay.portal.service.configuration.configurator.ServiceConfigurator;
import com.liferay.util.log4j.Log4JUtil;
import java.net.URL;
import java.util.List;
import java.util.Properties;

public class ServiceConfiguratorImpl
implements ServiceConfigurator {
    private static Log _log = LogFactoryUtil.getLog(ServiceConfiguratorImpl.class);
    private PortalCacheConfigurator _portalCacheConfigurator;
    private ServiceComponentLocalService _serviceComponentLocalService;

    public void destroyServices(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) throws Exception {
        this.destroyServiceComponent(serviceComponentConfiguration, classLoader);
    }

    public void initServices(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) throws Exception {
        this.initLog4J(classLoader);
        this.initServiceComponent(serviceComponentConfiguration, classLoader);
        this.reconfigureCaches(classLoader);
        this.readResourceActions(classLoader);
    }

    public void setPortalCacheConfigurator(PortalCacheConfigurator portalCacheConfigurator) {
        this._portalCacheConfigurator = portalCacheConfigurator;
    }

    public void setServiceComponentLocalService(ServiceComponentLocalService serviceComponentLocalService) {
        this._serviceComponentLocalService = serviceComponentLocalService;
    }

    protected void destroyServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) throws Exception {
        this._serviceComponentLocalService.destroyServiceComponent(serviceComponentConfiguration, classLoader);
    }

    protected URL getPortalCacheConfigurationURL(Configuration configuration, ClassLoader classLoader, String configLocation) {
        String cacheConfigurationLocation = configuration.get(configLocation);
        if (Validator.isNull((String)cacheConfigurationLocation)) {
            return null;
        }
        return classLoader.getResource(cacheConfigurationLocation);
    }

    protected void initLog4J(ClassLoader classLoader) {
        Log4JUtil.configureLog4J((URL)classLoader.getResource("META-INF/portal-log4j.xml"));
    }

    protected void initServiceComponent(ServiceComponentConfiguration serviceComponentConfiguration, ClassLoader classLoader) {
        Configuration configuration = null;
        try {
            configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read service.properties");
            }
            return;
        }
        Properties properties = configuration.getProperties();
        if (properties.isEmpty()) {
            return;
        }
        String buildNamespace = GetterUtil.getString((String)properties.getProperty("build.namespace"));
        long buildNumber = GetterUtil.getLong((String)properties.getProperty("build.number"));
        long buildDate = GetterUtil.getLong((String)properties.getProperty("build.date"));
        boolean buildAutoUpgrade = GetterUtil.getBoolean((String)properties.getProperty("build.auto.upgrade"), (boolean)true);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Build namespace " + buildNamespace));
            _log.debug((Object)("Build number " + buildNumber));
            _log.debug((Object)("Build date " + buildDate));
            _log.debug((Object)("Build auto upgrade " + buildAutoUpgrade));
        }
        if (Validator.isNull((String)buildNamespace)) {
            return;
        }
        try {
            this._serviceComponentLocalService.initServiceComponent(serviceComponentConfiguration, classLoader, buildNamespace, buildNumber, buildDate, buildAutoUpgrade);
        }
        catch (PortalException pe) {
            _log.error((Object)"Unable to initialize service component", (Throwable)pe);
        }
    }

    protected void readResourceActions(ClassLoader classLoader) {
        String[] portletIds;
        String[] resourceActionsConfigs;
        Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        for (String resourceActionsConfig : resourceActionsConfigs = StringUtil.split((String)configuration.get("resource.actions.configs"))) {
            try {
                ResourceActionsUtil.read(null, (ClassLoader)classLoader, (String)resourceActionsConfig);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to read resource actions config in " + resourceActionsConfig), (Throwable)e);
            }
        }
        for (String portletId : portletIds = StringUtil.split((String)configuration.get("service.configurator.portlet.ids"))) {
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portletId);
            for (String modelName : modelNames) {
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
        }
    }

    protected void reconfigureCaches(ClassLoader classLoader) throws Exception {
        Configuration configuration = null;
        try {
            configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to read portlet.properties");
            }
            return;
        }
        this._portalCacheConfigurator.reconfigureCaches(classLoader, this.getPortalCacheConfigurationURL(configuration, classLoader, "ehcache.single.vm.config.location"));
        this._portalCacheConfigurator.reconfigureCaches(classLoader, this.getPortalCacheConfigurationURL(configuration, classLoader, "ehcache.multi.vm.config.location"));
        this._portalCacheConfigurator.reconfigureHibernateCache(this.getPortalCacheConfigurationURL(configuration, classLoader, "net.sf.ehcache.configurationResourceName"));
    }
}

