/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.base;

import aQute.bnd.annotation.ProviderType;
import com.liferay.counter.service.CounterLocalService;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.bean.IdentifiableBean;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ManifestSummary;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.PersistedModel;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.BaseLocalService;
import com.liferay.portal.service.BaseLocalServiceImpl;
import com.liferay.portal.service.PersistedModelLocalService;
import com.liferay.portal.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.service.RepositoryEntryLocalService;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.UserLocalService;
import com.liferay.portal.service.UserService;
import com.liferay.portal.service.persistence.RepositoryEntryPersistence;
import com.liferay.portal.service.persistence.UserFinder;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;

@ProviderType
public abstract class RepositoryEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements RepositoryEntryLocalService,
IdentifiableBean {
    @BeanReference(type=RepositoryEntryLocalService.class)
    protected RepositoryEntryLocalService repositoryEntryLocalService;
    @BeanReference(type=RepositoryEntryPersistence.class)
    protected RepositoryEntryPersistence repositoryEntryPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @BeanReference(type=UserService.class)
    protected UserService userService;
    @BeanReference(type=UserPersistence.class)
    protected UserPersistence userPersistence;
    @BeanReference(type=UserFinder.class)
    protected UserFinder userFinder;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;
    private String _beanIdentifier;

    @Indexable(type=IndexableType.REINDEX)
    public RepositoryEntry addRepositoryEntry(RepositoryEntry repositoryEntry) {
        repositoryEntry.setNew(true);
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }

    public RepositoryEntry createRepositoryEntry(long repositoryEntryId) {
        return this.repositoryEntryPersistence.create(repositoryEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RepositoryEntry deleteRepositoryEntry(long repositoryEntryId) throws PortalException {
        return this.repositoryEntryPersistence.remove(repositoryEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public RepositoryEntry deleteRepositoryEntry(RepositoryEntry repositoryEntry) {
        return (RepositoryEntry)this.repositoryEntryPersistence.remove((BaseModel)repositoryEntry);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(RepositoryEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.repositoryEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.repositoryEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.repositoryEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public RepositoryEntry fetchRepositoryEntry(long repositoryEntryId) {
        return this.repositoryEntryPersistence.fetchByPrimaryKey(repositoryEntryId);
    }

    public RepositoryEntry fetchRepositoryEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.repositoryEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public RepositoryEntry getRepositoryEntry(long repositoryEntryId) throws PortalException {
        return this.repositoryEntryPersistence.findByPrimaryKey(repositoryEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)RepositoryEntryLocalServiceUtil.getService());
        actionableDynamicQuery.setClass(RepositoryEntry.class);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryEntryId");
        return actionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)RepositoryEntryLocalServiceUtil.getService());
        actionableDynamicQuery.setClass(RepositoryEntry.class);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setPrimaryKeyPropertyName("repositoryEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType.toString(), modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType.toString(), modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                RepositoryEntry stagedModel = (RepositoryEntry)object;
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)RepositoryEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.repositoryEntryLocalService.deleteRepositoryEntry((RepositoryEntry)persistedModel);
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.repositoryEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<RepositoryEntry> getRepositoryEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.repositoryEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<RepositoryEntry> getRepositoryEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<RepositoryEntry> orderByComparator) {
        return this.repositoryEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public RepositoryEntry getRepositoryEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.repositoryEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<RepositoryEntry> getRepositoryEntries(int start, int end) {
        return this.repositoryEntryPersistence.findAll(start, end);
    }

    public int getRepositoryEntriesCount() {
        return this.repositoryEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public RepositoryEntry updateRepositoryEntry(RepositoryEntry repositoryEntry) {
        return (RepositoryEntry)this.repositoryEntryPersistence.update((BaseModel)repositoryEntry);
    }

    public RepositoryEntryLocalService getRepositoryEntryLocalService() {
        return this.repositoryEntryLocalService;
    }

    public void setRepositoryEntryLocalService(RepositoryEntryLocalService repositoryEntryLocalService) {
        this.repositoryEntryLocalService = repositoryEntryLocalService;
    }

    public RepositoryEntryPersistence getRepositoryEntryPersistence() {
        return this.repositoryEntryPersistence;
    }

    public void setRepositoryEntryPersistence(RepositoryEntryPersistence repositoryEntryPersistence) {
        this.repositoryEntryPersistence = repositoryEntryPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public UserLocalService getUserLocalService() {
        return this.userLocalService;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public UserPersistence getUserPersistence() {
        return this.userPersistence;
    }

    public void setUserPersistence(UserPersistence userPersistence) {
        this.userPersistence = userPersistence;
    }

    public UserFinder getUserFinder() {
        return this.userFinder;
    }

    public void setUserFinder(UserFinder userFinder) {
        this.userFinder = userFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.portal.model.RepositoryEntry", (PersistedModelLocalService)this.repositoryEntryLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.portal.model.RepositoryEntry");
    }

    public String getBeanIdentifier() {
        return this._beanIdentifier;
    }

    public void setBeanIdentifier(String beanIdentifier) {
        this._beanIdentifier = beanIdentifier;
    }

    protected Class<?> getModelClass() {
        return RepositoryEntry.class;
    }

    protected String getModelClassName() {
        return RepositoryEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.repositoryEntryPersistence.getDataSource();
            DB db = DBFactoryUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (int[])new int[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

