/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.server;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeepNamedValueScanner {
    private static Log _log = LogFactoryUtil.getLog(DeepNamedValueScanner.class);
    private long _elapsedTime;
    private String[] _excludedClassNames;
    private String[] _excludedNames;
    private String[] _includedClassNames;
    private Object _matchedValue;
    private int _matchingCount;
    private Map<String, Dataset> _nameDatasets;
    private boolean _scanning;
    private int _skipFirstCount;
    private boolean _trackUsageCount;
    private Map<String, Dataset> _typeDatasets;
    private final String _value;
    private boolean _visitArrays;
    private boolean _visitCollections;
    private Set<String> _visitedIds;
    private boolean _visitLists;
    private boolean _visitMaps;
    private boolean _visitSets;
    private boolean _visitStaticFields;

    public DeepNamedValueScanner(String value) {
        this._value = StringUtil.toLowerCase((String)value);
    }

    public DeepNamedValueScanner(String value, boolean visit) {
        this(value);
        this._visitArrays = visit;
        this._visitCollections = visit;
        this._visitLists = visit;
        this._visitSets = visit;
        this._visitMaps = visit;
        this._visitStaticFields = visit;
    }

    public long getElapsedTime() {
        return this._elapsedTime;
    }

    public String[] getExcludedClassNames() {
        return this._excludedClassNames;
    }

    public String[] getExcludedNames() {
        return this._excludedNames;
    }

    public String[] getIncludedClassNames() {
        return this._includedClassNames;
    }

    public Object getMatchedValue() {
        return this._matchedValue;
    }

    public int getMatchingCount() {
        return this._matchingCount;
    }

    public int getSkipFirstCount() {
        return this._skipFirstCount;
    }

    public boolean isScanning() {
        return this._scanning;
    }

    public boolean isTrackUsageCount() {
        return this._trackUsageCount;
    }

    public boolean isVisitArrays() {
        return this._visitArrays;
    }

    public boolean isVisitCollectionss() {
        return this._visitCollections;
    }

    public boolean isVisitLists() {
        return this._visitLists;
    }

    public boolean isVisitMaps() {
        return this._visitMaps;
    }

    public boolean isVisitSets() {
        return this._visitSets;
    }

    public boolean isVisitStaticFields() {
        return this._visitStaticFields;
    }

    public void printStatistics(int topCount) {
        if (!this._trackUsageCount) {
            return;
        }
        System.out.println("-- names statistics --");
        this._printStatistics(this._nameDatasets.values(), topCount);
        System.out.println("-- types statistics --");
        this._printStatistics(this._typeDatasets.values(), topCount);
    }

    public boolean scan(Object target) throws Exception {
        this._elapsedTime = System.currentTimeMillis();
        this._visitedIds = new HashSet<String>();
        this._scanning = true;
        this._scan(target);
        this._visitedIds = null;
        this._elapsedTime = System.currentTimeMillis() - this._elapsedTime;
        if (_log.isDebugEnabled()) {
            if (!this._scanning) {
                StringBundler sb = new StringBundler(5);
                sb.append("Deep named value scanner found ");
                sb.append(this._matchingCount);
                sb.append(" matches in ");
                sb.append(this._elapsedTime);
                sb.append(" ms");
                _log.debug((Object)sb.toString());
            } else {
                _log.debug((Object)"Deep named value scanner did not finish scanning");
            }
        }
        return !this._scanning;
    }

    public void setExcludedClassNames(String ... excludedClassNames) {
        this._excludedClassNames = excludedClassNames;
        StringUtil.lowerCase((String[])excludedClassNames);
    }

    public void setExcludedNames(String ... excludedNames) {
        this._excludedNames = excludedNames;
        StringUtil.lowerCase((String[])excludedNames);
    }

    public void setIncludedClassNames(String ... includedClassNames) {
        this._includedClassNames = includedClassNames;
        StringUtil.lowerCase((String[])includedClassNames);
    }

    public void setSkipFirstCount(int skipFirstCount) {
        this._skipFirstCount = skipFirstCount;
    }

    public void setTrackUsageCount(boolean trackUsageCount) {
        this._trackUsageCount = trackUsageCount;
        if (trackUsageCount) {
            this._nameDatasets = new HashMap<String, Dataset>();
            this._typeDatasets = new HashMap<String, Dataset>();
        }
    }

    public void setVisitArrays(boolean visitArrays) {
        this._visitArrays = visitArrays;
    }

    public void setVisitCollections(boolean visitCollections) {
        this._visitCollections = visitCollections;
    }

    public void setVisitLists(boolean visitLists) {
        this._visitLists = visitLists;
    }

    public void setVisitMaps(boolean visitMaps) {
        this._visitMaps = visitMaps;
    }

    public void setVisitSets(boolean visitSets) {
        this._visitSets = visitSets;
    }

    public void setVisitStaticFields(boolean visitStaticFields) {
        this._visitStaticFields = visitStaticFields;
    }

    private void _incrementUsageCount(Map<String, Dataset> datasets, String name) {
        Dataset dataset = datasets.get(name);
        if (dataset == null) {
            dataset = new Dataset();
            dataset.setKey(name);
            dataset.setValue(new IntegerWrapper());
            datasets.put(name, dataset);
        }
        IntegerWrapper integerWrapper = (IntegerWrapper)dataset.getValue();
        integerWrapper.increment();
    }

    private boolean _isAcceptClass(Class<?> targetClass) {
        String targetClassName = targetClass.getName();
        if ((targetClassName = StringUtil.toLowerCase((String)targetClassName)).startsWith("java.")) {
            return false;
        }
        if (targetClassName.startsWith("org.eclipse.osgi.")) {
            return false;
        }
        if (targetClassName.startsWith("sun.misc.")) {
            return false;
        }
        if (targetClassName.contains("log")) {
            return false;
        }
        if (this._excludedClassNames != null) {
            for (String excludedClassName : this._excludedClassNames) {
                if (!targetClassName.contains(excludedClassName)) continue;
                return false;
            }
        }
        if (this._includedClassNames != null) {
            boolean accept = false;
            for (String includedClassName : this._includedClassNames) {
                if (!targetClassName.contains(includedClassName)) continue;
                accept = true;
                break;
            }
            if (!accept) {
                return false;
            }
        }
        if (this._trackUsageCount) {
            this._incrementUsageCount(this._typeDatasets, targetClass.getName());
        }
        return true;
    }

    private boolean _isAcceptName(String name) {
        if (name == null) {
            return true;
        }
        name = StringUtil.toLowerCase((String)name);
        if (this._excludedNames != null) {
            for (String excludedNames : this._excludedNames) {
                if (!name.contains(excludedNames)) continue;
                return false;
            }
        }
        if (this._trackUsageCount) {
            this._incrementUsageCount(this._nameDatasets, name);
        }
        return true;
    }

    private void _matchField(Object target, Field field, String name) throws IllegalAccessException {
        if (name == null) {
            return;
        }
        ++this._matchingCount;
        if ((name = StringUtil.toLowerCase((String)name)).contains(this._value)) {
            if (this._skipFirstCount > 0) {
                --this._skipFirstCount;
                return;
            }
            field.setAccessible(true);
            this._matchedValue = field.get(target);
            this._scanning = false;
        }
    }

    private void _matchName(Object value, String name) {
        if (name == null) {
            return;
        }
        ++this._matchingCount;
        if ((name = StringUtil.toLowerCase((String)name)).contains(this._value)) {
            if (this._skipFirstCount > 0) {
                --this._skipFirstCount;
                return;
            }
            this._matchedValue = value;
            this._scanning = false;
        }
    }

    private void _printStatistics(Collection<Dataset> datasets, int topCount) {
        ArrayList<Dataset> datasetsList = new ArrayList<Dataset>();
        for (Dataset dataset : datasets) {
            datasetsList.add(dataset);
        }
        Collections.sort(datasetsList);
        for (Dataset dataset : datasetsList) {
            System.out.println(dataset.getValue() + " " + (String)dataset.getKey());
            if (--topCount != 0) continue;
            break;
        }
    }

    private Object _resolveJavaProxy(Object target) throws IllegalAccessException, NoSuchFieldException {
        Class<?> targetClass = target.getClass();
        Class<?> targetSuperClass = targetClass.getSuperclass();
        if (targetSuperClass != null && targetSuperClass.equals(Proxy.class)) {
            Field field = targetSuperClass.getDeclaredField("h");
            field.setAccessible(true);
            target = field.get(target);
        }
        return target;
    }

    private void _scan(Object target) throws Exception {
        if (target == null) {
            return;
        }
        if (!this._scanning) {
            return;
        }
        target = this._resolveJavaProxy(target);
        String visitedId = null;
        try {
            visitedId = String.valueOf(System.identityHashCode(target));
            if (this._visitedIds.contains(visitedId)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        this._visitedIds.add(visitedId);
        Class<?> targetClass = target.getClass();
        if (targetClass.isArray()) {
            if (!this._visitArrays) {
                return;
            }
            Class<?> componentTypeClass = targetClass.getComponentType();
            if (!componentTypeClass.isPrimitive()) {
                Object[] array;
                for (Object element : array = (Object[])target) {
                    this._scan(element);
                }
            }
        } else if (this._visitLists && target instanceof List) {
            this._scanCollection((List)target);
        } else if (this._visitMaps && target instanceof Map) {
            this._scanMap((Map)target);
        } else if (this._visitSets && target instanceof Set) {
            this._scanCollection((Set)target);
        } else if (this._visitCollections && target instanceof Collection) {
            this._scanCollection((Collection)target);
        } else {
            this._scanObject(target);
        }
    }

    private void _scanCollection(Collection<Object> collection) throws Exception {
        for (Object element : collection) {
            if (!this._scanning) break;
            this._scan(element);
        }
    }

    private void _scanMap(Map<Object, Object> map) throws Exception {
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            if (!this._scanning) break;
            Object key = entry.getKey();
            Object value = entry.getValue();
            String name = null;
            if (key != null) {
                name = key.toString();
            }
            if (!this._isAcceptName(name)) continue;
            this._matchName(value, name);
            this._scan(value);
        }
    }

    private void _scanObject(Object target) throws Exception {
        Class<?> targetClass = target.getClass();
        if (!this._isAcceptClass(targetClass)) {
            return;
        }
        while (targetClass != null) {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                String fieldName;
                if (!this._scanning) break;
                if (!this._visitStaticFields && (field.getModifiers() & 8) != 0 || !this._isAcceptName(fieldName = field.getName())) continue;
                this._matchField(target, field, fieldName);
                field.setAccessible(true);
                Object fieldValue = field.get(target);
                if (fieldValue == null) continue;
                this._scan(fieldValue);
            }
            targetClass = targetClass.getSuperclass();
        }
    }

    private class Dataset
    extends ObjectValuePair<String, IntegerWrapper>
    implements Comparable<Dataset> {
        private Dataset() {
        }

        @Override
        public int compareTo(Dataset dataset) {
            IntegerWrapper integerWrapper = (IntegerWrapper)dataset.getValue();
            return integerWrapper.compareTo((IntegerWrapper)this.getValue());
        }
    }
}

