/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.sso;

import com.liferay.portal.security.sso.SSO;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.http.HttpServletRequest;

public class SSOUtil {
    private static final String _SERVER_IP = "SERVER_IP";
    private static SSOUtil _instance = new SSOUtil();
    private ServiceTracker<SSO, SSO> _serviceTracker;
    private Map<ServiceReference<SSO>, SSO> _ssoMap = new ConcurrentSkipListMap(Collections.reverseOrder());

    public static String getSessionExpirationRedirectURL(long companyId, String sessionExpirationRedirectURL) {
        if (PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) && PropsValues.CAS_LOGOUT_ON_SESSION_EXPIRATION) {
            return PrefsPropsUtil.getString(companyId, "cas.logout.url", PropsValues.CAS_LOGOUT_URL);
        }
        if (PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED) && PropsValues.OPEN_SSO_LOGOUT_ON_SESSION_EXPIRATION) {
            return PrefsPropsUtil.getString(companyId, "open.sso.logout.url", PropsValues.OPEN_SSO_LOGOUT_URL);
        }
        return sessionExpirationRedirectURL;
    }

    public static String getSignInURL(long companyId, String signInURL) {
        if (PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) || PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED)) {
            return signInURL;
        }
        return null;
    }

    public static boolean isAccessAllowed(HttpServletRequest request, Set<String> hostsAllowed) {
        if (hostsAllowed.isEmpty()) {
            return true;
        }
        String remoteAddr = request.getRemoteAddr();
        if (hostsAllowed.contains(remoteAddr)) {
            return true;
        }
        String computerAddress = PortalUtil.getComputerAddress();
        return computerAddress.equals(remoteAddr) && hostsAllowed.contains(_SERVER_IP);
    }

    public static boolean isLoginRedirectRequired(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) || PrefsPropsUtil.getBoolean(companyId, "login.dialog.disabled", PropsValues.LOGIN_DIALOG_DISABLED) || PrefsPropsUtil.getBoolean(companyId, "ntlm.auth.enabled", PropsValues.NTLM_AUTH_ENABLED) || PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED);
    }

    public static boolean isRedirectRequired(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED);
    }

    public static boolean isSessionRedirectOnExpire(long companyId) {
        boolean sessionRedirectOnExpire = PropsValues.SESSION_TIMEOUT_REDIRECT_ON_EXPIRE;
        if (PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED) && PropsValues.CAS_LOGOUT_ON_SESSION_EXPIRATION) {
            sessionRedirectOnExpire = true;
        } else if (PrefsPropsUtil.getBoolean(companyId, "open.sso.auth.enabled", PropsValues.OPEN_SSO_AUTH_ENABLED) && PropsValues.OPEN_SSO_LOGOUT_ON_SESSION_EXPIRATION) {
            sessionRedirectOnExpire = true;
        }
        return sessionRedirectOnExpire;
    }

    private SSOUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(SSO.class, (ServiceTrackerCustomizer)new SSOServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private String _getSessionExpirationRedirectUrl() {
        for (SSO sso : this._ssoMap.values()) {
            String sessionExpirationRedirectUrl = sso.getSessionExpirationRedirectUrl();
            if (sessionExpirationRedirectUrl == null) continue;
            return sessionExpirationRedirectUrl;
        }
        return null;
    }

    private String _getSignInUrl() {
        for (SSO sso : this._ssoMap.values()) {
            String signInURL = sso.getSignInURL();
            if (signInURL == null) continue;
            return signInURL;
        }
        return null;
    }

    private boolean _isLoginRedirectRequired() {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isLoginRedirectRequired()) continue;
            return true;
        }
        return false;
    }

    private boolean _isRedirectRequired() {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isRedirectRequired()) continue;
            return true;
        }
        return false;
    }

    private boolean _isSessionRedirectOnExpire() {
        for (SSO sso : this._ssoMap.values()) {
            if (!sso.isSessionRedirectOnExpire()) continue;
            return true;
        }
        return false;
    }

    private class SSOServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<SSO, SSO> {
        private SSOServiceTrackerCustomizer() {
        }

        public SSO addingService(ServiceReference<SSO> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            SSO sso = (SSO)registry.getService(serviceReference);
            SSOUtil.this._ssoMap.put(serviceReference, sso);
            return sso;
        }

        public void modifiedService(ServiceReference<SSO> serviceReference, SSO sso) {
        }

        public void removedService(ServiceReference<SSO> serviceReference, SSO sso) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            SSOUtil.this._ssoMap.remove(serviceReference);
        }
    }
}

