/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.portal.security.pwd.Toolkit;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;

public class PwdToolkitUtil {
    private static PwdToolkitUtil _instance = new PwdToolkitUtil();
    private ServiceTracker<Toolkit, Toolkit> _serviceTracker;

    public static String generate(PasswordPolicy passwordPolicy) {
        Toolkit toolkit = PwdToolkitUtil.getToolkit();
        return toolkit.generate(passwordPolicy);
    }

    public static Toolkit getToolkit() {
        return (Toolkit)PwdToolkitUtil._instance._serviceTracker.getService();
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException(10);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled(companyId) && PwdToolkitUtilThreadLocal.isValidate()) {
            Toolkit toolkit = PwdToolkitUtil.getToolkit();
            toolkit.validate(userId, password1, password2, passwordPolicy);
        }
    }

    private PwdToolkitUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(Toolkit.class);
        this._serviceTracker.open();
    }
}

