/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksEntryPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksFolderPermission;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.service.MBThreadLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.service.permission.MBPermission;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;

public class PermissionCheckerUtil {
    private static Log _log = LogFactoryUtil.getLog(PermissionCheckerUtil.class);

    public static Boolean containsResourcePermission(PermissionChecker permissionChecker, String className, long classPK, String actionId) throws PortalException {
        if (className.equals(BlogsEntry.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                return BlogsEntryPermission.contains(permissionChecker, classPK, actionId);
            }
            return BlogsPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(BookmarksEntry.class.getName())) {
            return BookmarksEntryPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(BookmarksFolder.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getFolder((long)classPK);
                return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
            }
            return BookmarksPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(DLFileEntry.class.getName())) {
            return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(Folder.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                Folder folder = DLAppLocalServiceUtil.getFolder((long)classPK);
                return DLFolderPermission.contains(permissionChecker, folder, actionId);
            }
            return DLPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(JournalArticle.class.getName())) {
            JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
            return JournalArticlePermission.contains(permissionChecker, article, actionId);
        }
        if (className.equals(JournalFolder.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
                return JournalFolderPermission.contains(permissionChecker, folder, actionId);
            }
            return JournalPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(MBCategory.class.getName())) {
            Group group = GroupLocalServiceUtil.fetchGroup((long)classPK);
            if (group == null) {
                return MBCategoryPermission.contains(permissionChecker, classPK, actionId);
            }
            return MBPermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(MBMessage.class.getName())) {
            return MBMessagePermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(MBThread.class.getName())) {
            MBThread mbThread = MBThreadLocalServiceUtil.fetchThread((long)classPK);
            if (mbThread == null) {
                return false;
            }
            return MBMessagePermission.contains(permissionChecker, mbThread.getRootMessageId(), actionId);
        }
        if (className.equals(WikiNode.class.getName())) {
            return WikiNodePermission.contains(permissionChecker, classPK, actionId);
        }
        if (className.equals(WikiPage.class.getName())) {
            WikiPage page = WikiPageLocalServiceUtil.getPageByPageId((long)classPK);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        return null;
    }

    public static void setThreadValues(User user) {
        if (user == null) {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
            return;
        }
        long userId = user.getUserId();
        String name = String.valueOf(userId);
        PrincipalThreadLocal.setName((String)name);
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                Class<?> clazz = Class.forName(PropsValues.PERMISSIONS_CHECKER);
                permissionChecker = (PermissionChecker)clazz.newInstance();
            }
            permissionChecker.init(user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }
}

