/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.security.permission.UserPermissionCheckerBag;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;

public class PermissionCacheUtil {
    public static final String PERMISSION_CACHE_NAME = PermissionCacheUtil.class.getName() + "_PERMISSION";
    public static final String PERMISSION_CHECKER_BAG_CACHE_NAME = PermissionCacheUtil.class.getName() + "_PERMISSION_CHECKER_BAG";
    public static final String RESOURCE_BLOCK_IDS_BAG_CACHE_NAME = PermissionCacheUtil.class.getName() + "_RESOURCE_BLOCK_IDS_BAG";
    public static final String USER_PERMISSION_CHECKER_BAG_CACHE_NAME = PermissionCacheUtil.class.getName() + "_USER_PERMISSION_CHECKER_BAG";
    private static PortalCache<BagKey, PermissionCheckerBag> _permissionCheckerBagPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CHECKER_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
    private static PortalCache<PermissionKey, Boolean> _permissionPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
    private static PortalCache<ResourceBlockIdsBagKey, ResourceBlockIdsBag> _resourceBlockIdsBagCache = MultiVMPoolUtil.getCache((String)RESOURCE_BLOCK_IDS_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
    private static PortalCache<Long, UserPermissionCheckerBag> _userPermissionCheckerBagPortalCache = MultiVMPoolUtil.getCache((String)USER_PERMISSION_CHECKER_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);

    public static void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess() || !PermissionThreadLocal.isFlushEnabled()) {
            return;
        }
        _permissionCheckerBagPortalCache.removeAll();
        _permissionPortalCache.removeAll();
        _resourceBlockIdsBagCache.removeAll();
        _userPermissionCheckerBagPortalCache.removeAll();
    }

    public static PermissionCheckerBag getBag(long userId, long groupId) {
        BagKey bagKey = new BagKey(userId, groupId);
        return (PermissionCheckerBag)_permissionCheckerBagPortalCache.get((Serializable)bagKey);
    }

    public static Boolean getPermission(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId) {
        PermissionKey permissionKey = new PermissionKey(userId, signedIn, groupId, name, primKey, actionId);
        return (Boolean)_permissionPortalCache.get((Serializable)permissionKey);
    }

    public static ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, long userId, String name) {
        ResourceBlockIdsBagKey resourceBlockIdsBagKey = new ResourceBlockIdsBagKey(companyId, groupId, userId, name);
        return (ResourceBlockIdsBag)_resourceBlockIdsBagCache.get((Serializable)resourceBlockIdsBagKey);
    }

    public static UserPermissionCheckerBag getUserBag(long userId) {
        return (UserPermissionCheckerBag)_userPermissionCheckerBagPortalCache.get((Serializable)Long.valueOf(userId));
    }

    public static void putBag(long userId, long groupId, PermissionCheckerBag bag) {
        if (bag == null) {
            return;
        }
        BagKey bagKey = new BagKey(userId, groupId);
        _permissionCheckerBagPortalCache.put((Serializable)bagKey, (Object)bag);
    }

    public static void putPermission(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId, Boolean value) {
        PermissionKey permissionKey = new PermissionKey(userId, signedIn, groupId, name, primKey, actionId);
        _permissionPortalCache.put((Serializable)permissionKey, (Object)value);
    }

    public static void putResourceBlockIdsBag(long companyId, long groupId, long userId, String name, ResourceBlockIdsBag resourceBlockIdsBag) {
        if (resourceBlockIdsBag == null) {
            return;
        }
        ResourceBlockIdsBagKey resourceBlockIdsBagKey = new ResourceBlockIdsBagKey(companyId, groupId, userId, name);
        _resourceBlockIdsBagCache.put((Serializable)resourceBlockIdsBagKey, (Object)resourceBlockIdsBag);
    }

    public static void putUserBag(long userId, UserPermissionCheckerBag userPermissionCheckerBag) {
        _userPermissionCheckerBagPortalCache.put((Serializable)Long.valueOf(userId), (Object)userPermissionCheckerBag);
    }

    private static class ResourceBlockIdsBagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _companyId;
        private final long _groupId;
        private final String _name;
        private final long _userId;

        public ResourceBlockIdsBagKey(long companyId, long groupId, long userId, String name) {
            this._companyId = companyId;
            this._groupId = groupId;
            this._userId = userId;
            this._name = name;
        }

        public boolean equals(Object obj) {
            ResourceBlockIdsBagKey resourceBlockIdsKey = (ResourceBlockIdsBagKey)obj;
            return resourceBlockIdsKey._companyId == this._companyId && resourceBlockIdsKey._groupId == this._groupId && resourceBlockIdsKey._userId == this._userId && Validator.equals((Object)resourceBlockIdsKey._name, (Object)this._name);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._companyId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            return hashCode;
        }
    }

    private static class PermissionKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _actionId;
        private final long _groupId;
        private final String _name;
        private final String _primKey;
        private final boolean _signedIn;
        private final long _userId;

        public PermissionKey(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId) {
            this._userId = userId;
            this._signedIn = signedIn;
            this._groupId = groupId;
            this._name = name;
            this._primKey = primKey;
            this._actionId = actionId;
        }

        public boolean equals(Object obj) {
            PermissionKey permissionKey = (PermissionKey)obj;
            return permissionKey._userId == this._userId && permissionKey._signedIn == this._signedIn && permissionKey._groupId == this._groupId && Validator.equals((Object)permissionKey._name, (Object)this._name) && Validator.equals((Object)permissionKey._primKey, (Object)this._primKey) && Validator.equals((Object)permissionKey._actionId, (Object)this._actionId);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._signedIn);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primKey);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._actionId);
            return hashCode;
        }
    }

    private static class BagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _groupId;
        private final long _userId;

        public BagKey(long userId, long groupId) {
            this._userId = userId;
            this._groupId = groupId;
        }

        public boolean equals(Object obj) {
            BagKey bagKey = (BagKey)obj;
            return bagKey._userId == this._userId && bagKey._groupId == this._groupId;
        }

        public int hashCode() {
            return (int)(this._userId * 11L + this._groupId);
        }
    }
}

