/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.dao.shard.ShardUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.ldap.LDAPUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.ldap.AttributesTransformer;
import com.liferay.portal.security.ldap.AttributesTransformerFactory;
import com.liferay.portal.security.ldap.LDAPGroup;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.ldap.LDAPToPortalConverter;
import com.liferay.portal.security.ldap.LDAPUser;
import com.liferay.portal.security.ldap.LDAPUserGroupTransactionThreadLocal;
import com.liferay.portal.security.ldap.LDAPUserTransactionThreadLocal;
import com.liferay.portal.security.ldap.PortalLDAPImporter;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.ldap.PortalLDAPUtil;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LockLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.service.ExpandoValueLocalServiceUtil;
import com.liferay.portlet.expando.util.ExpandoConverterUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;

@DoPrivileged
public class PortalLDAPImporterImpl
implements PortalLDAPImporter {
    private static final String[] _CONTACT_PROPERTY_NAMES = new String[]{"aimSn", "birthday", "employeeNumber", "facebookSn", "icqSn", "jabberSn", "male", "msnSn", "mySpaceSn", "prefixId", "skypeSn", "smsSn", "suffixId", "twitterSn", "ymSn"};
    private static final String _IMPORT_BY_GROUP = "group";
    private static final String _IMPORT_BY_USER = "user";
    private static final String _USER_PASSWORD_SCREEN_NAME = "screenName";
    private static final String[] _USER_PROPERTY_NAMES = new String[]{"comments", "firstName", "greeting", "jobTitle", "languageId", "lastName", "middleName", "openId", "timeZoneId"};
    private static Log _log = LogFactoryUtil.getLog(PortalLDAPImporterImpl.class);
    private LDAPToPortalConverter _ldapToPortalConverter;
    private Set<String> _ldapUserIgnoreAttributes = SetUtil.fromArray((Object[])PropsValues.LDAP_USER_IGNORE_ATTRIBUTES);
    private PortalCache<String, Long> _portalCache = SingleVMPoolUtil.getCache((String)PortalLDAPImporter.class.getName(), (boolean)false);

    public void importFromLDAP() throws Exception {
        List companies = CompanyLocalServiceUtil.getCompanies((boolean)false);
        for (Company company : companies) {
            this.importFromLDAP(company.getCompanyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromLDAP(long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        try {
            long[] ldapServerIds;
            ShardUtil.pushCompanyService((long)companyId);
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            if (LockLocalServiceUtil.hasLock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping LDAP import for company " + companyId + " because another LDAP import is in process"));
                }
                return;
            }
            LockLocalServiceUtil.lock((long)defaultUserId, (String)PortalLDAPImporterUtil.class.getName(), (long)companyId, (String)PortalLDAPImporterImpl.class.getName(), (boolean)false, (long)PropsValues.LDAP_IMPORT_LOCK_EXPIRATION_TIME);
            for (long ldapServerId : ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L)) {
                this.importFromLDAP(ldapServerId, companyId);
            }
            int ldapServerId = 0;
            while (true) {
                String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
                String providerUrl = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + postfix);
                if (Validator.isNull((String)providerUrl)) {
                    break;
                }
                this.importFromLDAP(ldapServerId, companyId);
                ++ldapServerId;
            }
        }
        finally {
            LockLocalServiceUtil.unlock((String)PortalLDAPImporterUtil.class.getName(), (long)companyId);
            ShardUtil.popCompanyService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromLDAP(long ldapServerId, long companyId) throws Exception {
        if (!LDAPSettingsUtil.isImportEnabled(companyId)) {
            return;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        if (ldapContext == null) {
            return;
        }
        try {
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
            Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
            Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
            Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
            String importMethod = PrefsPropsUtil.getString(companyId, "ldap.import.method");
            if (importMethod.equals(_IMPORT_BY_GROUP)) {
                this.importFromLDAPByGroup(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
            } else if (importMethod.equals(_IMPORT_BY_USER)) {
                this.importFromLDAPByUser(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, groupMappings);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error importing LDAP users and groups", (Throwable)e);
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importLDAPUser(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, String password) throws Exception {
        Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
        Properties userExpandoMappings = LDAPSettingsUtil.getUserExpandoMappings(ldapServerId, companyId);
        Properties contactMappings = LDAPSettingsUtil.getContactMappings(ldapServerId, companyId);
        Properties contactExpandoMappings = LDAPSettingsUtil.getContactExpandoMappings(ldapServerId, companyId);
        User user = this.importUser(ldapServerId, companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
        Properties groupMappings = LDAPSettingsUtil.getGroupMappings(ldapServerId, companyId);
        this.importGroups(ldapServerId, companyId, ldapContext, attributes, user, userMappings, groupMappings);
        return user;
    }

    public User importLDAPUser(long ldapServerId, long companyId, String emailAddress, String screenName) throws Exception {
        Context ldapContext = null;
        NamingEnumeration<SearchResult> enu = null;
        try {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
            if (ldapContext == null) {
                _log.error((Object)"Unable to bind to the LDAP server");
                User user = null;
                return user;
            }
            String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter before transformation " + filter));
            }
            filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName});
            LDAPUtil.validateFilter((String)filter);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Search filter after transformation " + filter));
            }
            Properties userMappings = LDAPSettingsUtil.getUserMappings(ldapServerId, companyId);
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            SearchControls searchControls = new SearchControls(2, 1L, 0, new String[]{userMappingsScreenName}, false, false);
            enu = ldapContext.search(baseDN, filter, searchControls);
            if (enu.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Search filter returned at least one result");
                }
                Binding binding = (Binding)enu.nextElement();
                Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, (LdapContext)ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding));
                User user = this.importLDAPUser(ldapServerId, companyId, (LdapContext)ldapContext, attributes, "");
                return user;
            }
            User user = null;
            return user;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Problem accessing LDAP server " + e.getMessage()));
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            throw new SystemException("Problem accessing LDAP server " + e.getMessage());
        }
        finally {
            if (enu != null) {
                enu.close();
            }
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
    }

    public User importLDAPUser(long companyId, String emailAddress, String screenName) throws Exception {
        long[] ldapServerIds;
        for (long ldapServerId : ldapServerIds = StringUtil.split((String)PrefsPropsUtil.getString(companyId, "ldap.server.ids"), (long)0L)) {
            User user = this.importLDAPUser(ldapServerId, companyId, emailAddress, screenName);
            if (user == null) continue;
            return user;
        }
        int ldapServerId = 0;
        while (true) {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String providerUrl = PrefsPropsUtil.getString(companyId, "ldap.base.provider.url" + postfix);
            if (Validator.isNull((String)providerUrl)) break;
            User user = this.importLDAPUser(ldapServerId, companyId, emailAddress, screenName);
            if (user != null) {
                return user;
            }
            ++ldapServerId;
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNotNull((String)emailAddress)) {
                _log.debug((Object)("User with the email address " + emailAddress + " was not found in any LDAP servers"));
            } else {
                _log.debug((Object)("User with the screen name " + screenName + " was not found in any LDAP servers"));
            }
        }
        return null;
    }

    public User importLDAPUserByScreenName(long companyId, String screenName) throws Exception {
        long ldapServerId = PortalLDAPUtil.getLdapServerId(companyId, screenName, "");
        SearchResult result = (SearchResult)PortalLDAPUtil.getUser(ldapServerId, companyId, screenName, "");
        if (result == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No user was found in LDAP with screenName " + screenName));
            }
            return null;
        }
        LdapContext ldapContext = PortalLDAPUtil.getContext(ldapServerId, companyId);
        String fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, result);
        Attributes attributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
        User user = this.importLDAPUser(ldapServerId, companyId, ldapContext, attributes, "");
        ldapContext.close();
        return user;
    }

    public void setLDAPToPortalConverter(LDAPToPortalConverter ldapToPortalConverter) {
        this._ldapToPortalConverter = ldapToPortalConverter;
    }

    protected void addRole(long companyId, LDAPGroup ldapGroup, UserGroup userGroup) throws Exception {
        if (!PropsValues.LDAP_IMPORT_CREATE_ROLE_PER_GROUP) {
            return;
        }
        Role role = null;
        try {
            role = RoleLocalServiceUtil.getRole((long)companyId, (String)ldapGroup.getGroupName());
        }
        catch (NoSuchRoleException nsre) {
            User defaultUser = UserLocalServiceUtil.getDefaultUser((long)companyId);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), "Autogenerated role from LDAP import");
            role = RoleLocalServiceUtil.addRole((long)defaultUser.getUserId(), null, (long)0L, (String)ldapGroup.getGroupName(), null, descriptionMap, (int)1, null, null);
        }
        Group group = userGroup.getGroup();
        if (GroupLocalServiceUtil.hasRoleGroup((long)role.getRoleId(), (long)group.getGroupId())) {
            return;
        }
        GroupLocalServiceUtil.addRoleGroups((long)role.getRoleId(), (long[])new long[]{group.getGroupId()});
    }

    protected User addUser(long companyId, LDAPUser ldapUser, String password) throws Exception {
        byte[] portraitBytes;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user " + ldapUser.getEmailAddress()));
        }
        boolean autoPassword = ldapUser.isAutoPassword();
        if (!PropsValues.LDAP_IMPORT_USER_PASSWORD_ENABLED) {
            boolean bl = autoPassword = PropsValues.LDAP_IMPORT_USER_PASSWORD_AUTOGENERATED && !PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK;
            if (!autoPassword) {
                String defaultPassword = PropsValues.LDAP_IMPORT_USER_PASSWORD_DEFAULT;
                if (StringUtil.equalsIgnoreCase((String)defaultPassword, (String)_USER_PASSWORD_SCREEN_NAME)) {
                    defaultPassword = ldapUser.getScreenName();
                }
                password = defaultPassword;
            }
        }
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapUser.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        User user = UserLocalServiceUtil.addUser((long)ldapUser.getCreatorUserId(), (long)companyId, (boolean)autoPassword, (String)password, (String)password, (boolean)ldapUser.isAutoScreenName(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)0L, (String)"", (Locale)ldapUser.getLocale(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)0, (int)0, (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)"", (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (long[])ldapUser.getUserGroupIds(), (boolean)ldapUser.isSendEmail(), (ServiceContext)ldapUser.getServiceContext());
        if (ldapUser.isUpdatePortrait() && ArrayUtil.isNotEmpty((byte[])(portraitBytes = ldapUser.getPortraitBytes()))) {
            user = UserLocalServiceUtil.updatePortrait((long)user.getUserId(), (byte[])portraitBytes);
        }
        return user;
    }

    protected void addUserGroupsNotAddedByLDAPImport(long userId, Set<Long> userGroupIds) throws Exception {
        List userGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)userId);
        for (UserGroup userGroup : userGroups) {
            if (userGroup.isAddedByLDAPImport()) continue;
            userGroupIds.add(userGroup.getUserGroupId());
        }
    }

    protected String escapeValue(String value) {
        return StringUtil.replace((String)value, (String)"\\,", (String)"\\\\,");
    }

    protected User getUser(long companyId, LDAPUser ldapUser) throws Exception {
        User user = null;
        String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
        user = authType.equals(_USER_PASSWORD_SCREEN_NAME) && !ldapUser.isAutoScreenName() ? UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)ldapUser.getScreenName()) : UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)ldapUser.getEmailAddress());
        return user;
    }

    protected Attribute getUsers(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, UserGroup userGroup, Properties groupMappings) throws Exception {
        Attribute attribute = attributes.get(groupMappings.getProperty(_IMPORT_BY_USER));
        if (attribute == null) {
            return null;
        }
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
        StringBundler sb = new StringBundler(7);
        sb.append("(&");
        String importGroupSearchFilter = PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix);
        LDAPUtil.validateFilter((String)importGroupSearchFilter, (String)("ldap.import.group.search.filter" + postfix));
        sb.append(importGroupSearchFilter);
        sb.append("(");
        sb.append(groupMappings.getProperty("groupName"));
        sb.append("=");
        sb.append(this.escapeValue(userGroup.getName()));
        sb.append("))");
        return PortalLDAPUtil.getMultivaluedAttribute(companyId, ldapContext, baseDN, sb.toString(), attribute);
    }

    protected void importFromLDAPByGroup(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
            groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
            cookie = PortalLDAPUtil.getGroups(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{groupMappingsGroupName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes attributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult), true);
                    UserGroup userGroup = this.importUserGroup(companyId, attributes, groupMappings);
                    Attribute usersAttribute = this.getUsers(ldapServerId, companyId, ldapContext, attributes, userGroup, groupMappings);
                    if (usersAttribute == null) {
                        if (!_log.isInfoEnabled()) continue;
                        _log.info((Object)("No users found in " + userGroup.getName()));
                        continue;
                    }
                    this.importUsers(ldapServerId, companyId, ldapContext, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, userGroup.getUserGroupId(), usersAttribute);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import group " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected void importFromLDAPByUser(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, Properties groupMappings) throws Exception {
        byte[] cookie = new byte[]{};
        while (cookie != null) {
            ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
            String userMappingsScreenName = GetterUtil.getString((String)userMappings.getProperty(_USER_PASSWORD_SCREEN_NAME));
            userMappingsScreenName = StringUtil.toLowerCase((String)userMappingsScreenName);
            cookie = PortalLDAPUtil.getUsers(ldapServerId, companyId, ldapContext, cookie, 0, new String[]{userMappingsScreenName}, searchResults);
            for (SearchResult searchResult : searchResults) {
                try {
                    Attributes userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult));
                    User user = this.importUser(ldapServerId, companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                    this.importGroups(ldapServerId, companyId, ldapContext, userAttributes, user, userMappings, groupMappings);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to import user " + searchResult), (Throwable)e);
                }
            }
        }
    }

    protected Set<Long> importGroup(long ldapServerId, long companyId, LdapContext ldapContext, String fullGroupDN, User user, Properties groupMappings, Set<Long> newUserGroupIds) throws Exception {
        String userGroupIdKey = null;
        Long userGroupId = null;
        if (PropsValues.LDAP_IMPORT_GROUP_CACHE_ENABLED) {
            StringBundler sb = new StringBundler(5);
            sb.append(ldapServerId);
            sb.append("_");
            sb.append(companyId);
            sb.append("_");
            sb.append(fullGroupDN);
            userGroupIdKey = sb.toString();
            userGroupId = (Long)this._portalCache.get((Serializable)((Object)userGroupIdKey));
        }
        if (userGroupId != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping reimport of full group DN " + fullGroupDN));
            }
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Importing full group DN " + fullGroupDN));
            }
            Attributes groupAttributes = null;
            try {
                groupAttributes = PortalLDAPUtil.getGroupAttributes(ldapServerId, companyId, ldapContext, fullGroupDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP group not found with full group DN " + fullGroupDN), (Throwable)nnfe);
            }
            UserGroup userGroup = this.importUserGroup(companyId, groupAttributes, groupMappings);
            if (userGroup == null) {
                return newUserGroupIds;
            }
            userGroupId = userGroup.getUserGroupId();
            if (PropsValues.LDAP_IMPORT_GROUP_CACHE_ENABLED) {
                this._portalCache.put((Serializable)((Object)userGroupIdKey), (Object)userGroupId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
        }
        newUserGroupIds.add(userGroupId);
        return newUserGroupIds;
    }

    protected void importGroups(long ldapServerId, long companyId, LdapContext ldapContext, Attributes attributes, User user, Properties userMappings, Properties groupMappings) throws Exception {
        String groupMappingsUser = groupMappings.getProperty(_IMPORT_BY_USER);
        Set<Long> newUserGroupIds = new LinkedHashSet<Long>();
        if (Validator.isNotNull((String)groupMappingsUser) && PrefsPropsUtil.getBoolean(companyId, "ldap.import.group.search.filter.enabled")) {
            String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
            String baseDN = PrefsPropsUtil.getString(companyId, "ldap.base.dn" + postfix);
            StringBundler sb = new StringBundler(9);
            sb.append("(");
            sb.append("&");
            String importGroupSearchFilter = PrefsPropsUtil.getString(companyId, "ldap.import.group.search.filter" + postfix);
            LDAPUtil.validateFilter((String)importGroupSearchFilter, (String)("ldap.import.group.search.filter" + postfix));
            sb.append(importGroupSearchFilter);
            sb.append("(");
            sb.append(groupMappingsUser);
            sb.append("=");
            Binding binding = PortalLDAPUtil.getUser(ldapServerId, companyId, user.getScreenName(), user.getEmailAddress());
            String fullUserDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, binding);
            sb.append(this.escapeValue(fullUserDN));
            sb.append(")");
            sb.append(")");
            byte[] cookie = new byte[]{};
            while (cookie != null) {
                ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
                String groupMappingsGroupName = GetterUtil.getString((String)groupMappings.getProperty("groupName"));
                groupMappingsGroupName = StringUtil.toLowerCase((String)groupMappingsGroupName);
                cookie = PortalLDAPUtil.searchLDAP(companyId, ldapContext, cookie, 0, baseDN, sb.toString(), new String[]{groupMappingsGroupName}, searchResults);
                for (SearchResult searchResult : searchResults) {
                    String fullGroupDN = PortalLDAPUtil.getNameInNamespace(ldapServerId, companyId, searchResult);
                    newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
                }
            }
        } else {
            String userMappingsGroup = userMappings.getProperty(_IMPORT_BY_GROUP);
            if (Validator.isNull((String)userMappingsGroup)) {
                return;
            }
            Attribute userGroupAttribute = attributes.get(userMappingsGroup);
            if (userGroupAttribute == null) {
                return;
            }
            for (int i = 0; i < userGroupAttribute.size(); ++i) {
                String fullGroupDN = (String)userGroupAttribute.get(i);
                newUserGroupIds = this.importGroup(ldapServerId, companyId, ldapContext, fullGroupDN, user, groupMappings, newUserGroupIds);
            }
        }
        this.addUserGroupsNotAddedByLDAPImport(user.getUserId(), newUserGroupIds);
        LinkedHashSet<Long> oldUserGroupIds = new LinkedHashSet<Long>();
        List oldUserGroups = UserGroupLocalServiceUtil.getUserUserGroups((long)user.getUserId());
        for (UserGroup oldUserGroup : oldUserGroups) {
            oldUserGroupIds.add(oldUserGroup.getUserGroupId());
        }
        if (!oldUserGroupIds.equals(newUserGroupIds)) {
            long[] userGroupIds = ArrayUtil.toLongArray(newUserGroupIds);
            UserGroupLocalServiceUtil.setUserUserGroups((long)user.getUserId(), (long[])userGroupIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User importUser(long ldapServerId, long companyId, Attributes attributes, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, String password) throws Exception {
        LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(true);
        try {
            AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
            attributes = attributesTransformer.transformUser(attributes);
            LDAPUser ldapUser = this._ldapToPortalConverter.importLDAPUser(companyId, attributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, password);
            User user = this.getUser(companyId, ldapUser);
            if (user != null && user.isDefaultUser()) {
                User user2 = user;
                return user2;
            }
            ServiceContext serviceContext = ldapUser.getServiceContext();
            serviceContext.setAttribute("ldapServerId", (Serializable)Long.valueOf(ldapServerId));
            boolean isNew = false;
            if (user == null) {
                user = this.addUser(companyId, ldapUser, password);
                isNew = true;
            }
            String modifiedDate = LDAPUtil.getAttributeString((Attributes)attributes, (String)"modifyTimestamp");
            user = this.updateUser(companyId, ldapUser, user, userMappings, contactMappings, password, modifiedDate, isNew);
            this.updateExpandoAttributes(user, ldapUser, userExpandoMappings, contactExpandoMappings);
            User user3 = user;
            return user3;
        }
        finally {
            LDAPUserTransactionThreadLocal.setOriginatesFromLDAP(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserGroup importUserGroup(long companyId, Attributes attributes, Properties groupMappings) throws Exception {
        AttributesTransformer attributesTransformer = AttributesTransformerFactory.getInstance();
        attributes = attributesTransformer.transformGroup(attributes);
        LDAPGroup ldapGroup = this._ldapToPortalConverter.importLDAPGroup(companyId, attributes, groupMappings);
        UserGroup userGroup = null;
        try {
            userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)ldapGroup.getGroupName());
            if (!Validator.equals((Object)userGroup.getDescription(), (Object)ldapGroup.getDescription())) {
                UserGroupLocalServiceUtil.updateUserGroup((long)companyId, (long)userGroup.getUserGroupId(), (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription(), null);
            }
        }
        catch (NoSuchUserGroupException nsuge) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding user group to portal " + ldapGroup.getGroupName()));
            }
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(true);
            try {
                userGroup = UserGroupLocalServiceUtil.addUserGroup((long)defaultUserId, (long)companyId, (String)ldapGroup.getGroupName(), (String)ldapGroup.getDescription(), null);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to create user group " + ldapGroup.getGroupName()));
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            finally {
                LDAPUserGroupTransactionThreadLocal.setOriginatesFromLDAP(false);
            }
        }
        this.addRole(companyId, ldapGroup, userGroup);
        return userGroup;
    }

    protected void importUsers(long ldapServerId, long companyId, LdapContext ldapContext, Properties userMappings, Properties userExpandoMappings, Properties contactMappings, Properties contactExpandoMappings, long userGroupId, Attribute attribute) throws Exception {
        LinkedHashSet<Long> newUserIds = new LinkedHashSet<Long>(attribute.size());
        for (int i = 0; i < attribute.size(); ++i) {
            String fullUserDN = (String)attribute.get(i);
            Attributes userAttributes = null;
            try {
                userAttributes = PortalLDAPUtil.getUserAttributes(ldapServerId, companyId, ldapContext, fullUserDN);
            }
            catch (NameNotFoundException nnfe) {
                _log.error((Object)("LDAP user not found with fullUserDN " + fullUserDN), (Throwable)nnfe);
                continue;
            }
            try {
                User user = this.importUser(ldapServerId, companyId, userAttributes, userMappings, userExpandoMappings, contactMappings, contactExpandoMappings, "");
                if (user == null) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Adding " + user.getUserId() + " to group " + userGroupId));
                }
                UserLocalServiceUtil.addUserGroupUsers((long)userGroupId, (long[])new long[]{user.getUserId()});
                newUserIds.add(user.getUserId());
                continue;
            }
            catch (Exception e) {
                _log.error((Object)("Unable to load user " + userAttributes), (Throwable)e);
            }
        }
        List userGroupUsers = UserLocalServiceUtil.getUserGroupUsers((long)userGroupId);
        for (User user : userGroupUsers) {
            if (newUserIds.contains(user.getUserId())) continue;
            UserLocalServiceUtil.deleteUserGroupUser((long)userGroupId, (long)user.getUserId());
        }
    }

    protected void populateExpandoAttributes(ExpandoBridge expandoBridge, Map<String, String[]> expandoAttributes, Properties expandoMappings) {
        block5: {
            HashMap<String, Serializable> serializedExpandoAttributes = new HashMap<String, Serializable>();
            for (Map.Entry<String, String[]> expandoAttribute : expandoAttributes.entrySet()) {
                String name = expandoAttribute.getKey();
                if (!expandoBridge.hasAttribute(name) || !expandoMappings.containsKey(name) || this._ldapUserIgnoreAttributes.contains(name)) continue;
                int type = expandoBridge.getAttributeType(name);
                Serializable value = ExpandoConverterUtil.getAttributeFromStringArray(type, expandoAttribute.getValue());
                serializedExpandoAttributes.put(name, value);
            }
            if (serializedExpandoAttributes.isEmpty()) {
                return;
            }
            try {
                ExpandoValueLocalServiceUtil.addValues((long)expandoBridge.getCompanyId(), (String)expandoBridge.getClassName(), (String)"CUSTOM_FIELDS", (long)expandoBridge.getClassPK(), serializedExpandoAttributes);
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to populate expando attributes");
                }
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    protected void setProperty(Object bean1, Object bean2, String propertyName) {
        Object value = BeanPropertiesUtil.getObject((Object)bean2, (String)propertyName);
        BeanPropertiesUtil.setProperty((Object)bean1, (String)propertyName, (Object)value);
    }

    protected void updateExpandoAttributes(User user, LDAPUser ldapUser, Properties userExpandoMappings, Properties contactExpandoMappings) throws Exception {
        ExpandoBridge userExpandoBridge = user.getExpandoBridge();
        this.populateExpandoAttributes(userExpandoBridge, ldapUser.getUserExpandoAttributes(), userExpandoMappings);
        Contact contact = user.getContact();
        ExpandoBridge contactExpandoBridge = contact.getExpandoBridge();
        this.populateExpandoAttributes(contactExpandoBridge, ldapUser.getContactExpandoAttributes(), contactExpandoMappings);
    }

    protected void updateLDAPUser(User ldapUser, Contact ldapContact, User user, Properties userMappings, Properties contactMappings) throws PortalException {
        Contact contact = user.getContact();
        for (String propertyName : _CONTACT_PROPERTY_NAMES) {
            if (contactMappings.containsKey(propertyName) && !this._ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this.setProperty(ldapContact, contact, propertyName);
        }
        for (String propertyName : _USER_PROPERTY_NAMES) {
            if (userMappings.containsKey(propertyName) && !this._ldapUserIgnoreAttributes.contains(propertyName)) continue;
            this.setProperty(ldapUser, user, propertyName);
        }
    }

    protected User updateUser(long companyId, LDAPUser ldapUser, User user, Properties userMappings, Properties contactMappings, String password, String modifiedDate, boolean isNew) throws Exception {
        boolean passwordReset;
        Date ldapUserModifiedDate;
        block15: {
            ldapUserModifiedDate = null;
            passwordReset = ldapUser.isPasswordReset();
            if (PrefsPropsUtil.getBoolean(companyId, "ldap.export.enabled", PropsValues.LDAP_EXPORT_ENABLED)) {
                passwordReset = user.isPasswordReset();
            }
            try {
                if (Validator.isNotNull((String)modifiedDate)) {
                    ldapUserModifiedDate = LDAPUtil.parseDate((String)modifiedDate);
                    if (ldapUserModifiedDate.equals(user.getModifiedDate())) {
                        if (ldapUser.isAutoPassword()) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Object)("Skipping user " + user.getEmailAddress() + " because he is already synchronized"));
                            }
                            return user;
                        }
                        UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)password, (String)password, (boolean)passwordReset, (boolean)true);
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("User " + user.getEmailAddress() + " is already synchronized, but updated " + "password to avoid a blank value"));
                        }
                        return user;
                    }
                } else if (!isNew) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Skipping user " + user.getEmailAddress() + " because the LDAP entry was never modified"));
                    }
                    return user;
                }
            }
            catch (ParseException pe) {
                if (!_log.isDebugEnabled()) break block15;
                _log.debug((Object)("Unable to parse LDAP modify timestamp " + modifiedDate), (Throwable)pe);
            }
        }
        if (!PropsValues.LDAP_IMPORT_USER_PASSWORD_ENABLED && StringUtil.equalsIgnoreCase((String)(password = PropsValues.LDAP_IMPORT_USER_PASSWORD_DEFAULT), (String)_USER_PASSWORD_SCREEN_NAME)) {
            password = ldapUser.getScreenName();
        }
        if (Validator.isNull((String)ldapUser.getScreenName()) || ldapUser.isAutoScreenName()) {
            ldapUser.setScreenName(user.getScreenName());
        }
        if (ldapUser.isUpdatePassword()) {
            UserLocalServiceUtil.updatePassword((long)user.getUserId(), (String)password, (String)password, (boolean)passwordReset, (boolean)true);
        }
        Contact ldapContact = ldapUser.getContact();
        this.updateLDAPUser(ldapUser.getUser(), ldapContact, user, userMappings, contactMappings);
        Calendar birthdayCal = CalendarFactoryUtil.getCalendar();
        birthdayCal.setTime(ldapContact.getBirthday());
        int birthdayMonth = birthdayCal.get(2);
        int birthdayDay = birthdayCal.get(5);
        int birthdayYear = birthdayCal.get(1);
        user = UserLocalServiceUtil.updateUser((long)user.getUserId(), (String)password, (String)"", (String)"", (boolean)passwordReset, (String)ldapUser.getReminderQueryQuestion(), (String)ldapUser.getReminderQueryAnswer(), (String)ldapUser.getScreenName(), (String)ldapUser.getEmailAddress(), (long)ldapUser.getFacebookId(), (String)ldapUser.getOpenId(), (ldapUser.getPortraitId() > 0L ? 1 : 0) != 0, (byte[])ldapUser.getPortraitBytes(), (String)ldapUser.getLanguageId(), (String)ldapUser.getTimeZoneId(), (String)ldapUser.getGreeting(), (String)ldapUser.getComments(), (String)ldapUser.getFirstName(), (String)ldapUser.getMiddleName(), (String)ldapUser.getLastName(), (int)ldapUser.getPrefixId(), (int)ldapUser.getSuffixId(), (boolean)ldapUser.isMale(), (int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, (String)ldapUser.getSmsSn(), (String)ldapUser.getAimSn(), (String)ldapUser.getFacebookSn(), (String)ldapUser.getIcqSn(), (String)ldapUser.getJabberSn(), (String)ldapUser.getMsnSn(), (String)ldapUser.getMySpaceSn(), (String)ldapUser.getSkypeSn(), (String)ldapUser.getTwitterSn(), (String)ldapUser.getYmSn(), (String)ldapUser.getJobTitle(), (long[])ldapUser.getGroupIds(), (long[])ldapUser.getOrganizationIds(), (long[])ldapUser.getRoleIds(), (List)ldapUser.getUserGroupRoles(), (long[])ldapUser.getUserGroupIds(), (ServiceContext)ldapUser.getServiceContext());
        if (ldapUserModifiedDate != null) {
            user = UserLocalServiceUtil.updateModifiedDate((long)user.getUserId(), (Date)ldapUserModifiedDate);
        }
        user = UserLocalServiceUtil.updateStatus((long)user.getUserId(), (int)ldapUser.getStatus(), (ServiceContext)new ServiceContext());
        return user;
    }
}

