/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ldap;

import com.liferay.portal.kernel.ldap.LDAPUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Properties;

public class LDAPSettingsUtil {
    private static Log _log = LogFactoryUtil.getLog(LDAPSettingsUtil.class);

    public static String getAuthSearchFilter(long ldapServerId, long companyId, String emailAddress, String screenName, String userId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        String filter = PrefsPropsUtil.getString(companyId, "ldap.auth.search.filter" + postfix);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter before transformation " + filter));
        }
        filter = StringUtil.replace((String)filter, (String[])new String[]{"@company_id@", "@email_address@", "@screen_name@", "@user_id@"}, (String[])new String[]{String.valueOf(companyId), emailAddress, screenName, userId});
        LDAPUtil.validateFilter((String)filter);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search filter after transformation " + filter));
        }
        return filter;
    }

    public static Properties getContactExpandoMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Properties contactExpandoMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.contact.custom.mappings" + postfix, ""));
        LogUtil.debug((Log)_log, (Properties)contactExpandoMappings);
        return contactExpandoMappings;
    }

    public static Properties getContactMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Properties contactMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.contact.mappings" + postfix, ""));
        LogUtil.debug((Log)_log, (Properties)contactMappings);
        return contactMappings;
    }

    public static Properties getGroupMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Properties groupMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.group.mappings" + postfix, ""));
        LogUtil.debug((Log)_log, (Properties)groupMappings);
        return groupMappings;
    }

    public static long getPreferredLDAPServerId(long companyId, String screenName) {
        User user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName);
        if (user == null) {
            return -1L;
        }
        return user.getLdapServerId();
    }

    public static String getPropertyPostfix(long ldapServerId) {
        return "." + ldapServerId;
    }

    public static Properties getUserExpandoMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Properties userExpandoMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.user.custom.mappings" + postfix, ""));
        LogUtil.debug((Log)_log, (Properties)userExpandoMappings);
        return userExpandoMappings;
    }

    public static Properties getUserMappings(long ldapServerId, long companyId) throws Exception {
        String postfix = LDAPSettingsUtil.getPropertyPostfix(ldapServerId);
        Properties userMappings = PropertiesUtil.load((String)PrefsPropsUtil.getString(companyId, "ldap.user.mappings" + postfix, ""));
        LogUtil.debug((Log)_log, (Properties)userMappings);
        return userMappings;
    }

    public static boolean isExportEnabled(long companyId) {
        if (LDAPSettingsUtil.isImportEnabled(companyId) && PropsValues.LDAP_IMPORT_USER_PASSWORD_AUTOGENERATED) {
            return false;
        }
        return PrefsPropsUtil.getBoolean(companyId, "ldap.export.enabled", PropsValues.LDAP_EXPORT_ENABLED);
    }

    public static boolean isExportGroupEnabled(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.export.group.enabled", PropsValues.LDAP_EXPORT_GROUP_ENABLED);
    }

    public static boolean isImportEnabled(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.import.enabled", PropsValues.LDAP_IMPORT_ENABLED);
    }

    public static boolean isImportOnStartup(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.import.on.startup");
    }

    public static boolean isPasswordPolicyEnabled(long companyId) {
        return PrefsPropsUtil.getBoolean(companyId, "ldap.password.policy.enabled", PropsValues.LDAP_PASSWORD_POLICY_ENABLED);
    }
}

