/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.security.auth.RemoteAuthException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@OSGiBeanProperties(portalPropertyPrefix="auth.verifier.TunnelingServletAuthVerifier.")
public class TunnelingServletAuthVerifier
implements AuthVerifier {
    private static Log _log = LogFactoryUtil.getLog(TunnelingServletAuthVerifier.class);

    public String getAuthType() {
        return "BASIC";
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        try {
            String[] credentials = this.verify(accessControlContext.getRequest());
            if (credentials != null) {
                authVerifierResult.setPassword(credentials[1]);
                authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
                authVerifierResult.setUserId(Long.valueOf(credentials[0]).longValue());
            }
        }
        catch (AuthException ae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ae);
            }
            HttpServletResponse response = accessControlContext.getResponse();
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());){
                objectOutputStream.writeObject((Object)ae);
                authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
                throw ae;
            }
        }
        return authVerifierResult;
    }

    protected String[] verify(HttpServletRequest request) throws AuthException {
        User user;
        String password;
        block16: {
            int index;
            String authorization = request.getHeader("Authorization");
            if (authorization == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(authorization);
            if (!st.hasMoreTokens()) {
                return null;
            }
            String basic = st.nextToken();
            if (!StringUtil.equalsIgnoreCase((String)basic, (String)"BASIC")) {
                return null;
            }
            String encodedCredentials = st.nextToken();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Encoded credentials " + encodedCredentials));
            }
            String decodedCredentials = new String(Base64.decode((String)encodedCredentials));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Decoded credentials " + decodedCredentials));
            }
            if ((index = decodedCredentials.indexOf(58)) == -1) {
                return null;
            }
            String login = GetterUtil.getString((String)decodedCredentials.substring(0, index));
            password = decodedCredentials.substring(index + 1);
            String expectedPassword = null;
            try {
                expectedPassword = Encryptor.encrypt((Key)TunnelUtil.getSharedSecretKey(), (String)login);
            }
            catch (EncryptorException ee) {
                RemoteAuthException authException = new RemoteAuthException((Throwable)ee);
                authException.setType(1);
                throw authException;
            }
            catch (AuthException ae) {
                RemoteAuthException authException = new RemoteAuthException();
                authException.setType(ae.getType());
                throw authException;
            }
            if (!password.equals(expectedPassword)) {
                RemoteAuthException authException = new RemoteAuthException();
                authException.setType(101);
                throw authException;
            }
            user = null;
            try {
                Company company;
                user = UserLocalServiceUtil.fetchUser((long)GetterUtil.getLong((String)login));
                if (user == null && (user = UserLocalServiceUtil.fetchUserByEmailAddress((long)(company = PortalUtil.getCompany((HttpServletRequest)request)).getCompanyId(), (String)login)) == null) {
                    user = UserLocalServiceUtil.fetchUserByScreenName((long)company.getCompanyId(), (String)login);
                }
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Unable to find company", (Throwable)pe);
                }
            }
            catch (SystemException se) {
                if (!_log.isWarnEnabled()) break block16;
                _log.warn((Object)"Unable to find user", (Throwable)se);
            }
        }
        if (user == null) {
            RemoteAuthException authException = new RemoteAuthException();
            authException.setType(1);
            throw authException;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), password};
        return credentials;
    }
}

