/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteMinderAutoLogin
extends BaseAutoLogin {
    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        long companyId = company.getCompanyId();
        if (!PrefsPropsUtil.getBoolean(companyId, "siteminder.auth.enabled", PropsValues.SITEMINDER_AUTH_ENABLED)) {
            return null;
        }
        String siteMinderUserHeader = request.getHeader(PrefsPropsUtil.getString(companyId, "siteminder.user.header", PropsValues.SITEMINDER_USER_HEADER));
        if (Validator.isNull((String)siteMinderUserHeader)) {
            return null;
        }
        String authType = company.getAuthType();
        User user = null;
        if (PrefsPropsUtil.getBoolean(companyId, "siteminder.import.from.ldap", PropsValues.SITEMINDER_IMPORT_FROM_LDAP)) {
            try {
                user = authType.equals("emailAddress") ? PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)siteMinderUserHeader, (String)"") : PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)siteMinderUserHeader);
            }
            catch (SystemException se) {
                // empty catch block
            }
        }
        if (user == null) {
            user = authType.equals("emailAddress") ? UserLocalServiceUtil.fetchUserByEmailAddress((long)companyId, (String)siteMinderUserHeader) : UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)siteMinderUserHeader);
        }
        this.addRedirect(request);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }
}

