/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHeaderAutoLogin
extends BaseAutoLogin {
    private static Log _log = LogFactoryUtil.getLog(RequestHeaderAutoLogin.class);
    private Set<String> _hostsAllowed = new HashSet<String>();

    public RequestHeaderAutoLogin() {
        String[] hostsAllowedArray = PropsUtil.getArray("request.header.auth.hosts.allowed");
        for (int i = 0; i < hostsAllowedArray.length; ++i) {
            this._hostsAllowed.add(hostsAllowedArray[i]);
        }
    }

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String remoteAddr = request.getRemoteAddr();
        if (SSOUtil.isAccessAllowed(request, this._hostsAllowed)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Access allowed for " + remoteAddr));
            }
        } else {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Access denied for " + remoteAddr));
            }
            return null;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        String screenName = request.getHeader("LIFERAY_SCREEN_NAME");
        if (Validator.isNull((String)screenName)) {
            return null;
        }
        User user = null;
        if (PrefsPropsUtil.getBoolean(companyId, "request.header.auth.import.from.ldap", PropsValues.REQUEST_HEADER_AUTH_IMPORT_FROM_LDAP)) {
            try {
                user = PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)screenName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (user == null) {
            user = UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)screenName);
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }
}

