/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@OSGiBeanProperties(portalPropertyPrefix="auth.verifier.ParameterAutoLogin.")
public class ParameterAutoLogin
extends BaseAutoLogin {
    private static final String _LOGIN_PARAM = "parameterAutoLoginLogin";
    private static final String _PASSWORD_PARAM = "parameterAutoLoginPassword";

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String login = ParamUtil.getString((HttpServletRequest)request, (String)this.getLoginParam());
        if (Validator.isNull((String)login)) {
            return null;
        }
        String password = ParamUtil.getString((HttpServletRequest)request, (String)this.getPasswordParam());
        if (Validator.isNull((String)password)) {
            return null;
        }
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        String authType = company.getAuthType();
        long userId = 0L;
        if (authType.equals("emailAddress")) {
            userId = UserLocalServiceUtil.getUserIdByEmailAddress((long)company.getCompanyId(), (String)login);
        } else if (authType.equals("screenName")) {
            userId = UserLocalServiceUtil.getUserIdByScreenName((long)company.getCompanyId(), (String)login);
        } else if (authType.equals("userId")) {
            userId = GetterUtil.getLong((String)login);
        } else {
            return null;
        }
        if (userId > 0L) {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String userPassword = user.getPassword();
            if (!user.isPasswordEncrypted()) {
                userPassword = PasswordEncryptorUtil.encrypt(userPassword);
            }
            String encPassword = PasswordEncryptorUtil.encrypt(password, userPassword);
            if (!userPassword.equals(password) && !userPassword.equals(encPassword)) {
                return null;
            }
        }
        String[] credentials = new String[]{String.valueOf(userId), password, Boolean.FALSE.toString()};
        return credentials;
    }

    protected String getLoginParam() {
        return _LOGIN_PARAM;
    }

    protected String getPasswordParam() {
        return _PASSWORD_PARAM;
    }
}

