/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NtlmAutoLogin
extends BaseAutoLogin {
    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (!PrefsPropsUtil.getBoolean(companyId, "ntlm.auth.enabled", PropsValues.NTLM_AUTH_ENABLED)) {
            return null;
        }
        String screenName = (String)request.getAttribute("NTLM_REMOTE_USER");
        if (screenName == null) {
            return null;
        }
        request.removeAttribute("NTLM_REMOTE_USER");
        User user = PortalLDAPImporterUtil.importLDAPUserByScreenName((long)companyId, (String)screenName);
        if (user == null) {
            return null;
        }
        this.addRedirect(request);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }
}

