/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import java.io.Serializable;

public class HttpPrincipal
implements Serializable {
    private static Log _log = LogFactoryUtil.getLog(HttpPrincipal.class);
    private long _companyId;
    private final String _login;
    private String _password;
    private final String _url;

    public HttpPrincipal() {
        this(null, null, null, true);
    }

    public HttpPrincipal(String url) {
        this(url, null, null, true);
    }

    public HttpPrincipal(String url, String login, String password) {
        this(url, login, password, false);
    }

    public HttpPrincipal(String url, String login, String password, boolean digested) {
        this._url = url;
        this._login = login;
        if (digested) {
            this._password = password;
        } else {
            try {
                this._password = PasswordEncryptorUtil.encrypt(password);
            }
            catch (PwdEncryptorException pee) {
                _log.error((Object)pee, (Throwable)pee);
            }
        }
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getLogin() {
        return this._login;
    }

    public String getPassword() {
        return this._password;
    }

    public String getUrl() {
        return this._url;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setPassword(String password) {
        this._password = password;
    }
}

