/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.facebook.FacebookConnectUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FacebookAutoLogin
extends BaseAutoLogin {
    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (!FacebookConnectUtil.isEnabled((long)companyId)) {
            return null;
        }
        User user = this.getUser(request, companyId);
        if (user == null) {
            return null;
        }
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.FALSE.toString()};
        return credentials;
    }

    protected User getUser(HttpServletRequest request, long companyId) throws PortalException {
        HttpSession session = request.getSession();
        String emailAddress = (String)session.getAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
        if (Validator.isNotNull((String)emailAddress)) {
            session.removeAttribute("FACEBOOK_USER_EMAIL_ADDRESS");
            return UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)emailAddress);
        }
        long facebookId = GetterUtil.getLong((String)((String)session.getAttribute("FACEBOOK_USER_ID")));
        if (facebookId > 0L) {
            return UserLocalServiceUtil.getUserByFacebookId((long)companyId, (long)facebookId);
        }
        return null;
    }
}

