/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.security.ldap.PortalLDAPImporterUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CASAutoLogin
extends BaseAutoLogin {
    private static Log _log = LogFactoryUtil.getLog(CASAutoLogin.class);

    @Deprecated
    protected User addUser(long companyId, String screenName) throws Exception {
        return PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)screenName);
    }

    protected String[] doHandleException(HttpServletRequest request, HttpServletResponse response, Exception e) {
        HttpSession session = request.getSession();
        if (e instanceof NoSuchUserException) {
            session.removeAttribute("CAS_LOGIN");
            session.setAttribute("CAS_NO_SUCH_USER_EXCEPTION", (Object)Boolean.TRUE);
        }
        _log.error((Object)e, (Throwable)e);
        return null;
    }

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        if (!PrefsPropsUtil.getBoolean(companyId, "cas.auth.enabled", PropsValues.CAS_AUTH_ENABLED)) {
            return null;
        }
        String login = (String)session.getAttribute("CAS_LOGIN");
        if (Validator.isNull((String)login)) {
            Object noSuchUserException = session.getAttribute("CAS_NO_SUCH_USER_EXCEPTION");
            if (noSuchUserException == null) {
                return null;
            }
            session.removeAttribute("CAS_NO_SUCH_USER_EXCEPTION");
            session.setAttribute("CAS_FORCE_LOGOUT", (Object)Boolean.TRUE);
            String redirect = PrefsPropsUtil.getString(companyId, "cas.no.such.user.redirect.url", PropsValues.CAS_NO_SUCH_USER_REDIRECT_URL);
            request.setAttribute("AUTO_LOGIN_REDIRECT", (Object)redirect);
            return null;
        }
        String authType = PrefsPropsUtil.getString(companyId, "company.security.auth.type", PropsValues.COMPANY_SECURITY_AUTH_TYPE);
        User user = null;
        if (PrefsPropsUtil.getBoolean(companyId, "cas.import.from.ldap", PropsValues.CAS_IMPORT_FROM_LDAP)) {
            try {
                user = authType.equals("screenName") ? PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)"", (String)login) : PortalLDAPImporterUtil.importLDAPUser((long)companyId, (String)login, (String)"");
            }
            catch (SystemException se) {
                // empty catch block
            }
        }
        if (user == null) {
            user = authType.equals("screenName") ? UserLocalServiceUtil.getUserByScreenName((long)companyId, (String)login) : UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)login);
        }
        this.addRedirect(request);
        String[] credentials = new String[]{String.valueOf(user.getUserId()), user.getPassword(), Boolean.TRUE.toString()};
        return credentials;
    }
}

