/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierConfiguration;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import jodd.util.Wildcard;

public class AuthVerifierPipeline {
    public static final String AUTH_TYPE = "auth.type";
    private static Log _log = LogFactoryUtil.getLog(AuthVerifierPipeline.class);
    private static AuthVerifierPipeline _instance = new AuthVerifierPipeline();
    private List<AuthVerifierConfiguration> _authVerifierConfigurations = new CopyOnWriteArrayList<AuthVerifierConfiguration>();
    private ServiceTracker<AuthVerifier, AuthVerifierConfiguration> _serviceTracker;

    public static String getAuthVerifierPropertyName(String className) {
        String simpleClassName = StringUtil.extractLast((String)className, (String)".");
        return "auth.verifier.".concat(simpleClassName).concat(".");
    }

    public static AuthVerifierResult verifyRequest(AccessControlContext accessControlContext) throws PortalException {
        return _instance._verifyRequest(accessControlContext);
    }

    private AuthVerifierPipeline() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AuthVerifier.class, (ServiceTrackerCustomizer)new AuthVerifierTrackerCustomizer());
        this._serviceTracker.open();
    }

    private AuthVerifierResult _createGuestVerificationResult(AccessControlContext accessControlContext) throws PortalException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
        HttpServletRequest request = accessControlContext.getRequest();
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        authVerifierResult.setUserId(defaultUserId);
        return authVerifierResult;
    }

    private List<AuthVerifierConfiguration> _getAuthVerifierConfigurations(AccessControlContext accessControlContext) {
        HttpServletRequest request = accessControlContext.getRequest();
        ArrayList<AuthVerifierConfiguration> authVerifierConfigurations = new ArrayList<AuthVerifierConfiguration>();
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        for (AuthVerifierConfiguration authVerifierConfiguration : this._authVerifierConfigurations) {
            if (!this._isMatchingRequestURI(authVerifierConfiguration = this._mergeAuthVerifierConfiguration(authVerifierConfiguration, accessControlContext), requestURI)) continue;
            authVerifierConfigurations.add(authVerifierConfiguration);
        }
        return authVerifierConfigurations;
    }

    private boolean _isMatchingRequestURI(AuthVerifierConfiguration authVerifierConfiguration, String requestURI) {
        AuthVerifier authVerifier = authVerifierConfiguration.getAuthVerifier();
        Properties properties = authVerifierConfiguration.getProperties();
        String[] urlsExcludes = StringUtil.split((String)properties.getProperty("urls.excludes"));
        if (urlsExcludes.length > 0 && Wildcard.matchOne((String)requestURI, (String[])urlsExcludes) > -1) {
            return false;
        }
        String[] urlsIncludes = StringUtil.split((String)properties.getProperty("urls.includes"));
        if (urlsIncludes.length == 0) {
            Class<?> authVerifierClass = authVerifier.getClass();
            _log.error((Object)("Auth verifier " + authVerifierClass.getName() + " does not have any URLs configured"));
            return false;
        }
        return Wildcard.matchOne((String)requestURI, (String[])urlsIncludes) > -1;
    }

    private AuthVerifierConfiguration _mergeAuthVerifierConfiguration(AuthVerifierConfiguration authVerifierConfiguration, AccessControlContext accessControlContext) {
        Map settings = accessControlContext.getSettings();
        String authVerifierSettingsKey = AuthVerifierPipeline.getAuthVerifierPropertyName(authVerifierConfiguration.getAuthVerifierClassName());
        boolean merge = false;
        Set settingsKeys = settings.keySet();
        Iterator iterator = settingsKeys.iterator();
        while (iterator.hasNext() && !merge) {
            String settingsKey = (String)iterator.next();
            if (!settingsKey.startsWith(authVerifierSettingsKey) || !(settings.get(settingsKey) instanceof String)) continue;
            merge = true;
        }
        if (!merge) {
            return authVerifierConfiguration;
        }
        AuthVerifierConfiguration mergedAuthVerifierConfiguration = new AuthVerifierConfiguration();
        mergedAuthVerifierConfiguration.setAuthVerifier(authVerifierConfiguration.getAuthVerifier());
        Properties mergedProperties = new Properties(authVerifierConfiguration.getProperties());
        for (String settingsKey : settings.keySet()) {
            Object settingsValue;
            if (!settingsKey.startsWith(authVerifierSettingsKey) || !((settingsValue = settings.get(settingsKey)) instanceof String)) continue;
            String propertiesKey = settingsKey.substring(authVerifierSettingsKey.length());
            mergedProperties.setProperty(propertiesKey, (String)settingsValue);
        }
        mergedAuthVerifierConfiguration.setProperties(mergedProperties);
        return mergedAuthVerifierConfiguration;
    }

    private Map<String, Object> _mergeSettings(Properties properties, Map<String, Object> settings) {
        HashMap<String, Object> mergedSettings = new HashMap<String, Object>(settings);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                mergedSettings.put((String)entry.getKey(), entry.getValue());
            }
        }
        return mergedSettings;
    }

    private AuthVerifierResult _verifyRequest(AccessControlContext accessControlContext) throws PortalException {
        if (accessControlContext == null) {
            throw new IllegalArgumentException("Access control context is null");
        }
        List<AuthVerifierConfiguration> authVerifierConfigurations = this._getAuthVerifierConfigurations(accessControlContext);
        for (AuthVerifierConfiguration authVerifierConfiguration : authVerifierConfigurations) {
            AuthVerifierResult authVerifierResult = null;
            AuthVerifier authVerifier = authVerifierConfiguration.getAuthVerifier();
            Properties properties = authVerifierConfiguration.getProperties();
            try {
                authVerifierResult = authVerifier.verify(accessControlContext, properties);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                Class<?> authVerifierClass = authVerifier.getClass();
                _log.debug((Object)("Skipping " + authVerifierClass.getName()), (Throwable)e);
                continue;
            }
            if (authVerifierResult == null) {
                Class<?> authVerifierClass = authVerifier.getClass();
                _log.error((Object)("Auth verifier " + authVerifierClass.getName() + " did not return an auth verifier result"));
                continue;
            }
            if (authVerifierResult.getState() == AuthVerifierResult.State.NOT_APPLICABLE) continue;
            Map<String, Object> settings = this._mergeSettings(properties, authVerifierResult.getSettings());
            settings.put(AUTH_TYPE, authVerifier.getAuthType());
            authVerifierResult.setSettings(settings);
            return authVerifierResult;
        }
        return this._createGuestVerificationResult(accessControlContext);
    }

    private class AuthVerifierTrackerCustomizer
    implements ServiceTrackerCustomizer<AuthVerifier, AuthVerifierConfiguration> {
        private AuthVerifierTrackerCustomizer() {
        }

        public AuthVerifierConfiguration addingService(ServiceReference<AuthVerifier> serviceReference) {
            if (Validator.isNull((Object)serviceReference.getProperty("urls.includes"))) {
                return null;
            }
            Registry registry = RegistryUtil.getRegistry();
            AuthVerifier authVerifier = (AuthVerifier)registry.getService(serviceReference);
            Class<?> authVerifierClass = authVerifier.getClass();
            AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
            authVerifierConfiguration.setAuthVerifier(authVerifier);
            authVerifierConfiguration.setAuthVerifierClassName(authVerifierClass.getName());
            authVerifierConfiguration.setProperties(PropertiesUtil.fromMap((Map)serviceReference.getProperties()));
            AuthVerifierPipeline.this._authVerifierConfigurations.add(0, authVerifierConfiguration);
            return authVerifierConfiguration;
        }

        public void modifiedService(ServiceReference<AuthVerifier> serviceReference, AuthVerifierConfiguration authVerifierConfiguration) {
            AuthVerifierConfiguration newAuthVerifierConfiguration = new AuthVerifierConfiguration();
            newAuthVerifierConfiguration.setAuthVerifier(authVerifierConfiguration.getAuthVerifier());
            newAuthVerifierConfiguration.setAuthVerifierClassName(authVerifierConfiguration.getAuthVerifierClassName());
            newAuthVerifierConfiguration.setProperties(PropertiesUtil.fromMap((Map)serviceReference.getProperties()));
            if (AuthVerifierPipeline.this._authVerifierConfigurations.remove(authVerifierConfiguration)) {
                AuthVerifierPipeline.this._authVerifierConfigurations.add(0, newAuthVerifierConfiguration);
            }
        }

        public void removedService(ServiceReference<AuthVerifier> serviceReference, AuthVerifierConfiguration authVerifierConfiguration) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            AuthVerifierPipeline.this._authVerifierConfigurations.remove(authVerifierConfiguration);
        }
    }
}

