/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.security.auth.AuthTokenWhitelist;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.util.Collections;
import java.util.Set;

@DoPrivileged
public class AuthTokenWhitelistImpl
implements AuthTokenWhitelist {
    private Set<String> _originCSRFWhitelist;
    private Set<String> _portletCSRFWhitelist;
    private Set<String> _portletCSRFWhitelistActions;
    private Set<String> _portletInvocationWhitelist;
    private Set<String> _portletInvocationWhitelistActions;

    public AuthTokenWhitelistImpl() {
        this.resetOriginCSRFWhitelist();
        this.resetPortletCSRFWhitelist();
        this.resetPortletCSRFWhitelistActions();
        this.resetPortletInvocationWhitelist();
        this.resetPortletInvocationWhitelistActions();
    }

    public Set<String> getOriginCSRFWhitelist() {
        return this._originCSRFWhitelist;
    }

    public Set<String> getPortletCSRFWhitelist() {
        return this._portletCSRFWhitelist;
    }

    public Set<String> getPortletCSRFWhitelistActions() {
        return this._portletCSRFWhitelistActions;
    }

    public Set<String> getPortletInvocationWhitelist() {
        return this._portletInvocationWhitelist;
    }

    public Set<String> getPortletInvocationWhitelistActions() {
        return this._portletInvocationWhitelistActions;
    }

    public boolean isOriginCSRFWhitelisted(long companyId, String origin) {
        Set<String> whitelist = this.getOriginCSRFWhitelist();
        for (String whitelistedOrigins : whitelist) {
            if (!origin.startsWith(whitelistedOrigins)) continue;
            return true;
        }
        return false;
    }

    public boolean isPortletCSRFWhitelisted(long companyId, String portletId, String strutsAction) {
        Set<String> whitelistActions;
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        Set<String> whitelist = this.getPortletCSRFWhitelist();
        if (whitelist.contains(rootPortletId)) {
            return true;
        }
        return Validator.isNotNull((String)strutsAction) && (whitelistActions = this.getPortletCSRFWhitelistActions()).contains(strutsAction) && this.isValidStrutsAction(companyId, rootPortletId, strutsAction);
    }

    public boolean isPortletInvocationWhitelisted(long companyId, String portletId, String strutsAction) {
        Set<String> whitelistActions;
        Set<String> whitelist = this.getPortletInvocationWhitelist();
        if (whitelist.contains(portletId)) {
            return true;
        }
        return Validator.isNotNull((String)strutsAction) && (whitelistActions = this.getPortletInvocationWhitelistActions()).contains(strutsAction) && this.isValidStrutsAction(companyId, portletId, strutsAction);
    }

    public boolean isValidSharedSecret(String sharedSecret) {
        if (Validator.isNull((String)sharedSecret)) {
            return false;
        }
        if (Validator.isNull((String)PropsValues.AUTH_TOKEN_SHARED_SECRET)) {
            return false;
        }
        return sharedSecret.equals(Encryptor.digest((String)PropsValues.AUTH_TOKEN_SHARED_SECRET));
    }

    public Set<String> resetOriginCSRFWhitelist() {
        this._originCSRFWhitelist = SetUtil.fromArray((Object[])PropsValues.AUTH_TOKEN_IGNORE_ORIGINS);
        this._originCSRFWhitelist = Collections.unmodifiableSet(this._originCSRFWhitelist);
        return this._originCSRFWhitelist;
    }

    public Set<String> resetPortletCSRFWhitelist() {
        this._portletCSRFWhitelist = SetUtil.fromArray((Object[])PropsValues.AUTH_TOKEN_IGNORE_PORTLETS);
        this._portletCSRFWhitelist = Collections.unmodifiableSet(this._portletCSRFWhitelist);
        return this._portletCSRFWhitelist;
    }

    public Set<String> resetPortletCSRFWhitelistActions() {
        this._portletCSRFWhitelistActions = SetUtil.fromArray((Object[])PropsValues.AUTH_TOKEN_IGNORE_ACTIONS);
        this._portletCSRFWhitelistActions = Collections.unmodifiableSet(this._portletCSRFWhitelistActions);
        return this._portletCSRFWhitelistActions;
    }

    public Set<String> resetPortletInvocationWhitelist() {
        this._portletInvocationWhitelist = SetUtil.fromArray((Object[])PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_WHITELIST);
        this._portletInvocationWhitelist = Collections.unmodifiableSet(this._portletInvocationWhitelist);
        return this._portletInvocationWhitelist;
    }

    public Set<String> resetPortletInvocationWhitelistActions() {
        this._portletInvocationWhitelistActions = SetUtil.fromArray((Object[])PropsValues.PORTLET_ADD_DEFAULT_RESOURCE_CHECK_WHITELIST_ACTIONS);
        this._portletInvocationWhitelistActions = Collections.unmodifiableSet(this._portletInvocationWhitelistActions);
        return this._portletInvocationWhitelistActions;
    }

    protected boolean isValidStrutsAction(long companyId, String portletId, String strutsAction) {
        try {
            Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
            if (portlet == null) {
                return false;
            }
            String strutsPath = strutsAction.substring(1, strutsAction.lastIndexOf(47));
            if (strutsPath.equals(portlet.getStrutsPath()) || strutsPath.equals(portlet.getParentStrutsPath())) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }
}

