/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthFailure;
import com.liferay.portal.security.auth.Authenticator;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceRegistrationMap;
import com.liferay.registry.util.StringPlus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthPipeline {
    private static AuthPipeline _instance = new AuthPipeline();
    private Map<String, Authenticator[]> _authenticators = new HashMap<String, Authenticator[]>();
    private Map<Authenticator, ServiceRegistration<Authenticator>> _authenticatorServiceRegistrations = new ServiceRegistrationMap();
    private ServiceTracker<Authenticator, Authenticator> _authenticatorServiceTracker;
    private Map<String, AuthFailure[]> _authFailures = new HashMap<String, AuthFailure[]>();
    private Map<AuthFailure, ServiceRegistration<AuthFailure>> _authFailureServiceRegistrations = new ServiceRegistrationMap();
    private ServiceTracker<AuthFailure, AuthFailure> _authFailureServiceTracker;

    public static int authenticateByEmailAddress(String key, long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, emailAddress, password, "emailAddress", headerMap, parameterMap);
    }

    public static int authenticateByScreenName(String key, long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, screenName, password, "screenName", headerMap, parameterMap);
    }

    public static int authenticateByUserId(String key, long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        return _instance._authenticate(key, companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap);
    }

    public static void onFailureByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, emailAddress, "emailAddress", headerMap, parameterMap);
    }

    public static void onFailureByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, screenName, "screenName", headerMap, parameterMap);
    }

    public static void onFailureByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        _instance._onFailure(key, companyId, String.valueOf(userId), "userId", headerMap, parameterMap);
    }

    public static void onMaxFailuresByEmailAddress(String key, long companyId, String emailAddress, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByEmailAddress(key, companyId, emailAddress, headerMap, parameterMap);
    }

    public static void onMaxFailuresByScreenName(String key, long companyId, String screenName, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByScreenName(key, companyId, screenName, headerMap, parameterMap);
    }

    public static void onMaxFailuresByUserId(String key, long companyId, long userId, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        AuthPipeline.onFailureByUserId(key, companyId, userId, headerMap, parameterMap);
    }

    public static void registerAuthenticator(String key, Authenticator authenticator) {
        _instance._registerAuthenticator(key, authenticator);
    }

    public static void registerAuthFailure(String key, AuthFailure authFailure) {
        _instance._registerAuthFailure(key, authFailure);
    }

    public static void unregisterAuthenticator(String key, Authenticator authenticator) {
        _instance._unregisterAuthenticator(key, authenticator);
    }

    public static void unregisterAuthFailure(String key, AuthFailure authFailure) {
        _instance._unregisterAuthFailure(key, authFailure);
    }

    private AuthPipeline() {
        Authenticator authenticator;
        AuthFailure authFailure;
        Registry registry = RegistryUtil.getRegistry();
        Filter authFailureFilter = registry.getFilter("(&(key=*)(objectClass=" + AuthFailure.class.getName() + "))");
        this._authFailureServiceTracker = registry.trackServices(authFailureFilter, (ServiceTrackerCustomizer)new AuthFailureServiceTrackerCustomizer());
        this._authFailureServiceTracker.open();
        this._authFailures.put("auth.failure", new AuthFailure[0]);
        for (String authFailureClassName : PropsValues.AUTH_FAILURE) {
            authFailure = (AuthFailure)InstancePool.get((String)authFailureClassName);
            this._registerAuthFailure("auth.failure", authFailure);
        }
        this._authFailures.put("auth.max.failures", new AuthFailure[0]);
        for (String authFailureClassName : PropsValues.AUTH_MAX_FAILURES) {
            authFailure = (AuthFailure)InstancePool.get((String)authFailureClassName);
            this._registerAuthFailure("auth.max.failures", authFailure);
        }
        Filter authenticatorFilter = registry.getFilter("(&(key=*)(objectClass=" + Authenticator.class.getName() + "))");
        this._authenticatorServiceTracker = registry.trackServices(authenticatorFilter, (ServiceTrackerCustomizer)new AuthenticatorServiceTrackerCustomizer());
        this._authenticatorServiceTracker.open();
        this._authenticators.put("auth.pipeline.post", new Authenticator[0]);
        for (String authenticatorClassName : PropsValues.AUTH_PIPELINE_POST) {
            authenticator = (Authenticator)InstancePool.get((String)authenticatorClassName);
            this._registerAuthenticator("auth.pipeline.post", authenticator);
        }
        this._authenticators.put("auth.pipeline.pre", new Authenticator[0]);
        for (String authenticatorClassName : PropsValues.AUTH_PIPELINE_PRE) {
            authenticator = (Authenticator)InstancePool.get((String)authenticatorClassName);
            this._registerAuthenticator("auth.pipeline.pre", authenticator);
        }
    }

    private int _authenticate(String key, long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        boolean skipLiferayCheck = false;
        Object[] authenticators = this._authenticators.get(key);
        if (ArrayUtil.isEmpty((Object[])authenticators)) {
            return 1;
        }
        for (Object authenticator : authenticators) {
            try {
                int authResult = -1;
                if (authType.equals("emailAddress")) {
                    authResult = authenticator.authenticateByEmailAddress(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    authResult = authenticator.authenticateByScreenName(companyId, login, password, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    long userId = GetterUtil.getLong((String)login);
                    authResult = authenticator.authenticateByUserId(companyId, userId, password, headerMap, parameterMap);
                }
                if (authResult == 2) {
                    skipLiferayCheck = true;
                    continue;
                }
                if (authResult == 1) continue;
                return authResult;
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
        if (skipLiferayCheck) {
            return 2;
        }
        return 1;
    }

    private void _onFailure(String key, long companyId, String login, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) throws AuthException {
        Object[] authFailures = this._authFailures.get(key);
        if (ArrayUtil.isEmpty((Object[])authFailures)) {
            return;
        }
        for (Object authFailure : authFailures) {
            try {
                if (authType.equals("emailAddress")) {
                    authFailure.onFailureByEmailAddress(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (authType.equals("screenName")) {
                    authFailure.onFailureByScreenName(companyId, login, headerMap, parameterMap);
                    continue;
                }
                if (!authType.equals("userId")) continue;
                long userId = GetterUtil.getLong((String)login);
                authFailure.onFailureByUserId(companyId, userId, headerMap, parameterMap);
            }
            catch (AuthException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
    }

    private void _registerAuthenticator(String key, Authenticator authenticator) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", key);
        ServiceRegistration serviceRegistration = registry.registerService(Authenticator.class, (Object)authenticator, properties);
        this._authenticatorServiceRegistrations.put(authenticator, (ServiceRegistration<Authenticator>)serviceRegistration);
    }

    private void _registerAuthFailure(String key, AuthFailure authFailure) {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", key);
        ServiceRegistration serviceRegistration = registry.registerService(AuthFailure.class, (Object)authFailure, properties);
        this._authFailureServiceRegistrations.put(authFailure, (ServiceRegistration<AuthFailure>)serviceRegistration);
    }

    private void _unregisterAuthenticator(String key, Authenticator authenticator) {
        ServiceRegistration<Authenticator> serviceRegistration = this._authenticatorServiceRegistrations.remove(authenticator);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private void _unregisterAuthFailure(String key, AuthFailure authFailure) {
        ServiceRegistration<AuthFailure> serviceRegistration = this._authFailureServiceRegistrations.remove(authFailure);
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }

    private class AuthFailureServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AuthFailure, AuthFailure> {
        private AuthFailureServiceTrackerCustomizer() {
        }

        public AuthFailure addingService(ServiceReference<AuthFailure> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AuthFailure authFailure = (AuthFailure)registry.getService(serviceReference);
            List keys = StringPlus.asList((Object)serviceReference.getProperty("key"));
            boolean added = false;
            for (String key : keys) {
                Object[] authFailures = (AuthFailure[])AuthPipeline.this._authFailures.get(key);
                if (authFailures == null) continue;
                added = true;
                authFailures = (AuthFailure[])ArrayUtil.append((Object[])authFailures, (Object)authFailure);
                AuthPipeline.this._authFailures.put(key, authFailures);
            }
            if (!added) {
                return null;
            }
            return authFailure;
        }

        public void modifiedService(ServiceReference<AuthFailure> serviceReference, AuthFailure authFailure) {
        }

        public void removedService(ServiceReference<AuthFailure> serviceReference, AuthFailure authFailure) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            List keys = StringPlus.asList((Object)serviceReference.getProperty("key"));
            for (String key : keys) {
                List authFailuresList;
                Object[] authFailures = (AuthFailure[])AuthPipeline.this._authFailures.get(key);
                if (authFailures == null || !(authFailuresList = ListUtil.fromArray((Object[])authFailures)).remove(authFailure)) continue;
                AuthPipeline.this._authFailures.put(key, authFailuresList.toArray(new AuthFailure[authFailuresList.size()]));
            }
        }
    }

    private class AuthenticatorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Authenticator, Authenticator> {
        private AuthenticatorServiceTrackerCustomizer() {
        }

        public Authenticator addingService(ServiceReference<Authenticator> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            Authenticator authenticator = (Authenticator)registry.getService(serviceReference);
            List keys = StringPlus.asList((Object)serviceReference.getProperty("key"));
            boolean added = false;
            for (String key : keys) {
                Object[] authenticators = (Authenticator[])AuthPipeline.this._authenticators.get(key);
                if (authenticators == null) continue;
                added = true;
                authenticators = (Authenticator[])ArrayUtil.append((Object[])authenticators, (Object)authenticator);
                AuthPipeline.this._authenticators.put(key, authenticators);
            }
            if (!added) {
                return null;
            }
            return authenticator;
        }

        public void modifiedService(ServiceReference<Authenticator> serviceReference, Authenticator authenticator) {
        }

        public void removedService(ServiceReference<Authenticator> serviceReference, Authenticator authenticator) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            List keys = StringPlus.asList((Object)serviceReference.getProperty("key"));
            for (String key : keys) {
                List authenticatorsList;
                Object[] authenticators = (Authenticator[])AuthPipeline.this._authenticators.get(key);
                if (authenticators == null || !(authenticatorsList = ListUtil.toList((Object[])authenticators)).remove(authenticator)) continue;
                AuthPipeline.this._authenticators.put(key, authenticatorsList.toArray(new Authenticator[authenticatorsList.size()]));
            }
        }
    }
}

