/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ac;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.security.ac.AccessControl;
import com.liferay.portal.security.ac.AccessControlImpl;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthException;
import com.liferay.portal.security.auth.AuthVerifierResult;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessControlUtil {
    private static AccessControl _accessControl;
    private static ThreadLocal<AccessControlContext> _accessControlContext;

    public static AccessControl getAccessControl() {
        if (_accessControl == null) {
            _accessControl = new AccessControlImpl();
        }
        return _accessControl;
    }

    public static AccessControlContext getAccessControlContext() {
        return _accessControlContext.get();
    }

    public static void initAccessControlContext(HttpServletRequest request, HttpServletResponse response, Map<String, Object> settings) {
        AccessControlUtil.getAccessControl().initAccessControlContext(request, response, settings);
    }

    public static void initContextUser(long userId) throws AuthException {
        AccessControlUtil.getAccessControl().initContextUser(userId);
    }

    public static void setAccessControlContext(AccessControlContext accessControlContext) {
        _accessControlContext.set(accessControlContext);
    }

    public static AuthVerifierResult.State verifyRequest() throws PortalException {
        return AccessControlUtil.getAccessControl().verifyRequest();
    }

    public void setAccessControl(AccessControl accessControl) {
        _accessControl = accessControl;
    }

    static {
        _accessControlContext = new AutoResetThreadLocal(AccessControlUtil.class + "._accessControlContext");
    }
}

