/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.ac;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.ac.AccessControlAdvisor;
import com.liferay.portal.security.ac.AccessControlUtil;
import com.liferay.portal.security.ac.AccessControlled;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.sso.SSOUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AccessControlAdvisorImpl
implements AccessControlAdvisor {
    @Override
    public void accept(Method method, AccessControlled accessControlled) throws SecurityException {
        if (accessControlled.hostAllowedValidationEnabled()) {
            this.checkAllowedHosts();
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (!(accessControlled.guestAccessEnabled() || permissionChecker != null && permissionChecker.isSignedIn())) {
            throw new SecurityException("Authenticated access required");
        }
    }

    protected void checkAllowedHosts() {
        String hostsAllowedString;
        Object[] hostsAllowed;
        Set hostsAllowedSet;
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        HttpServletRequest request = accessControlContext.getRequest();
        if (!SSOUtil.isAccessAllowed(request, hostsAllowedSet = SetUtil.fromArray((Object[])(hostsAllowed = StringUtil.split((String)(hostsAllowedString = MapUtil.getString((Map)accessControlContext.getSettings(), (String)"hosts.allowed"))))))) {
            throw new SecurityException("Access denied for " + request.getRemoteAddr());
        }
    }
}

